/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.actions;

import com.ecc.ide.ant.AntObject;
import com.ecc.ide.ant.RunAntInIDE;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.views.PrjViewPanel;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.ide.plugin.views.actions.BaseAction;
import com.ecc.ide.templet.TempletWizard;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class TempletAction
extends BaseAction {
    private String className = "";
    private XMLNode templetNode = null;
    private String templetFile = "";

    public TempletAction(PrjViewPanel prjViewPanel) {
        this.prjViewPanel = prjViewPanel;
    }

    public void setTempletFile(String templetFile) {
        this.templetFile = templetFile;
    }

    public void run() {
        this.templetFile = String.valueOf(ECCIDEPlugin.getDir("/")) + "/" + this.templetFile;
        this.templetNode = this.loadXMLFile(this.templetFile);
        if (this.templetNode == null) {
            return;
        }
        XMLNode wizardNode = this.templetNode.findChild("wizard");
        if (wizardNode == null) {
            return;
        }
        this.className = wizardNode.getAttrValue("class");
        if (this.className == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.prjViewPanel.getTreeViewer().getSelection();
        this.node = (PrjViewXMLNode)selection.getFirstElement();
        try {
            Object obj = Class.forName(this.className).newInstance();
            TempletWizard wizard = (TempletWizard)((Object)obj);
            wizard.init(this.node, this.templetNode);
            WizardDialog dialog = new WizardDialog(this.prjViewPanel.getShell(), (IWizard)wizard);
            dialog.create();
            int result = dialog.open();
            if (result == 1) {
                return;
            }
            AntObject antObject = wizard.getAntObject();
            RunAntInIDE.run(antObject);
            this.prjViewPanel.reload(this.node);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private XMLNode loadXMLFile(String fileName) {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(fileName);
            return node;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

