/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.dataDict;

import com.ecc.ide.editor.EditorBeanPropertyPanel;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.data.DataElementWrapper;
import com.ecc.ide.editor.data.Messages;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ContextDataViewPanel
extends Composite {
    private Label projectLabel;
    private Text dataIDText;
    private Text dataNameText;
    private Tree dataTree;
    private TableTree tableTree;
    private Button locateByIDButton;
    private Button locateByNameButton;
    private Button forwardButton;
    private Button backwordButton;
    private EditorProfile profile;
    int[] weights;
    private EditorBeanPropertyPanel editorBeanPropertyPanel;
    private XMLNode dataDictionary;
    private XMLNode dataTypeDefNode;
    private XMLNode dataTypesNode;
    private boolean sortAscending = false;
    private Image folderImage = null;
    private XMLNode currentClassifyNode;
    private boolean editable = true;
    TableTreeItem[] dndSelection = null;
    int count = 0;
    private XMLNode channelNodes = null;
    private Vector dataClassifies = new Vector();

    public ContextDataViewPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.createControls(parent, style, this.editable, 65538);
    }

    public ContextDataViewPanel(Composite parent, int style, boolean editable, int tableStyle) {
        super(parent, style);
        this.createControls(parent, style, editable, tableStyle);
    }

    private void createControls(Composite parent, int style, boolean editable, int tableStyle) {
        this.editable = editable;
        this.projectLabel = new Label((Composite)this, 0);
        this.projectLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SashForm sashForm = new SashForm((Composite)this, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite((Composite)sashForm, 0);
        composite.setLayout((Layout)new GridLayout());
        this.dataTree = new Tree(composite, 2048);
        this.dataTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextDataViewPanel.this.setActivateDataClassify();
            }
        });
        this.dataTree.setLayoutData((Object)new GridData(1808));
        Composite dataComposite = new Composite((Composite)sashForm, 0);
        dataComposite.setLayout((Layout)new GridLayout());
        this.tableTree = new TableTree(dataComposite, 0x800 | tableStyle);
        this.tableTree.setLayoutData((Object)new GridData(1808));
        Table table = this.tableTree.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn DataIdColumn = new TableColumn(table, 0);
        DataIdColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        DataIdColumn.setWidth(100);
        DataIdColumn.setText(Messages.getString("DataDictionaryPanel.DataID_17"));
        TableColumn DataLabelColumn = new TableColumn(table, 0);
        DataLabelColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        DataLabelColumn.setWidth(100);
        DataLabelColumn.setText(Messages.getString("DataDictionaryPanel.DataName_18"));
        TableColumn tableColumn_8 = new TableColumn(table, 0);
        tableColumn_8.setWidth(100);
        tableColumn_8.setText(Messages.getString("DataDictionaryPanel.DataField/Collection_2"));
        TableColumn tableColumn_1 = new TableColumn(table, 0);
        tableColumn_1.setWidth(100);
        tableColumn_1.setText(Messages.getString("DataDictionaryPanel.Access_Mode_3"));
        TableColumn DataTypeColumn = new TableColumn(table, 0);
        DataTypeColumn.setWidth(100);
        DataTypeColumn.setText(Messages.getString("DataDictionaryPanel.DataType_19"));
        TableColumn tableColumn_5 = new TableColumn(table, 0);
        tableColumn_5.setWidth(100);
        tableColumn_5.setText(Messages.getString("DataDictionaryPanel.Document_20"));
        GridData gridData_5 = new GridData(1808);
        gridData_5.heightHint = 114;
        gridData_5.horizontalSpan = 4;
        table.setLayoutData((Object)gridData_5);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        Composite searchComposite = new Composite((Composite)sashForm, 0);
        searchComposite.setVisible(false);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        searchComposite.setLayout((Layout)gridLayout_1);
        Label fdLabel = new Label(searchComposite, 0);
        fdLabel.setText(Messages.getString("DataDictionaryEditPanel.finding"));
        this.dataIDText = new Text(searchComposite, 2048);
        GridData gridData_11 = new GridData();
        gridData_11.widthHint = 80;
        this.dataIDText.setLayoutData((Object)gridData_11);
        this.dataIDText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ContextDataViewPanel.this.locateDataDefine();
            }
        });
        Group group_2 = new Group(searchComposite, 0);
        group_2.setLayout((Layout)new GridLayout());
        this.forwardButton = new Button((Composite)group_2, 16);
        this.forwardButton.setText(Messages.getString("DataDictionaryEditPanel.forward"));
        this.forwardButton.setSelection(true);
        this.backwordButton = new Button((Composite)group_2, 16);
        this.backwordButton.setText(Messages.getString("DataDictionaryEditPanel.backward"));
        Group group_1 = new Group(searchComposite, 0);
        group_1.setLayout((Layout)new GridLayout());
        this.locateByIDButton = new Button((Composite)group_1, 32);
        this.locateByIDButton.setText(Messages.getString("DataDictionaryEditPanel.DataId"));
        this.locateByIDButton.setSelection(true);
        this.locateByNameButton = new Button((Composite)group_1, 32);
        this.locateByNameButton.setText(Messages.getString("DataDictionaryEditPanel.DataName"));
        Label fdLabel_1 = new Label(searchComposite, 0);
        Button button2 = new Button(searchComposite, 8);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContextDataViewPanel.this.locateDataDefine();
            }
        });
        button2.setText(Messages.getString("DataDictionaryEditPanel.Search_the_Data_Define_3"));
        this.createTableDragSource(this.tableTree);
        sashForm.setWeights(new int[]{1, 3, 1});
    }

    private DragSource createTableDragSource(final TableTree table) {
        DragSource dragSource = new DragSource((Control)table.getTable(), 3);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        dragSource.setTransfer(types);
        dragSource.addDragListener(new DragSourceListener(){
            String sourceNames = null;

            public void dragStart(DragSourceEvent event) {
                TableTreeItem[] items = table.getSelection();
                ContextDataViewPanel.this.dndSelection = new TableTreeItem[items.length];
                ContextDataViewPanel.this.count = 0;
                int i = 0;
                while (i < items.length) {
                    if (items[i].getParentItem() == null && items[i].getData() != null || items[i].getParentItem().getData() == null) {
                        ContextDataViewPanel.this.dndSelection[ContextDataViewPanel.this.count++] = items[i];
                    }
                    ++i;
                }
                this.sourceNames = null;
                event.doit = ContextDataViewPanel.this.count > 0;
            }

            public void dragFinished(DragSourceEvent event) {
                ContextDataViewPanel.this.dragSourceHandleDragFinished(event, this.sourceNames);
                ContextDataViewPanel.this.dndSelection = null;
                this.sourceNames = null;
            }

            public void dragSetData(DragSourceEvent event) {
                TextTransfer transfer = TextTransfer.getInstance();
                if (ContextDataViewPanel.this.dndSelection == null || ContextDataViewPanel.this.dndSelection.length == 0) {
                    return;
                }
                if (!transfer.isSupportedType(event.dataType)) {
                    return;
                }
                this.sourceNames = "session:";
                int i = 0;
                while (i < ContextDataViewPanel.this.count) {
                    XMLNode node = (XMLNode)ContextDataViewPanel.this.dndSelection[i].getData();
                    this.sourceNames = String.valueOf(this.sourceNames) + node.getAttrValue("id") + ";";
                    ++i;
                }
                event.data = this.sourceNames;
            }
        });
        return dragSource;
    }

    private void dragSourceHandleDragFinished(DragSourceEvent event, String sourceNames) {
        if (sourceNames == null) {
            return;
        }
        if (event.detail != 2) {
            return;
        }
    }

    public Object getSelectPosition() {
        return null;
    }

    public Vector getSelectedDatas() {
        Vector<Object> datas = new Vector<Object>();
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length <= 0) {
            return datas;
        }
        int i = 0;
        while (i < selectItems.length) {
            TableTreeItem selectedItem = selectItems[i];
            if (selectedItem.getParentItem() == null) {
                datas.addElement(selectedItem.getData());
            }
            ++i;
        }
        return datas;
    }

    public void addDataElementToContent(TableTreeItem pItem, XMLNode node) {
        try {
            Vector childs = node.getChilds();
            int i = 0;
            while (i < childs.size()) {
                XMLNode aNode = (XMLNode)childs.elementAt(i);
                if (aNode.getNodeName().equals("dataGroup")) {
                    TableTreeItem aItem = null;
                    aItem = pItem != null ? new TableTreeItem(pItem, 0) : new TableTreeItem(this.tableTree, 0);
                    aItem.setText(aNode.getAttrValue("id"));
                    if (aNode.getAttrValue("name") != null) {
                        aItem.setText(1, aNode.getAttrValue("name"));
                    }
                    aItem.setText(2, aNode.getNodeName());
                    this.addDataElementToContent(aItem, aNode);
                } else if (aNode.getNodeName().equals("refData")) {
                    String dataType;
                    XMLNode dataNode = this.dataDictionary.findChildNode(aNode.getAttrValue("refId"));
                    TableTreeItem aItem = null;
                    aItem = pItem != null ? new TableTreeItem(pItem, 0) : new TableTreeItem(this.tableTree, 0);
                    aItem.setText(dataNode.getAttrValue("id"));
                    if (dataNode.getAttrValue("label") != null) {
                        aItem.setText(1, dataNode.getAttrValue("label"));
                    }
                    if ("true".equals(dataNode.getAttrValue("isSecureField"))) {
                        aItem.setText(2, String.valueOf(dataNode.getNodeName()) + "[SEC]");
                    } else {
                        aItem.setText(2, dataNode.getNodeName());
                    }
                    if (aNode.getAttrValue("access") != null) {
                        aItem.setText(3, aNode.getAttrValue("access"));
                    }
                    if ((dataType = dataNode.getAttrValue("dataType")) != null) {
                        aItem.setText(4, dataType);
                    }
                    if (dataNode.getAttrValue("desc") != null) {
                        aItem.setText(5, dataNode.getAttrValue("desc"));
                    }
                    aItem.setData((Object)dataNode);
                    this.addDataElementToContent(aItem, dataNode);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEditorProfile(EditorProfile profile) {
        this.profile = profile;
        if (profile != null) {
            this.folderImage = profile.getElement("dataDictionary.xml").getImage();
        }
    }

    public void setDataDictionary(XMLNode node) {
        this.dataDictionary = node;
        this.dataTypesNode = node.getChild("DataTypes");
        if (this.dataTypesNode == null) {
            this.dataTypesNode = new XMLNode();
            this.dataTypesNode.setNodeName("DataTypes");
            node.add(this.dataTypesNode);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadDataDefineTree(TreeItem pItem, XMLNode pNode) {
        childs = pNode.getChilds();
        if (childs == null) {
            return;
        }
        i = 0;
        while (i < childs.size()) {
            block4: {
                block6: {
                    block5: {
                        node = (XMLNode)childs.elementAt(i);
                        currentNodeName = node.getNodeName();
                        itemLabel = "datas";
                        if (currentNodeName.equals("#text") || currentNodeName.equals("document")) break block4;
                        if (!currentNodeName.equals("root")) break block5;
                        node = node.getChild("datas");
                        itemLabel = "RootCtx";
                        ** GOTO lbl-1000
                    }
                    if (currentNodeName.equals("CommonData") || currentNodeName.equals("MCITransaction")) break block4;
                    if (!currentNodeName.equals("channel")) break block6;
                    itemLabel = String.valueOf(node.getAttrValue("id")) + "ChannelCtx";
                    node = node.getChild("sessionDatas");
                    ** GOTO lbl-1000
                }
                if (currentNodeName.equals("channelSettings")) {
                    this.loadDataDefineTree(pItem, node);
                } else lbl-1000:
                // 3 sources

                {
                    item = new TreeItem(pItem, 0);
                    item.setText(itemLabel);
                    item.setData((Object)node);
                    item.setImage(this.folderImage);
                    this.dataClassifies.addElement(node);
                }
            }
            ++i;
        }
    }

    private void setActivateDataItem() {
        TableTreeItem[] selectItems = this.tableTree.getSelection();
        if (selectItems.length != 1) {
            return;
        }
        if (!this.editable) {
            return;
        }
        TableTreeItem selectedItem = selectItems[0];
        XMLNode node = (XMLNode)selectItems[0].getData();
        if (node.getNodeName().equals("dataElement")) {
            String dataTypeId = node.getAttrValue("dataType");
            XMLNode dataTypeNode = this.dataTypeDefNode.findChildNode(dataTypeId);
            if (dataTypeNode != null) {
                Element element = new Element();
                ElementAttribute attr = null;
                XMLNode attrsNode = dataTypeNode.getChild("attributes");
                int i = 0;
                while (i < attrsNode.getChilds().size()) {
                    XMLNode attrNode = (XMLNode)attrsNode.getChilds().elementAt(i);
                    if ("attr".equals(attrNode.getNodeName())) {
                        attr = new ElementAttribute(attrNode);
                        element.addAttribute(attr);
                    }
                    ++i;
                }
                DataElementWrapper aWrapper = new DataElementWrapper(node, element);
                this.editorBeanPropertyPanel.showWrapperProperties(aWrapper);
            } else {
                this.editorBeanPropertyPanel.showWrapperProperties(null);
            }
        } else {
            this.editorBeanPropertyPanel.showWrapperProperties(null);
        }
    }

    private void setActivateDataClassify() {
        TreeItem[] items = this.dataTree.getSelection();
        if (items.length != 1) {
            return;
        }
        XMLNode node = (XMLNode)items[0].getData();
        if (this.currentClassifyNode == node) {
            return;
        }
        this.tableTree.removeAll();
        this.currentClassifyNode = node;
        if (items[0].getParentItem() == null) {
            this.showAllDataElement();
            return;
        }
        try {
            String classifyStr = node.getAttrValue("name");
            if (classifyStr == null) {
                classifyStr = "";
            }
            this.addDataElementToContent(null, node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSelectPosition(Object obj) {
    }

    private void showAllDataElement() {
        int i = 0;
        while (i < this.dataClassifies.size()) {
            XMLNode node = (XMLNode)this.dataClassifies.elementAt(i);
            this.addDataElementToContent(null, node);
            ++i;
        }
    }

    private void locateDataDefine() {
        int i;
        boolean locateByID = this.locateByIDButton.getSelection();
        String idStr = this.dataIDText.getText();
        String locateStr = idStr;
        if (locateStr.length() == 0) {
            return;
        }
        boolean idx = false;
        boolean findId = this.locateByIDButton.getSelection();
        boolean findName = this.locateByNameButton.getSelection();
        TableTreeItem[] items = this.tableTree.getItems();
        int itemIdx = -1;
        int startIdx = 0;
        TableTreeItem[] sItems = this.tableTree.getSelection();
        if (this.forwardButton.getSelection()) {
            if (sItems != null && sItems.length > 0) {
                startIdx = this.tableTree.indexOf(sItems[0]) + 1;
            }
            i = startIdx;
            while (i < items.length) {
                String aItemStr;
                if (findId && (aItemStr = items[i].getText(0)) != null && aItemStr.indexOf(locateStr) != -1) {
                    itemIdx = i;
                    break;
                }
                if (findName && (aItemStr = items[i].getText(1)) != null && aItemStr.indexOf(locateStr) != -1) {
                    itemIdx = i;
                    break;
                }
                ++i;
            }
        } else {
            if (sItems != null && sItems.length > 0) {
                startIdx = this.tableTree.indexOf(sItems[0]) - 1;
            }
            i = startIdx;
            while (i >= 0) {
                String aItemStr;
                if (findId && (aItemStr = items[i].getText(0)) != null && aItemStr.indexOf(locateStr) != -1) {
                    itemIdx = i;
                    break;
                }
                if (findName && (aItemStr = items[i].getText(1)) != null && aItemStr.indexOf(locateStr) != -1) {
                    itemIdx = i;
                    break;
                }
                --i;
            }
        }
        if (itemIdx != -1) {
            TableTreeItem[] selItems = new TableTreeItem[]{items[itemIdx]};
            this.tableTree.setSelection(selItems);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"message...", (String)Messages.getString("DataDictionaryEditPanel.No_data_element_was_found_!_5"));
        }
    }

    public void setDataTypeDefNode(XMLNode node) {
        this.dataTypeDefNode = node;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
        super.checkSubclass();
    }

    public void setSearchWord(String searchWord) {
        try {
            HashMap dict = new HashMap();
            this.setupIdx(this.dataDictionary, dict);
            if (dict.get(searchWord.toLowerCase()) != null) {
                Object obj = dict.get(searchWord.toLowerCase());
                TableTreeItem[] items = this.tableTree.getItems();
                int i = 0;
                while (i < items.length) {
                    if (obj.equals(items[i].getData())) {
                        this.tableTree.setSelection(new TableTreeItem[]{items[i]});
                        return;
                    }
                    ++i;
                }
                this.dataTree.setSelection(new TreeItem[]{this.dataTree.getItem(0)});
                this.setActivateDataClassify();
                items = this.tableTree.getItems();
                i = 0;
                while (i < items.length) {
                    if (obj.equals(items[i].getData())) {
                        this.tableTree.setSelection(new TableTreeItem[]{items[i]});
                        return;
                    }
                    ++i;
                }
            } else {
                TableTreeItem[] items = this.tableTree.getItems();
                int i = 0;
                while (i < items.length) {
                    XMLNode node = (XMLNode)items[i].getData();
                    if (node.getAttrValue("id") != null && node.getAttrValue("id").toLowerCase().indexOf(searchWord.toLowerCase()) != -1) {
                        this.tableTree.setSelection(new TableTreeItem[]{items[i]});
                        return;
                    }
                    ++i;
                }
                String key = "";
                Object[] keys = dict.keySet().toArray();
                int i2 = 0;
                while (i2 < keys.length) {
                    if (keys[i2].toString().indexOf(searchWord.toLowerCase()) != -1) {
                        key = keys[i2].toString();
                        break;
                    }
                    ++i2;
                }
                if (key.length() == 0) {
                    return;
                }
                Object obj = dict.get(key);
                this.dataTree.setSelection(new TreeItem[]{this.dataTree.getItem(0)});
                this.setActivateDataClassify();
                items = this.tableTree.getItems();
                int i3 = 0;
                while (i3 < items.length) {
                    if (obj.equals(items[i3].getData())) {
                        this.tableTree.setSelection(new TableTreeItem[]{items[i3]});
                        return;
                    }
                    ++i3;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupIdx(XMLNode rootNode, HashMap dict) {
        int i = rootNode.getChilds().size() - 1;
        while (i >= 0) {
            String key;
            XMLNode node = (XMLNode)rootNode.getChilds().elementAt(i);
            if ("dataElement".equals(node.getNodeName())) {
                key = node.getAttrValue("id");
                key = key.toLowerCase();
                dict.put(key, node);
                this.setupIdx(node, dict);
            }
            if ("dataCollection".equals(node.getNodeName())) {
                key = node.getAttrValue("id");
                key = key.toLowerCase();
                dict.put(key, node);
                this.setupIdx(node, dict);
            }
            --i;
        }
    }

    public void setProject(IProject project) {
        this.projectLabel.setText(project.getName());
    }

    public void setChannelNode(XMLNode channelNodes) {
        this.channelNodes = channelNodes;
        this.dataTree.removeAll();
        TreeItem item = new TreeItem(this.dataTree, 0);
        item.setData((Object)channelNodes);
        item.setText("ContextData");
        item.setImage(this.folderImage);
        this.dataClassifies.removeAllElements();
        this.dataClassifies.addElement(channelNodes);
        this.loadDataDefineTree(item, channelNodes);
        this.tableTree.removeAll();
        this.showAllDataElement();
        this.currentClassifyNode = channelNodes;
        item.setExpanded(true);
    }

    public void clearTable() {
        this.tableTree.removeAll();
        this.dataTree.removeAll();
        this.dataClassifies.removeAllElements();
        this.update();
    }
}

