/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.dataDict;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.editors.BIZModelEditor;
import com.ecc.ide.plugin.editors.BizSettingsEditor;
import com.ecc.ide.plugin.views.dataDict.ContextDataViewPanel;
import com.ecc.ide.plugin.views.dataDict.DataDictListener;
import com.ecc.ide.plugin.views.dataDict.DataDictViewPanel;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class DataDictionaryView
extends ViewPart
implements ContentChangedListener,
BuildProblemReporter {
    private DataDictViewPanel dataDictionaryPanel;
    private ContextDataViewPanel contextDataPanel;
    private IProject[] projects = null;
    private boolean isChanged = false;
    private Action prjSelectAction = null;
    private Action syncedAction = null;
    private IProject curProject = null;
    private TabFolder tabFolder = null;

    public static void refreshCtxDataView(IEditorPart bizEditor) {
    }

    public void init(IViewSite site) throws PartInitException {
        this.projects = this.getEMPProjects();
        super.init(site);
        new DataDictListener(this);
    }

    public IProject[] getEMPProjects() {
        ArrayList<IProject> prjList = new ArrayList<IProject>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] prjs = workspace.getRoot().getProjects();
        int i = 0;
        while (i < prjs.length) {
            IFolder folder;
            if (prjs[i].isOpen() && (folder = prjs[i].getFolder("designFiles")) != null && folder.exists()) {
                prjList.add(prjs[i]);
            }
            ++i;
        }
        return prjList.toArray(new IProject[0]);
    }

    public void createPartControl(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        TabItem dataDictItem = new TabItem(this.tabFolder, 0);
        dataDictItem.setText("DataDict");
        this.dataDictionaryPanel = new DataDictViewPanel((Composite)this.tabFolder, false, 0);
        if (this.projects != null && this.projects.length > 0) {
            this.creatDataDictPanel(this.projects[0]);
        }
        dataDictItem.setControl((Control)this.dataDictionaryPanel);
        TabItem contextItem = new TabItem(this.tabFolder, 0);
        contextItem.setText("ContextData");
        this.contextDataPanel = new ContextDataViewPanel((Composite)this.tabFolder, 0);
        contextItem.setControl((Control)this.contextDataPanel);
        this.makeActions();
    }

    public void creatDataDictPanel(IProject project) {
        try {
            this.curProject = project;
            EditorProfile profile = IDEProfile.getEditorProfile(this.curProject, 1);
            this.dataDictionaryPanel.setEditorProfile(profile);
            XMLNode dataDictionary = IDEContent.getSettingNode(this.curProject, 0);
            dataDictionary = (XMLNode)dataDictionary.clone();
            dataDictionary.addContentChangedListener(this, this.curProject, 0);
            this.dataDictionaryPanel.setDataDictionary(dataDictionary);
            this.dataDictionaryPanel.setProject(project);
            XMLNode dataTypeDefNode = IDEContent.getSettingNode(this.curProject, 34);
            this.dataDictionaryPanel.setDataTypeDefNode(dataTypeDefNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void creatContextDataPanel(IFile file) {
        try {
            if (!this.syncedAction.isChecked()) {
                return;
            }
            this.curProject = file.getProject();
            this.contextDataPanel.setProject(this.curProject);
            EditorProfile profile = IDEProfile.getEditorProfile(this.curProject, 1);
            this.contextDataPanel.setEditorProfile(profile);
            XMLNode dataDictionary = IDEContent.getSettingNode(this.curProject, 0);
            this.contextDataPanel.setDataDictionary(dataDictionary);
            String groupId = IDEContent.getGroupId(file.getProjectRelativePath().toString());
            XMLNode channelNodes = IDEContent.getSettingNode(this.curProject, groupId, 19);
            channelNodes = (XMLNode)channelNodes.clone();
            this.contextDataPanel.setChannelNode(channelNodes);
            XMLNode dataTypeDefNode = IDEContent.getSettingNode(this.curProject, 34);
            this.contextDataPanel.setDataTypeDefNode(dataTypeDefNode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initContextDataPanel() {
        try {
            IWorkbenchPage workbenchPage = ECCIDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart part = workbenchPage.getActiveEditor();
            if (part == null || !(part instanceof BIZModelEditor) && !(part instanceof BizSettingsEditor)) {
                return;
            }
            IFileEditorInput editorInput = (IFileEditorInput)part.getEditorInput();
            IFile file = editorInput.getFile();
            this.creatContextDataPanel(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void makeActions() {
        this.prjSelectAction = new Action("project", 4){

            public void run() {
            }
        };
        this.prjSelectAction.setText("project");
        this.prjSelectAction.setToolTipText("project");
        this.prjSelectAction.setMenuCreator((IMenuCreator)new PrjMenuCreator());
        try {
            URL url = ECCIDEPlugin.getDefault().find((IPath)new Path("icons/project.gif"));
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.prjSelectAction.setImageDescriptor(desc);
        }
        catch (Exception url) {
            // empty catch block
        }
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.prjSelectAction);
        this.syncedAction = new Action("synced", 2){

            public void run() {
                if (DataDictionaryView.this.syncedAction.isChecked()) {
                    DataDictionaryView.this.syncedAction.setChecked(true);
                    DataDictionaryView.this.initContextDataPanel();
                } else {
                    DataDictionaryView.this.syncedAction.setChecked(false);
                    DataDictionaryView.this.clearCtxDataPanel();
                }
            }
        };
        this.syncedAction.setText("synced");
        this.syncedAction.setToolTipText("synced");
        try {
            URL url = ECCIDEPlugin.getDefault().find((IPath)new Path("icons/synced.gif"));
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.syncedAction.setImageDescriptor(desc);
        }
        catch (Exception exception) {
            // empty catch block
        }
        manager.add((IAction)this.syncedAction);
    }

    public void setFocus() {
    }

    public void contentChanged(ContentChangedEvent event) {
        if (!this.isChanged) {
            this.isChanged = true;
            this.firePropertyChange(257);
            this.firePropertyChange(258);
        }
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
    }

    public void reportProblem(int type, String msg, String detail) {
    }

    public IProject getCurProject() {
        return this.curProject;
    }

    public void clearCtxDataPanel() {
        this.contextDataPanel.clearTable();
    }

    private class PrjMenuCreator
    implements IMenuCreator {
        Menu prjMenu;

        private PrjMenuCreator() {
        }

        public void dispose() {
            if (this.prjMenu != null) {
                this.prjMenu.dispose();
                this.prjMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            DataDictionaryView.this.projects = DataDictionaryView.this.getEMPProjects();
            this.prjMenu = new Menu(parent);
            int i = 0;
            while (i < DataDictionaryView.this.projects.length) {
                MenuItem item = new MenuItem(this.prjMenu, 16);
                item.setText(DataDictionaryView.this.projects[i].getName());
                int idx = i++;
                item.addSelectionListener((SelectionListener)new SelectionAdapter(this, idx){
                    final /* synthetic */ PrjMenuCreator this$1;
                    private final /* synthetic */ int val$idx;
                    {
                        this.this$1 = prjMenuCreator;
                        this.val$idx = n;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        PrjMenuCreator.access$1(this.this$1).creatDataDictPanel(DataDictionaryView.access$1(PrjMenuCreator.access$1(this.this$1))[this.val$idx]);
                    }
                });
            }
            return this.prjMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        static /* synthetic */ DataDictionaryView access$1(PrjMenuCreator prjMenuCreator) {
            return prjMenuCreator.DataDictionaryView.this;
        }
    }
}

