/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.views.table;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.views.table.TableColumnInfo;
import com.ecc.ide.plugin.views.table.TableInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TableViewProcedureSelectPanel
extends Composite {
    private Table infoListTable;
    private Tree dbCatalogTree;
    private Connection connection;
    private String selectedTable = null;
    private TableColumn tableColumn_0;
    private TableColumn tableColumn_1;
    private TableColumn tableColumn_2;
    private TableColumn tableColumn_3;
    private TableColumn tableColumn_4;
    private TableColumn tableColumn_5;
    private TableColumn tableColumn_6;
    private TreeItem tableItem;
    private TreeItem viewItem;
    private boolean checkSelect = false;
    TreeItem selectItem;
    IProject project;

    public void setCheckSelect(boolean value) {
        this.checkSelect = value;
    }

    public TableViewProcedureSelectPanel(Composite parent, int style, IProject project) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.createControl(this);
        this.project = project;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(container, 0);
        if (this.checkSelect) {
            this.dbCatalogTree = new Tree((Composite)sashForm, 2080);
            this.dbCatalogTree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                }
            });
        } else {
            this.dbCatalogTree = new Tree((Composite)sashForm, 2048);
        }
        this.dbCatalogTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewProcedureSelectPanel.this.loadDestDBInfo();
            }
        });
        this.createTableDragSource(this.dbCatalogTree);
        this.infoListTable = new Table((Composite)sashForm, 67584);
        this.infoListTable.setLinesVisible(true);
        this.infoListTable.setHeaderVisible(true);
        this.tableColumn_0 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_0.setWidth(100);
        this.tableColumn_0.setText("name");
        this.tableColumn_6 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_6.setWidth(100);
        this.tableColumn_6.setText("comment");
        this.tableColumn_1 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_1.setWidth(100);
        this.tableColumn_1.setText("type");
        this.tableColumn_2 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_2.setWidth(100);
        this.tableColumn_2.setText("precision");
        this.tableColumn_3 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_3.setWidth(100);
        this.tableColumn_3.setText("scale");
        this.tableColumn_4 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_4.setWidth(100);
        this.tableColumn_4.setText("nullable");
        this.tableColumn_5 = new TableColumn(this.infoListTable, 0);
        this.tableColumn_5.setWidth(100);
        this.tableColumn_5.setText("pk");
        sashForm.setWeights(new int[]{1, 2});
    }

    public void setDBConnection(Connection connection) {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = connection;
        try {
            this.dbCatalogTree.removeAll();
            if (connection == null) {
                return;
            }
            TreeItem item = new TreeItem(this.dbCatalogTree, 0);
            item.setText("EMP\u9879\u76ee[" + this.project.getName() + "]");
            this.tableItem = new TreeItem(item, 0);
            this.tableItem.setText("Tables");
            this.loadDBTableInfo(this.tableItem, new String[]{"TABLE"}, "table");
            this.viewItem = new TreeItem(item, 0);
            this.viewItem.setText("Views");
            this.loadDBTableInfo(this.viewItem, new String[]{"VIEW"}, "view");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadDBTableInfo(TreeItem parent, String[] tableTypes, String id) {
        if (this.connection == null) {
            return;
        }
        try {
            String username;
            IDEProjectSettings settings;
            DatabaseMetaData dbMeta = this.connection.getMetaData();
            ResultSet result = null;
            if (this.getDataBaseType(this.connection).equals("ORACLE")) {
                settings = IDEContent.getPRJSettings(this.project);
                username = settings.getSettingsNode().findChild("userName").getNodeValue();
                result = dbMeta.getTables(null, username.toUpperCase(), null, tableTypes);
            } else if (this.getDataBaseType(this.connection).equals("DB2")) {
                settings = IDEContent.getPRJSettings(this.project);
                username = settings.getSettingsNode().findChild("userName").getNodeValue();
                result = dbMeta.getTables(null, username.toUpperCase(), null, tableTypes);
            } else {
                result = dbMeta.getTables(null, null, null, tableTypes);
            }
            while (result.next()) {
                String tableName = result.getString(3);
                if (this.getDataBaseType(this.connection).equals("ORACLE") && tableName.startsWith("BIN$")) continue;
                TreeItem item = new TreeItem(parent, 0);
                item.setText(tableName);
                item.setData((Object)id);
            }
            result.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadDestDBInfo() {
        TreeItem[] items = this.dbCatalogTree.getSelection();
        if (items.length != 1) {
            return;
        }
        String id = (String)items[0].getData();
        if (id == null) {
            this.infoListTable.removeAll();
            return;
        }
        TableInfo info = (TableInfo)items[0].getData("tableInfo");
        if (info == null) {
            info = this.loadTableDataMeta(items[0].getText());
            items[0].setData("tableInfo", (Object)info);
        }
        this.loadTableInfo(info);
    }

    private TableInfo loadTableDataMeta(String tableName) {
        try {
            String comment;
            this.infoListTable.removeAll();
            TableInfo tInfo = new TableInfo(null, tableName);
            Statement state = this.connection.createStatement();
            HashMap<String, TableColumnInfo> columnMap = new HashMap<String, TableColumnInfo>();
            String strSQL = "Select * from " + tableName + " Where 1=0";
            ResultSet rs = state.executeQuery(strSQL);
            ResultSetMetaData metaData = rs.getMetaData();
            DatabaseMetaData dbMetaData = this.connection.getMetaData();
            ResultSet rs_pk = dbMetaData.getPrimaryKeys(null, null, tableName);
            HashMap pkMap = new HashMap();
            while (rs_pk.next()) {
                pkMap.put(rs_pk.getString(4), null);
            }
            ResultSet rs_column = dbMetaData.getColumns(null, null, tableName, null);
            int i = 1;
            while (i <= metaData.getColumnCount()) {
                try {
                    rs_column.next();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String columnName = metaData.getColumnName(i);
                String columnTypeName = metaData.getColumnTypeName(i);
                int columnType = metaData.getColumnType(i);
                int precision = metaData.getPrecision(i);
                int scale = metaData.getScale(i);
                int nullable = metaData.isNullable(i);
                TableColumnInfo column = new TableColumnInfo();
                tInfo.addColumn(column);
                column.tableName = tableName;
                column.columnName = columnName;
                column.comment = columnName;
                try {
                    String comment2 = (String)rs_column.getObject("REMARKS");
                    if (comment2 != null && comment2.trim().length() > -1) {
                        column.comment = comment2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                column.columnType = columnType;
                column.columnTypeName = columnTypeName;
                column.length = precision;
                column.precision = precision;
                column.scale = scale;
                if (nullable == 0) {
                    column.isNullable = false;
                }
                if (pkMap.containsKey(columnName)) {
                    column.isPrimaryKey = true;
                }
                columnMap.put(column.columnName, column);
                ++i;
            }
            try {
                rs_column.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            rs.close();
            if (this.getDataBaseType(this.connection).equals("DB2")) {
                strSQL = "select remarks from SYSIBM.SYSTABLES where name='" + tableName.toUpperCase() + "'";
                rs = state.executeQuery(strSQL);
                while (rs.next()) {
                    comment = rs.getString(1);
                    if (comment == null || comment.trim().length() <= 0) continue;
                    tInfo.comment = comment;
                }
                rs.close();
            }
            if (this.getDataBaseType(this.connection).equals("ORACLE")) {
                strSQL = "select comments from sys.user_tab_comments where table_name='" + tableName.toUpperCase() + "'";
                rs = state.executeQuery(strSQL);
                if (rs.next() && (comment = rs.getString(1)) != null && comment.trim().length() > 0) {
                    tInfo.comment = comment;
                }
                rs.close();
                strSQL = "select column_name, comments from sys.user_col_comments where table_name='" + tableName.toUpperCase() + "'";
                rs = state.executeQuery(strSQL);
                while (rs.next()) {
                    String columnName = rs.getString(1);
                    String comment3 = rs.getString(2);
                    TableColumnInfo colInfo = (TableColumnInfo)columnMap.get(columnName);
                    if (colInfo == null || comment3 == null || comment3.trim().length() <= 0) continue;
                    colInfo.comment = comment3;
                }
                rs.close();
            }
            state.close();
            return tInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void loadTableInfo(TableInfo tableInfo) {
        try {
            this.infoListTable.removeAll();
            int i = 0;
            while (i < tableInfo.columns.size()) {
                TableColumnInfo column = (TableColumnInfo)tableInfo.columns.elementAt(i);
                TableItem item = new TableItem(this.infoListTable, 0);
                item.setText(column.columnName);
                item.setText(1, column.comment);
                item.setText(2, column.columnTypeName);
                item.setText(3, String.valueOf(column.precision));
                item.setText(4, String.valueOf(column.scale));
                item.setText(5, String.valueOf(column.isNullable));
                item.setText(6, String.valueOf(column.isPrimaryKey));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getTableName() {
        return this.selectedTable;
    }

    private DragSource createTableDragSource(final Tree tree) {
        DragSource dragSource = new DragSource((Control)tree, 3);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        dragSource.setTransfer(types);
        dragSource.addDragListener(new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                try {
                    TableViewProcedureSelectPanel.this.selectItem = tree.getSelection()[0];
                    event.doit = true;
                    event.data = TableViewProcedureSelectPanel.this.selectItem.getData().toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void dragFinished(DragSourceEvent event) {
                TableViewProcedureSelectPanel.this.selectItem = null;
            }

            public void dragSetData(DragSourceEvent event) {
                TextTransfer transfer = TextTransfer.getInstance();
                if (TableViewProcedureSelectPanel.this.selectItem == null) {
                    return;
                }
                if (!transfer.isSupportedType(event.dataType)) {
                    return;
                }
                if ("procedure".equals(TableViewProcedureSelectPanel.this.selectItem.getData())) {
                    event.data = "error";
                    return;
                }
                TableInfo tableInfo = (TableInfo)TableViewProcedureSelectPanel.this.selectItem.getData("tableInfo");
                String content = TableViewProcedureSelectPanel.this.getTableModelFileContent(tableInfo);
                event.data = content;
            }
        });
        return dragSource;
    }

    private static String getDataName(String tableName, String columnName, IProject project) {
        String result = String.valueOf(tableName) + "_" + columnName;
        XMLNode dataDictionary = null;
        try {
            dataDictionary = IDEContent.getSettingNode(project, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dataDictionary == null) {
            return result;
        }
        XMLNode dataNode = dataDictionary.findChildNodeIgnoreCase(columnName);
        if (dataNode != null) {
            return dataNode.getAttrValue("id");
        }
        return result;
    }

    private String getTableModelFileContent(TableInfo tableInfo) {
        String encoding = "utf-8";
        String tableName = tableInfo.tableName;
        tableName = tableName.toLowerCase();
        Vector columns = tableInfo.columns;
        String content = "tableName=" + tableName + ":" + tableInfo.comment + "<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>";
        content = String.valueOf(content) + "\n<" + tableName + ".xml>";
        content = String.valueOf(content) + "\n\t<TableModel id=\"" + tableName + "\" cnname=\"" + tableInfo.comment + "\" dbTableName=\"" + tableName + "\">";
        content = String.valueOf(content) + "\n\t<TableInfo>#text</TableInfo>";
        int i = 0;
        while (i < columns.size()) {
            TableColumnInfo info = (TableColumnInfo)columns.elementAt(i);
            String temp = "\n\t\t<Field id=\"" + info.columnName.toLowerCase() + "\" cnname=\"" + info.comment + "\" columnName=\"" + info.columnName.toLowerCase() + "\"";
            if (info.isPrimaryKey) {
                temp = String.valueOf(temp) + " isPK=\"true\"";
            }
            temp = String.valueOf(temp) + " JDBCType=\"" + info.columnTypeName + "\"";
            temp = info.isNullable ? String.valueOf(temp) + " canBeNull=\"true\"" : String.valueOf(temp) + " canBeNull=\"false\"";
            temp = String.valueOf(temp) + " length=\"" + info.precision + "\"";
            temp = String.valueOf(temp) + " JSPTag=\"text\"";
            temp = String.valueOf(temp) + "/>";
            content = String.valueOf(content) + temp;
            ++i;
        }
        content = String.valueOf(content) + "\n\t</TableModel>";
        content = String.valueOf(content) + "\n</" + tableName + ".xml>";
        return content;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private String getDataBaseType(Connection con) {
        if (con == null) {
            return "";
        }
        String dbType = con.toString().toUpperCase();
        if (dbType.indexOf("ORACLE") > -1) {
            return "ORACLE";
        }
        if (dbType.indexOf("DB2") > -1) {
            return "DB2";
        }
        return "";
    }
}

