/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class HtmlLayoutPropertyPage
extends WizardPage {
    private Text topMenuSrcText;
    private Text secondMenuSrcText;
    private Text leftMenuSrcText;
    private Text contentAreaSrcText;
    private String topMenuSrcStr;
    private String secondMenuSrcStr;
    private String leftMenuSrcStr;
    private String contentAreaSrcStr;
    private ISelection selection;

    public HtmlLayoutPropertyPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("HTML Client layout Properties define");
        this.setDescription("Please setup the layout properties.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label1 = new Label(container, 0);
        label1.setText(Messages.getString("HtmlLayoutPropertyPage.contentSrcLabel"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label1.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(Messages.getString("LayoutPreviewComposite.TopMenuLabel"));
        this.topMenuSrcText = new Text(container, 2052);
        gd = new GridData(768);
        this.topMenuSrcText.setLayoutData((Object)gd);
        this.topMenuSrcText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HtmlLayoutPropertyPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString("LayoutPreviewComposite.SecondTopMenuLabel"));
        this.secondMenuSrcText = new Text(container, 2052);
        gd = new GridData(768);
        this.secondMenuSrcText.setLayoutData((Object)gd);
        this.secondMenuSrcText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HtmlLayoutPropertyPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString("LayoutPreviewComposite.LeftMenuLabel"));
        this.leftMenuSrcText = new Text(container, 2052);
        gd = new GridData(768);
        this.leftMenuSrcText.setLayoutData((Object)gd);
        this.leftMenuSrcText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HtmlLayoutPropertyPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString("LayoutPreviewComposite.ContentAreaLabel"));
        this.contentAreaSrcText = new Text(container, 2052);
        gd = new GridData(768);
        this.contentAreaSrcText.setLayoutData((Object)gd);
        this.contentAreaSrcText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HtmlLayoutPropertyPage.this.dialogChanged();
            }
        });
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void handleBrowse() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.getString("NewHtmlTransactionWizardPage.Select_new_file_container_12"));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            int cfr_ignored_0 = result.length;
        }
    }

    private void dialogChanged() {
        this.topMenuSrcStr = this.topMenuSrcText.getText();
        this.secondMenuSrcStr = this.secondMenuSrcText.getText();
        this.leftMenuSrcStr = this.leftMenuSrcText.getText();
        this.contentAreaSrcStr = this.contentAreaSrcText.getText();
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getLeftMenuSrcText() {
        return this.leftMenuSrcStr;
    }

    public String getContentSrcText() {
        return this.contentAreaSrcStr;
    }

    public String getTopMenuSrcText() {
        return this.topMenuSrcStr;
    }

    public String getSeconedMenuSrcText() {
        return this.secondMenuSrcStr;
    }

    public void setLayoutStyle(int layoutStyle) {
        if (layoutStyle == 0) {
            this.contentAreaSrcText.setEnabled(true);
            this.leftMenuSrcText.setEnabled(true);
            this.secondMenuSrcText.setEnabled(false);
            this.topMenuSrcText.setEnabled(false);
        } else if (layoutStyle == 1) {
            this.contentAreaSrcText.setEnabled(true);
            this.leftMenuSrcText.setEnabled(false);
            this.secondMenuSrcText.setEnabled(false);
            this.topMenuSrcText.setEnabled(true);
        } else if (layoutStyle == 2) {
            this.contentAreaSrcText.setEnabled(true);
            this.leftMenuSrcText.setEnabled(true);
            this.secondMenuSrcText.setEnabled(false);
            this.topMenuSrcText.setEnabled(true);
        } else if (layoutStyle == 3) {
            this.contentAreaSrcText.setEnabled(true);
            this.leftMenuSrcText.setEnabled(false);
            this.secondMenuSrcText.setEnabled(true);
            this.topMenuSrcText.setEnabled(true);
        } else if (layoutStyle == 4) {
            this.contentAreaSrcText.setEnabled(true);
            this.leftMenuSrcText.setEnabled(true);
            this.secondMenuSrcText.setEnabled(true);
            this.topMenuSrcText.setEnabled(true);
        } else if (layoutStyle == 5) {
            this.contentAreaSrcText.setEnabled(true);
        }
    }
}

