/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.wizards.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class LayoutPreviewComposite
extends Composite
implements PaintListener {
    int layoutType = 5;

    public LayoutPreviewComposite(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this);
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setLayoutStyle(int style) {
        this.layoutType = style;
        this.redraw();
    }

    public void paintControl(PaintEvent event) {
        try {
            Point size = this.getSize();
            int width = size.x - 10;
            int height = size.y - 10;
            if (height > width * 3 / 4) {
                height = width * 3 / 4;
            } else {
                width = height * 4 / 3;
            }
            Image image = new Image((Device)Display.getDefault(), width, height);
            GC gc = new GC((Drawable)image);
            gc.setForeground(this.getDisplay().getSystemColor(16));
            gc.setLineWidth(4);
            gc.drawRectangle(0, 0, width, height);
            int y0 = height - height * 2 / 30;
            gc.drawLine(0, y0, width, y0);
            gc.drawString(Messages.getString("LayoutPreviewComposite.FootBannerLabel"), (width - 80) / 2, y0 + 3);
            y0 = height * 4 / 30;
            gc.drawLine(0, y0, width, y0);
            gc.drawString(Messages.getString("LayoutPreviewComposite.TopBannerLabel"), (width - 80) / 2, y0 - 20);
            if (this.layoutType > 0 && this.layoutType < 5) {
                gc.drawLine(0, y0 += height * 2 / 30, width, y0);
                gc.drawString(Messages.getString("LayoutPreviewComposite.TopMenuLabel"), (width - 100) / 2, y0 - 15);
            }
            if (this.layoutType > 2 && this.layoutType <= 4) {
                gc.drawLine(0, y0 += height * 2 / 30, width, y0);
                gc.drawString(Messages.getString("LayoutPreviewComposite.SecondTopMenuLabel"), (width - 150) / 2, y0 - 15);
            }
            if (this.layoutType == 0 || this.layoutType == 2 || this.layoutType == 4) {
                gc.drawLine(width / 4, y0, width / 4, height - height * 2 / 30);
                gc.drawString(Messages.getString("LayoutPreviewComposite.LeftMenuLabel"), 10, height / 2);
                gc.drawString(Messages.getString("LayoutPreviewComposite.ContentAreaLabel"), width / 4 + (width - width / 4 - 100) / 2, height / 2);
            } else {
                gc.drawString(Messages.getString("LayoutPreviewComposite.ContentAreaLabel"), (width - 100) / 2, height / 2);
            }
            event.gc.drawImage(image, (size.x - width) / 2, (size.y - height) / 2);
            image.dispose();
            gc.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

