/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.wizards.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MCIActionComponentStatesWizardPage
extends WizardPage {
    private Text valueText;
    private Text textText;
    private Table itemList;
    private ISelection selection;
    private Composite parent;

    public MCIActionComponentStatesWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.getString("NewActionWizard.titleLabel"));
        this.setDescription(Messages.getString("NewActionWizard.statesLabel"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label valueLabel = new Label(composite, 0);
        valueLabel.setText(Messages.getString("NewActionWizard.stateValueLabel"));
        this.valueText = new Text(composite, 2048);
        GridData gridData_8 = new GridData();
        gridData_8.widthHint = 100;
        this.valueText.setLayoutData((Object)gridData_8);
        Label textLabel = new Label(composite, 0);
        textLabel.setText(Messages.getString("NewActionWizard.stateDescLabel"));
        this.textText = new Text(composite, 2048);
        this.textText.setLayoutData((Object)new GridData(768));
        Composite composite_2 = new Composite(composite, 0);
        GridData gridData_4 = new GridData(640);
        gridData_4.horizontalSpan = 2;
        composite_2.setLayoutData((Object)gridData_4);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 4;
        composite_2.setLayout((Layout)gridLayout_2);
        Button addButton = new Button(composite_2, 0);
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 90;
        addButton.setLayoutData((Object)gridData_5);
        addButton.setText(Messages.getString("NewActionWizard.addLabel"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MCIActionComponentStatesWizardPage.this.addNewValue();
            }
        });
        Button delButton = new Button(composite_2, 0);
        GridData gridData_6 = new GridData();
        gridData_6.widthHint = 90;
        delButton.setLayoutData((Object)gridData_6);
        delButton.setText(Messages.getString("NewActionWizard.deleteLabel"));
        delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TableItem item = MCIActionComponentStatesWizardPage.this.itemList.getSelection()[0];
                    item.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        Button button = new Button(composite_2, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MCIActionComponentStatesWizardPage.this.updateItemValue();
            }
        });
        GridData gridData_7 = new GridData();
        gridData_7.widthHint = 90;
        button.setLayoutData((Object)gridData_7);
        button.setText(Messages.getString("NewActionWizard.updateLabel"));
        this.itemList = new Table(composite, 67584);
        this.itemList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MCIActionComponentStatesWizardPage.this.setActiveItem();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.itemList.setLayoutData((Object)gridData);
        this.itemList.setHeaderVisible(true);
        this.itemList.setLinesVisible(true);
        TableColumn column1 = new TableColumn(this.itemList, 18432);
        column1.setText(Messages.getString("NewActionWizard.valueItemLabel"));
        column1.setWidth(134);
        TableColumn column2 = new TableColumn(this.itemList, 18432);
        column2.setText(Messages.getString("NewActionWizard.valueDescItemLabel"));
        column2.setWidth(262);
        this.dialogChanged();
        this.setControl((Control)composite);
        TableItem item = new TableItem(this.itemList, 0);
        item.setText(0, "0");
        item.setText(1, "\u6b63\u5e38");
        TableItem item1 = new TableItem(this.itemList, 0);
        item1.setText(0, "-1");
        item1.setText(1, "\u5f02\u5e38");
    }

    private void addNewValue() {
        String valueStr = this.valueText.getText();
        String textStr = this.textText.getText();
        if (valueStr.length() == 0 || valueStr.indexOf(";") != -1 || valueStr.indexOf(":") != -1) {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.getString("NewActionWizard.warningLabel"), (String)Messages.getString("NewActionWizard.valueWarningMsg"));
            return;
        }
        if (textStr.length() == 0 || textStr.indexOf(";") != -1 || textStr.indexOf(":") != -1) {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.getString("NewActionWizard.warningLabel"), (String)Messages.getString("NewActionWizard.valueDescWarningMsg"));
            return;
        }
        TableItem item = new TableItem(this.itemList, 0);
        item.setText(0, valueStr);
        item.setText(1, textStr);
    }

    private void updateItemValue() {
        TableItem[] items = this.itemList.getSelection();
        if (items.length != 1) {
            return;
        }
        String valueStr = this.valueText.getText();
        String textStr = this.textText.getText();
        if (valueStr.length() == 0 || valueStr.indexOf(";") != -1 || valueStr.indexOf(":") != -1) {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.getString("NewActionWizard.warningLabel"), (String)Messages.getString("NewActionWizard.valueWarningMsg"));
            return;
        }
        if (textStr.length() == 0 || textStr.indexOf(";") != -1 || textStr.indexOf(":") != -1) {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)Messages.getString("NewActionWizard.warningLabel"), (String)Messages.getString("NewActionWizard.valueDescWarningMsg"));
            return;
        }
        items[0].setText(0, valueStr);
        items[0].setText(1, textStr);
    }

    private void setActiveItem() {
        TableItem[] items = this.itemList.getSelection();
        if (items.length != 1) {
            this.textText.setText("");
            this.valueText.setText("");
            return;
        }
        this.valueText.setText(items[0].getText());
        this.textText.setText(items[0].getText(1));
    }

    private void dialogChanged() {
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getStatesStr() {
        StringBuffer buf = new StringBuffer();
        TableItem[] items = this.itemList.getItems();
        int i = 0;
        while (i < items.length) {
            buf.append(items[i].getText());
            buf.append("=");
            buf.append(items[i].getText(1));
            buf.append(";");
            ++i;
        }
        return buf.toString();
    }
}

