/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.ide.plugin.wizards.MVCAPPWizardPage;
import com.ecc.ide.plugin.wizards.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class MVCAPPWizard
extends Wizard
implements INewWizard {
    private MVCAPPWizardPage page;
    private ISelection selection;
    private String trxCode = null;
    private String trxName = null;
    private String classify = null;

    public MVCAPPWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new MVCAPPWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        Object obj;
        this.trxCode = this.page.getTrxCode();
        this.trxName = this.page.getTrxName();
        if (this.selection instanceof StructuredSelection && (obj = ((StructuredSelection)this.selection).getFirstElement()) instanceof PrjViewXMLNode) {
            IProject prj = (IProject)((PrjViewXMLNode)obj).obj;
            IFolder designFolder = prj.getFolder("designFile");
            IFolder appFolder = designFolder.getFolder(this.trxCode);
            if (appFolder.exists()) {
                return false;
            }
            try {
                ECCIDEPlugin.createFolders(prj.getName(), "designFiles", this.trxCode);
            }
            catch (Exception exception) {
                // empty catch block
            }
            IFile file = prj.getFile("designFiles/" + this.trxCode + "/desc.xml");
            if (!file.exists()) {
                try {
                    InputStream stream = this.openContentStream();
                    if (file.exists()) {
                        file.setContents(stream, true, true, null);
                    } else {
                        file.create(stream, true, null);
                    }
                    stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        IContainer container;
        IFile file;
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.valueOf(Messages.getString("NewMCITransactionWizard.Container___10")) + containerName + Messages.getString("NewMCITransactionWizard.__does_not_exist._11"));
        }
        if ((file = (container = (IContainer)resource).getFile((IPath)new Path(fileName))).exists()) {
            this.throwCoreException(Messages.getString("NewMCITransactionWizard.File_still_exist_!_12"));
        }
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.getString("NewMCITransactionWizard.Opening_file_for_editing..._13"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String encoding = System.getProperty("file.encoding");
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<?xml version=\"1.0\" encoding=\"");
        strBuf.append(encoding);
        strBuf.append("\" ?>\n\n");
        strBuf.append("<app ");
        if (this.trxCode != null && this.trxCode.length() > 0) {
            strBuf.append(" id=\"" + this.trxCode + "\"");
        }
        if (this.trxName != null && this.trxName.length() > 0) {
            strBuf.append(" name=\"" + this.trxName + "\"");
        }
        strBuf.append(" />");
        return new ByteArrayInputStream(strBuf.toString().getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.ecc.ide", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }
}

