/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.ide.plugin.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class MVCAPPWizardPage
extends WizardPage {
    private Text trxNameText;
    private Text trxCodeText;
    private ISelection selection;

    public MVCAPPWizardPage(ISelection selection) {
        super(Messages.getString("NewMCITransactionWizardPage.wizardPage_1"));
        this.setTitle("MVC Application");
        this.setDescription("");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label_1 = new Label(container, 0);
        label_1.setText("id");
        this.trxCodeText = new Text(container, 2048);
        GridData gridData = new GridData(199, -1);
        this.trxCodeText.setLayoutData((Object)gridData);
        Label label_2 = new Label(container, 0);
        label_2.setText("name");
        this.trxNameText = new Text(container, 2048);
        GridData gridData_1 = new GridData(4, 0x1000000, true, false);
        this.trxNameText.setLayoutData((Object)gridData_1);
        this.initialize();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof PrjViewXMLNode) {
                obj = ((PrjViewXMLNode)obj).getProject();
            }
            if (obj instanceof IProject) {
                IProject prj = (IProject)obj;
            } else if (obj instanceof IJavaProject) {
                IJavaProject prj = (IJavaProject)obj;
            } else if (obj instanceof IPackageFragment) {
                IPackageFragment ip = (IPackageFragment)obj;
                String path = String.valueOf(ip.getJavaProject().getPath().toString()) + "/designFiles/MCITrxs/";
            } else if (obj instanceof IResource) {
                IResource rc = (IResource)obj;
                String string = String.valueOf(rc.getProject().getFullPath().toString()) + "/designFiles/MCITrxs/";
            }
        }
    }

    private void handleBrowse() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.getString("NewMCITransactionWizardPage.Select_new_file_container_15"));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            int cfr_ignored_0 = result.length;
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getTrxCode() {
        return this.trxCodeText.getText();
    }

    public String getTrxName() {
        return this.trxNameText.getText();
    }
}

