/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.wizards.Messages;
import com.ecc.ide.popup.actions.IDEPluginAction;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class NewECCPrjThread
implements Runnable {
    IProject project = null;
    private boolean suportTeller = false;
    private boolean suportHTMLClient = true;
    private IProgressMonitor monitor = null;
    private XMLNode projectSettingsNode;
    private IDEProjectSettings prjSettings;
    private Vector selectedModules;
    private String folderStructureXMLFile = "folderStructure.xml";
    public IDEPluginAction action;

    public void setSelectedModules(Vector modules) {
        this.selectedModules = modules;
    }

    public void setProjectSettingsNode(XMLNode node) {
        this.projectSettingsNode = node;
    }

    public NewECCPrjThread(IProject project) {
        this.project = project;
    }

    public NewECCPrjThread(IProject project, boolean suportTeller) {
        this.project = project;
        this.suportTeller = suportTeller;
    }

    public void run() {
        try {
            ECCIDEPlugin plugin = ECCIDEPlugin.getDefault();
            XMLNode folderStructure = this.getFolderStructure();
            this.prjSettings = new IDEProjectSettings(this.projectSettingsNode);
            this.makeFolder(folderStructure, "");
            String webContentPath = this.prjSettings.getWebContentPath();
            String jspRootPath = this.prjSettings.getJspRootPath();
            String settingsRootPath = this.prjSettings.getSettingsRootPath();
            String dstLibPath = String.valueOf(webContentPath) + "/WEB-INF/lib";
            int i = 0;
            while (i < this.selectedModules.size()) {
                XMLNode moduleNode = (XMLNode)this.selectedModules.elementAt(i);
                XMLNode jarsNode = moduleNode.getChild("jars");
                if (jarsNode != null) {
                    int k = 0;
                    while (k < jarsNode.getChilds().size()) {
                        XMLNode jarNode = (XMLNode)jarsNode.getChilds().elementAt(k);
                        if ("jar".equals(jarNode.getNodeName())) {
                            String fileName = jarNode.getAttrValue("file");
                            String folderName = jarNode.getAttrValue("folder");
                            if (folderName != null) {
                                this.copyPathContent(ECCIDEPlugin.getDir("WebContent/lib/" + folderName), dstLibPath);
                            }
                            if (fileName != null) {
                                this.copyFile("WebContent/lib/" + fileName, String.valueOf(dstLibPath) + "/" + fileName);
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            String aPath = this.prjSettings.getBusinessLogicPath();
            if (aPath.length() > 0) {
                this.createFolder(String.valueOf(webContentPath) + "/" + settingsRootPath + "/" + aPath);
            }
            if ((aPath = this.prjSettings.getHtmlLogicPath()).length() > 0) {
                this.createFolder(String.valueOf(webContentPath) + "/" + settingsRootPath + "/" + aPath);
            }
            if ((aPath = this.prjSettings.getWmlLogicPath()).length() > 0) {
                this.createFolder(String.valueOf(webContentPath) + "/" + settingsRootPath + "/" + aPath);
            }
            if ((aPath = this.prjSettings.getKjavaLogicPath()).length() > 0) {
                this.createFolder(String.valueOf(webContentPath) + "/" + settingsRootPath + "/" + aPath);
            }
            if ((aPath = this.prjSettings.getHtmlJspPath()).length() > 0) {
                this.createFolder(String.valueOf(webContentPath) + "/" + jspRootPath + "/" + aPath);
            }
            if ((aPath = this.prjSettings.getWmlJspPath()).length() > 0) {
                this.createFolder(String.valueOf(webContentPath) + "/" + jspRootPath + "/" + aPath);
            }
            if ((aPath = this.prjSettings.getKJavaJspPath()).length() > 0) {
                this.createFolder(String.valueOf(webContentPath) + "/" + jspRootPath + "/" + aPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.reportProgress(e.toString());
            this.showException("Exception from run:", e);
        }
    }

    public void run(IProgressMonitor monitor) {
        this.monitor = monitor;
        this.run();
    }

    private void copyFile(String src, String dst) {
        try {
            IFolder folder;
            int idx = dst.lastIndexOf("/");
            String fileName = dst;
            if (idx != -1) {
                String dstFolder = dst.substring(0, idx);
                folder = this.createFolder(dstFolder);
                fileName = dst.substring(idx + 1);
            } else {
                folder = this.project.getFolder("/");
            }
            this.reportProgress("Copy file[" + src + "] to [" + dst + "]...");
            IFile newFile = folder.getFile(fileName);
            File aFile = new File(src);
            InputStream in = ECCIDEPlugin.getFile(src);
            if (newFile.exists()) {
                newFile.setContents(in, true, false, null);
            } else {
                newFile.create(in, true, null);
            }
            in.close();
        }
        catch (Exception e) {
            this.showException("Exception in copy file", e);
        }
    }

    private IFolder createFolder(String dst) throws Exception {
        int idx;
        String dstDir = dst.replace('\\', '/');
        int offset = 0;
        IFolder folder = null;
        do {
            String folderStr = (idx = dst.indexOf(47, offset)) == -1 ? dst.substring(offset) : dst.substring(offset, idx);
            offset = idx + 1;
            if ((folder = folder == null ? this.project.getFolder(folderStr) : folder.getFolder(folderStr)).exists()) continue;
            this.reportProgress(String.valueOf(Messages.getString("NewECCPrjThread.Create_folder__3")) + folderStr);
            folder.create(false, true, null);
        } while (idx != -1);
        return folder;
    }

    private void copyPathContent(String src, String dst) {
        this.beginWork(String.valueOf(Messages.getString("NewECCPrjThread.Copy_file_to__1")) + dst + Messages.getString("NewECCPrjThread._from__2") + src, 5);
        try {
            IFolder folder = this.createFolder(dst);
            File srcFolder = new File(src);
            String[] files = srcFolder.list();
            this.beginWork(Messages.getString("NewECCPrjThread.Copy_files..._4"), files.length);
            int i = 0;
            while (i < files.length) {
                try {
                    this.reportProgress(String.valueOf(Messages.getString("NewECCPrjThread.copy_file___5")) + files[i], i + 1);
                    IFile newFile = folder.getFile(files[i]);
                    File aFile = new File(String.valueOf(src) + "/" + files[i]);
                    if (aFile.isDirectory()) {
                        String name = files[i];
                        this.copyPathContent(String.valueOf(src) + "/" + name, String.valueOf(dst) + "/" + name);
                    } else {
                        FileInputStream in = new FileInputStream(String.valueOf(src) + "/" + files[i]);
                        if (in != null) {
                            if (newFile.exists()) {
                                newFile.setContents((InputStream)in, true, false, null);
                            } else {
                                newFile.create((InputStream)in, true, null);
                            }
                            ((InputStream)in).close();
                        }
                    }
                }
                catch (Exception e) {
                    this.showException("Exception:", e);
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.showException("Exception:", e);
            e.printStackTrace();
        }
    }

    private void copyPathContentOld(String src, String dst) {
        this.beginWork(String.valueOf(Messages.getString("NewECCPrjThread.Copy_file_to__1")) + dst + Messages.getString("NewECCPrjThread._from__2") + src, 5);
        try {
            int idx;
            try {
                int idx2 = dst.indexOf(47, 0);
                if (idx2 == -1) {
                    src = ECCIDEPlugin.getDir(src);
                } else {
                    String folderStr = dst.substring(0, idx2);
                    src = String.valueOf(ECCIDEPlugin.getDir(folderStr)) + dst.substring(idx2 + 1, folderStr.length());
                }
            }
            catch (Exception idx2) {
                // empty catch block
            }
            String dstDir = dst.replace('\\', '/');
            int offset = 0;
            IFolder folder = null;
            do {
                String folderStr = (idx = dst.indexOf(47, offset)) == -1 ? dst.substring(offset) : dst.substring(offset, idx);
                offset = idx + 1;
                if ((folder = folder == null ? this.project.getFolder(folderStr) : folder.getFolder(folderStr)).exists()) continue;
                this.reportProgress(String.valueOf(Messages.getString("NewECCPrjThread.Create_folder__3")) + folderStr);
                folder.create(false, true, null);
            } while (idx != -1);
            File srcFolder = new File(src);
            String[] files = srcFolder.list();
            this.beginWork(Messages.getString("NewECCPrjThread.Copy_files..._4"), files.length);
            int i = 0;
            while (i < files.length) {
                try {
                    this.reportProgress(String.valueOf(Messages.getString("NewECCPrjThread.copy_file___5")) + files[i], i + 1);
                    IFile newFile = folder.getFile(files[i]);
                    FileInputStream in = new FileInputStream(String.valueOf(src) + "/" + files[i]);
                    if (in != null) {
                        if (newFile.exists()) {
                            newFile.setContents((InputStream)in, true, false, null);
                        } else {
                            newFile.create((InputStream)in, true, null);
                        }
                        ((InputStream)in).close();
                    }
                }
                catch (FileNotFoundException e) {
                    IFolder newFolder = folder.getFolder(files[i]);
                    String name = files[i];
                    this.copyPathContent(String.valueOf(src) + "/" + name, String.valueOf(dst) + "/" + name);
                }
                catch (Exception e) {
                    this.showException("Exception:", e);
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.showException("Exception:", e);
            e.printStackTrace();
        }
    }

    private XMLNode getFolderStructure() {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLFile(ECCIDEPlugin.getDir(this.folderStructureXMLFile));
            return node;
        }
        catch (Exception e) {
            this.showException("Failed to load XML file of:" + ECCIDEPlugin.getDir(this.folderStructureXMLFile) + " Exception:", e);
            return null;
        }
    }

    private void makeFolder(XMLNode folderStructure, String root) {
        if (root == null) {
            root = "";
        }
        if (folderStructure == null) {
            return;
        }
        if ("folder".equals(folderStructure.getNodeName())) {
            try {
                String dstFolder = folderStructure.getAttrValue("name");
                String srcFolder = folderStructure.getAttrValue("source");
                if (dstFolder != null && srcFolder != null) {
                    dstFolder = this.transferFolderName(dstFolder);
                    this.copyPathContent(ECCIDEPlugin.getDir(srcFolder), dstFolder);
                }
                int i = 0;
                while (i < folderStructure.getChilds().size()) {
                    XMLNode childFolder = (XMLNode)folderStructure.getChilds().elementAt(i);
                    this.makeFolder(childFolder, "");
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showException("Exception:", e);
            }
        }
        if ("file".equals(folderStructure.getNodeName())) {
            try {
                String name = folderStructure.getAttrValue("name");
                IFile newFile = this.project.getFile(name);
                String sourceFile = folderStructure.getAttrValue("source");
                if (sourceFile != null && sourceFile.length() > 0) {
                    if (newFile.exists()) {
                        newFile.setContents(ECCIDEPlugin.getFile(sourceFile), true, false, null);
                    } else {
                        newFile.create(ECCIDEPlugin.getFile(sourceFile), true, null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showException("Exception:", e);
            }
        }
    }

    private String transferFolderName(String name) {
        if (name.indexOf("$") == -1) {
            return name;
        }
        String webRoot = this.prjSettings.getWebContentPath();
        String jspRoot = this.prjSettings.getJspRootPath();
        String settingsRoot = this.prjSettings.getSettingsRootPath();
        String htmlCltRoot = this.prjSettings.getHtmlLogicPath();
        int idx = name.indexOf("$WebRoot");
        String dstName = idx != -1 ? (idx > 0 ? String.valueOf(name.substring(0, idx)) + webRoot + name.substring(idx + 8) : String.valueOf(webRoot) + name.substring(idx + 8)) : name;
        idx = dstName.indexOf("$JSPRoot");
        if (idx != -1) {
            dstName = String.valueOf(dstName.substring(0, idx)) + jspRoot + dstName.substring(idx + 8);
        }
        if ((idx = dstName.indexOf("$settingsRoot")) != -1) {
            dstName = String.valueOf(dstName.substring(0, idx)) + settingsRoot + dstName.substring(idx + 13);
        }
        if ((idx = dstName.indexOf("$htmlSettings")) != -1) {
            dstName = String.valueOf(dstName.substring(0, idx)) + htmlCltRoot + dstName.substring(idx + 13);
        }
        System.out.println("translate[" + name + "] to [" + dstName + "]");
        return dstName;
    }

    protected void reportProgress(String msg) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.subTask(msg);
    }

    protected void reportProgress(String msg, int worked) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.subTask(msg);
        this.monitor.worked(worked);
    }

    protected void beginWork(String msg, int works) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.beginTask(msg, works);
    }

    private void showException(String msg, Exception e) {
        if (this.action != null) {
            this.action.reportProblem(0, String.valueOf(msg) + e.toString(), "NewEccPrjThread", "", e);
        }
    }
}

