/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.wizards.HtmlLayoutPropertyPage;
import com.ecc.ide.plugin.wizards.HtmlLayoutSelectWizardPage;
import com.ecc.ide.plugin.wizards.Messages;
import com.ecc.ide.plugin.wizards.NewHtmlLayoutWizardPage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewHtmlLayoutWizard
extends Wizard
implements INewWizard {
    private NewHtmlLayoutWizardPage page;
    private HtmlLayoutSelectWizardPage layoutSelectPage;
    private HtmlLayoutPropertyPage propertyPage;
    private ISelection selection;

    public NewHtmlLayoutWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewHtmlLayoutWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
        this.layoutSelectPage = new HtmlLayoutSelectWizardPage(this.selection);
        this.addPage((IWizardPage)this.layoutSelectPage);
        this.propertyPage = new HtmlLayoutPropertyPage(this.selection);
        this.addPage((IWizardPage)this.propertyPage);
        this.layoutSelectPage.propertyPage = this.propertyPage;
    }

    public boolean performFinish() {
        String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Container [" + containerName + "] not exist!"));
            return false;
        }
        final String cName = containerName;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewHtmlLayoutWizard.this.doFinish(cName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = null;
            stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.getString("NewHtmlTransactionWizard.Opening_file_for_editing..._12"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String encoding = System.getProperty("file.encoding");
        if (ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("setXMLEncodingNamually")) {
            encoding = ECCIDEPlugin.getDefault().getPreferenceStore().getString("xmlEncoding");
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<%@page language=\"java\" contentType=\"text/html; charset=");
        strBuf.append(encoding);
        strBuf.append("\"%>\n");
        strBuf.append("<%@taglib uri=\"/WEB-INF/ctp.tld\" prefix=\"ctp\" %>\n\n");
        strBuf.append("<%@taglib uri=\"/WEB-INF/emp.tld\" prefix=\"emp\" %>\n\n");
        strBuf.append("<%@taglib uri=\"/WEB-INF/c.tld\" prefix=\"c\" %>\n\n");
        strBuf.append("<HTML>\n<HEAD>\n");
        strBuf.append("<META http-equiv=\"Content-Type\" content=\"text/html; charset=");
        strBuf.append(encoding);
        strBuf.append("\"/>\n");
        strBuf.append("<LINK rel=\"stylesheet\" href=\"<ctp:file fileName=\"styles/3col_leftNav.css\"/>\" type=\"text/css\"/>\n");
        strBuf.append("<SCRIPT type=\"text/JavaScript\" src=\"<ctp:file fileName=\"scripts/myAjax.js\"/>\" language=\"JavaScript\"> </SCRIPT>\n");
        strBuf.append("<SCRIPT type=\"text/JavaScript\" language=\"JavaScript\">\n");
        int layoutStyle = this.layoutSelectPage.getLayoutStyle();
        if (layoutStyle == 0) {
            strBuf.append("var divInfos= new Array(\"navBar\", \"content\");\n");
            strBuf.append("var lastElements=new Array(2);\n");
            strBuf.append("function loadContent()\n{\n");
            if (this.propertyPage.getContentSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getContentSrcText());
                strBuf.append("\"/>', 'content', 'text');\n");
            }
            if (this.propertyPage.getLeftMenuSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getLeftMenuSrcText());
                strBuf.append("?targetDiv=content&divId=navBar&divInfo=navBar:treeItemFocus:null;content:null:null;\"/>', 'navBar', 'text');\n");
            }
        } else if (layoutStyle == 1) {
            strBuf.append("var divInfos= new Array(\"globalNav\", \"content\");\n");
            strBuf.append("var lastElements=new Array(2);\n");
            strBuf.append("function loadContent()\n{\n");
            if (this.propertyPage.getContentSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getContentSrcText());
                strBuf.append("\"/>', 'content', 'text');\n");
            }
            if (this.propertyPage.getTopMenuSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getTopMenuSrcText());
                strBuf.append("?targetDiv=content&divId=globalNav&divInfo=globalNav:navTitle:null;content:null:null;\"/>', 'globalNav', 'text');\n");
            }
        } else if (layoutStyle == 2) {
            strBuf.append("var divInfos= new Array(\"globalNav\", \"leftNav\", \"content\");\n");
            strBuf.append("var lastElements=new Array(3);\n");
            strBuf.append("function loadContent()\n{\n");
            if (this.propertyPage.getContentSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getContentSrcText());
                strBuf.append("\"/>', 'content', 'text');\n");
            }
            if (this.propertyPage.getTopMenuSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getTopMenuSrcText());
                strBuf.append("?targetDiv=leftNav&divId=globalNav&targetUpdateDiv=content&divInfo=globalNav:navTitle:null;content:null:null;\"/>', 'globalNav', 'text');\n");
            }
            if (this.propertyPage.getLeftMenuSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getLeftMenuSrcText());
                strBuf.append("?targetDiv=content&divId=navBar&divInfo=navBar:treeItemFocus:null;content:null:null;\"/>', 'navBar', 'text');\n");
            }
        } else if (layoutStyle == 3) {
            strBuf.append("var divInfos= new Array(\"globalNav\", \"subGlobalNav\", \"content\");\n");
            strBuf.append("var lastElements=new Array(3);\n");
            strBuf.append("function loadContent()\n{\n");
            if (this.propertyPage.getContentSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getContentSrcText());
                strBuf.append("\"/>', 'content', 'text');\n");
            }
            if (this.propertyPage.getTopMenuSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getTopMenuSrcText());
                strBuf.append("?targetDiv=subGlobalNav&targetUpdateDiv=content&divId=globalNav&divInfo=globalNav:navTitle:null;subGlobalNav:subNavTitle:null;content:null:null;\"/>', 'globalNav', 'text');\n");
            }
            if (this.propertyPage.getSeconedMenuSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getSeconedMenuSrcText());
                strBuf.append("?pNodeID=group1&targetDiv=content&divId=subGlobalNav&divInfo=globalNav:navTitle:null;subGlobalNav:subNavTitle:null;content:null:null;\"/>', 'subGlobalNav', 'text');\n");
            }
        } else if (layoutStyle == 4) {
            strBuf.append("var divInfos= new Array(\"globalNav\", \"subGlobalNav\", \"leftNav\", \"content\");\n");
            strBuf.append("var lastElements=new Array(4);\n");
            strBuf.append("function loadContent()\n{\n");
            if (this.propertyPage.getContentSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getContentSrcText());
                strBuf.append("\"/>', 'content', 'text');\n");
            }
            if (this.propertyPage.getTopMenuSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getTopMenuSrcText());
                strBuf.append("?targetDiv=subGlobalNav&targetUpdateDiv=leftNav&divInfo=globalNav:globalFocus:null;subGlobalNav:subGlobalFocus:null;leftNav:leftNavFocus:null;content:null:null;\"/>', 'globalNav', 'text');\n");
            }
            if (this.propertyPage.getSeconedMenuSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getSeconedMenuSrcText());
                strBuf.append("?pNodeID=group1&targetDiv=leftNav&targetUpdateDiv=content&divInfo=globalNav:globalFocus:null;subGlobalNav:subGlobalFocus:null;leftNav:leftNavFocus:null;content:null:null;\"/>', 'subGlobalNav', 'text');\n");
            }
            if (this.propertyPage.getLeftMenuSrcText().length() > 0) {
                strBuf.append("\tupdateDivContent('<ctp:jspURL jspFileName=\"");
                strBuf.append(this.propertyPage.getLeftMenuSrcText());
                strBuf.append("?pNodeID=group1:group2&targetDiv=content&divInfo=globalNav:globalFocus:null;subGlobalNav:subGlobalFocus:null;leftNav:leftNavFocus:null;content:null:null;\"/>', 'leftNav', 'text');\n");
            }
        }
        strBuf.append("\n}\n</SCRIPT>\n</HEAD>\n");
        strBuf.append("<BODY onLoad=\"loadContent()\">\n<DIV id=\"masthead\">topBanner DIV</DIV>\n");
        if (layoutStyle == 0) {
            strBuf.append("<DIV id=\"navBar\">Left Tree Menu DIV</DIV>\n");
        } else if (layoutStyle == 1) {
            strBuf.append("<DIV id=\"globalNav\">Top Menu DIV</DIV>\n");
        } else if (layoutStyle == 2) {
            strBuf.append("<DIV id=\"globalNav\">Top Menu DIV</DIV>\n");
            strBuf.append("<DIV id=\"leftNav\">Left Menu DIV</DIV>\n");
        } else if (layoutStyle == 3) {
            strBuf.append("<DIV id=\"globalNav\">Top Menu DIV</DIV>\n");
            strBuf.append("<DIV id=\"subGlobalNav\">Second Menu DIV</DIV>\n");
        } else if (layoutStyle == 4) {
            strBuf.append("<DIV id=\"globalNav\">Top Menu DIV</DIV>\n");
            strBuf.append("<DIV id=\"subGlobalNav\">Second Menu DIV</DIV>\n");
            strBuf.append("<DIV id=\"leftNav\">Left Menu DIV</DIV>\n");
        }
        strBuf.append("<DIV id=\"content\">Working Area DIV</DIV>\n");
        strBuf.append("<DIV style=\"clear:both\"></DIV>\n<DIV id=\"siteInfo\">Foot Banner DIV</DIV>\n</BODY>\n</HTML>\n");
        return new ByteArrayInputStream(strBuf.toString().getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.ecc.ide", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

