/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewHtmlTaskInfoWizardPage
extends WizardPage {
    private Text containerText;
    private Text fileText;
    private ISelection selection;

    public NewHtmlTaskInfoWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("HTML task tree define File");
        this.setDescription("This wizard creates a new html task tree define file.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        this.containerText.setEnabled(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewHtmlTaskInfoWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewHtmlTaskInfoWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            IProject prj = null;
            if (obj instanceof IProject) {
                prj = (IProject)obj;
            } else if (obj instanceof IJavaProject) {
                prj = ((IJavaProject)obj).getProject();
            } else if (obj instanceof IPackageFragment) {
                IPackageFragment ip = (IPackageFragment)obj;
                prj = ip.getJavaProject().getProject();
            } else if (obj instanceof IResource) {
                IResource rc = (IResource)obj;
                prj = rc.getProject();
            }
            if (prj != null) {
                IDEProjectSettings settings = IDEContent.getPRJSettings(prj);
                String webRoot = "/WebContent/WEB-INF/server/htmlTrans/";
                if (settings != null) {
                    webRoot = "/" + settings.getWebContentPath() + "/" + settings.getSettingsRootPath() + "/" + settings.getHtmlLogicPath() + "/";
                }
                this.containerText.setText(prj.getFullPath() + webRoot);
            }
        }
        this.fileText.setText("new_file.tsk");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.getString("NewHtmlTransactionWizardPage.Select_new_file_container_12"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toOSString());
        }
    }

    private void dialogChanged() {
        String ext;
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus(Messages.getString("NewHtmlTransactionWizardPage.File_container_must_be_specified_13"));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.getString("NewHtmlTransactionWizardPage.File_name_must_be_specified_14"));
            return;
        }
        int dotLoc = fileName.indexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("tsk")) {
            this.updateStatus("File extension must be .tsk!");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }
}

