/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.wizards.Messages;
import com.ecc.ide.plugin.wizards.NewKJavaTransactionWizardPage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewKJavaTransactionWizard
extends Wizard
implements INewWizard {
    private NewKJavaTransactionWizardPage page;
    private ISelection selection;
    private String classify;
    private String trxCode;

    public NewKJavaTransactionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewKJavaTransactionWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        this.classify = this.page.getClassify();
        this.trxCode = this.page.getTrxCode();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Container [" + containerName + "] not exist!"));
            return false;
        }
        if (this.classify.length() > 0) {
            try {
                ECCIDEPlugin.createFolders(containerName, "designFiles/kjavaTrxs", this.classify);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)Messages.getString("NewHtmlTransactionWizard.failed_to_create_classify_folder_!_6"));
                return false;
            }
            containerName = String.valueOf(containerName) + "/" + this.classify;
        }
        final String cName = containerName;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewKJavaTransactionWizard.this.doFinish(cName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.getString("NewHtmlTransactionWizard.Opening_file_for_editing..._12"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String encoding = System.getProperty("file.encoding");
        if (ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("setXMLEncodingNamually")) {
            encoding = ECCIDEPlugin.getDefault().getPreferenceStore().getString("xmlEncoding");
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<?xml version=\"1.0\" encoding=\"");
        strBuf.append(encoding);
        strBuf.append("\" ?>\n\n");
        strBuf.append("<HTMLCltTrx ");
        strBuf.append("trxCode=\"" + this.trxCode + "\"");
        if (this.classify != null && this.classify.length() > 0) {
            strBuf.append(" classify=\"" + this.classify + "\"");
        }
        strBuf.append(" />");
        return new ByteArrayInputStream(strBuf.toString().getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.ecc.ide", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

