/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewKJavaTransactionWizardPage
extends WizardPage {
    private Text classifyText;
    private Text containerText;
    private Text fileText;
    private ISelection selection;
    private Text trxCodeText;

    public NewKJavaTransactionWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle("KJava Client Logic define File");
        this.setDescription("This wizard creates a new KJava client logic process define file");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        this.containerText.setEnabled(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewKJavaTransactionWizardPage.this.dialogChanged();
            }
        });
        Label labelTrxCode = new Label(container, 0);
        labelTrxCode.setText(Messages.getString("NewMCITransactionWizardPage.TrxCode__5"));
        this.trxCodeText = new Text(container, 2048);
        GridData gd1 = new GridData();
        gd1.horizontalSpan = 2;
        gd1.widthHint = 143;
        this.trxCodeText.setLayoutData((Object)gd);
        this.trxCodeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewKJavaTransactionWizardPage.this.fileText.setText(String.valueOf(NewKJavaTransactionWizardPage.this.trxCodeText.getText()) + "KJavaCltTrx.ktx");
            }
        });
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewKJavaTransactionWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
        Label label_1 = new Label(container, 0);
        label_1.setText(Messages.getString("NewHtmlTransactionWizardPage.classify__6"));
        this.classifyText = new Text(container, 2048);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 143;
        this.classifyText.setLayoutData((Object)gridData);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IProject) {
                IProject prj = (IProject)obj;
                this.containerText.setText(prj.getFullPath() + "/designFiles/kjavaTrxs/");
            } else if (obj instanceof IJavaProject) {
                IJavaProject prj = (IJavaProject)obj;
                this.containerText.setText(prj.getPath() + "/designFiles/kjavaTrxs/");
            } else if (obj instanceof IPackageFragment) {
                IPackageFragment ip = (IPackageFragment)obj;
                String path = String.valueOf(ip.getJavaProject().getPath().toString()) + "/designFiles/kjavaTrxs/";
                this.containerText.setText(path);
            } else if (obj instanceof IResource) {
                IResource rc = (IResource)obj;
                String path = String.valueOf(rc.getProject().getFullPath().toString()) + "/designFiles/kjavaTrxs/";
                this.containerText.setText(path);
            }
        }
        this.fileText.setText("new_file.ktx");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.getString("NewHtmlTransactionWizardPage.Select_new_file_container_12"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toOSString());
        }
    }

    private void dialogChanged() {
        String ext;
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus(Messages.getString("NewHtmlTransactionWizardPage.File_container_must_be_specified_13"));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.getString("NewHtmlTransactionWizardPage.File_name_must_be_specified_14"));
            return;
        }
        int dotLoc = fileName.indexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("ktx")) {
            this.updateStatus(Messages.getString("NewHtmlTransactionWizardPage.File_extension_must_be___htx__16"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getClassify() {
        return this.classifyText.getText();
    }

    public String getTrxCode() {
        return this.trxCodeText.getText();
    }
}

