/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.views.PrjViewXMLNode;
import com.ecc.ide.plugin.wizards.ComponentPropertyPage;
import com.ecc.ide.plugin.wizards.MCIActionComponentStatesWizardPage;
import com.ecc.ide.plugin.wizards.Messages;
import com.ecc.ide.plugin.wizards.NewMCIActionComponentWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewMCIActionComponentWizard
extends Wizard
implements INewWizard {
    private NewMCIActionComponentWizardPage page;
    private MCIActionComponentStatesWizardPage statesPage;
    private ComponentPropertyPage propertyPage;
    private ISelection selection;
    private IJavaProject javaProject;
    private IProject project;
    private IPackageFragmentRoot packageFragmentRoot;
    private EditorProfile profile;
    private Element element;
    private static ArrayList attrList = new ArrayList();
    private static HashMap mainAttrMap = new HashMap();

    public NewMCIActionComponentWizard() {
        this.setNeedsProgressMonitor(true);
        NewMCIActionComponentWizard.initMainAttrMap();
    }

    public NewMCIActionComponentWizard(IProject project) {
        this.project = project;
        this.setNeedsProgressMonitor(true);
        NewMCIActionComponentWizard.initMainAttrMap();
    }

    public void addPages() {
        this.page = new NewMCIActionComponentWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
        this.statesPage = new MCIActionComponentStatesWizardPage(this.selection);
        this.addPage((IWizardPage)this.statesPage);
        this.propertyPage = new ComponentPropertyPage(this.selection);
        this.addPage((IWizardPage)this.propertyPage);
        try {
            this.element = new Element();
            ECCIDEPlugin plugin = ECCIDEPlugin.getDefault();
            this.profile = IDEProfile.getEditorProfile(this.project, 5);
            XMLNode classDefine = IDEContent.getSettingNode(this.project, 27);
            this.propertyPage.setEditorProfile(this.profile);
            this.propertyPage.setElement(this.element);
            this.propertyPage.setDefinedClass(classDefine);
            this.propertyPage.setFunctionProfile(IDEProfile.getEditorProfile(this.project, 16));
            this.propertyPage.setFunctionXMLNode(IDEContent.getSettingNode(this.project, 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean performFinish() {
        ElementCatalog catalog;
        String containerName = this.page.getContainerName();
        String fileName = this.page.getFileName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Container [" + containerName + "] not exist!"));
            return false;
        }
        final String cName = containerName;
        final String pkgName = this.page.getPackage();
        final String className = this.page.getClassName();
        String elementName = this.page.getElementName();
        this.element.setElementName(className);
        this.element.setLabel(elementName);
        this.element.setIconName("/images/newElement.gif");
        this.element.setImplClass(String.valueOf(pkgName) + "." + className);
        this.element.setWrapperClassType("com.ecc.ide.editor.visualflow.ActionElementWrapper");
        String statesStr = this.statesPage.getStatesStr();
        if (statesStr.length() > 0) {
            ElementAttribute attr = new ElementAttribute();
            attr.setAttrID("states");
            attr.setAttrName("states");
            attr.setEditable(false);
            attr.setValueListStr(statesStr);
            this.element.addAttribute(attr);
        }
        if ((catalog = this.profile.getElementCatalog("extendedElements")) == null) {
            catalog = new ElementCatalog();
            catalog.setCatalogName("extendedElements");
            catalog.setLabel("extendedElements");
            this.profile.addElementCatalog(catalog);
        }
        catalog.addElement(this.element);
        Element flowElement = this.profile.getElement2("flow");
        Element stateElement = this.profile.getElement2("State");
        ElementChild eChild = new ElementChild();
        eChild.setChildElementId(className);
        eChild.setAllowCount("*");
        flowElement.addChild(eChild);
        stateElement.addChild(eChild);
        IDEProfile.saveEditorProfile(this.project, 5);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewMCIActionComponentWizard.this.doFinish(cName, pkgName, className, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String pkgName, String className, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + className + ".java", 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        IPackageFragment pkgFragment = this.packageFragmentRoot.createPackageFragment(pkgName, false, monitor);
        NewMCIActionComponentWizard.setMainAttrMap("id", className);
        NewMCIActionComponentWizard.setMainAttrMap("implClass", String.valueOf(pkgName) + "." + className);
        String content = this.openContentStream(pkgName, className);
        ICompilationUnit compUnit = pkgFragment.createCompilationUnit(String.valueOf(className) + ".java", content, false, monitor);
        String fileName = compUnit.getResource().getProjectRelativePath().toString();
        final IFile file = container.getProject().getFile((IPath)new Path(fileName));
        monitor.worked(1);
        monitor.setTaskName(Messages.getString("NewHtmlTransactionWizard.Opening_file_for_editing..._12"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
        attrList.clear();
    }

    private String openContentStream(String pkgStr, String className) {
        String method = this.getSetAndGetMetheod();
        String attrs = this.getStringAttr();
        String src = "import com.ecc.emp.core.Context;\nimport com.ecc.emp.flow.EMPAction;\n\n\t/**\n\t\t* " + className + ".java<br>\n" + "\t* EMP \u4ea4\u6613\u6b65\u9aa4\u6269\u5c55<br>\n" + "\t* Extends class EMPAction<br>\n" + "\t* Created on  " + this.getTime() + "<br>\n" + "\t* @autor        <br>\n" + "\n" + "\t* @id " + mainAttrMap.get("id").toString() + "\n" + "\t* @name " + mainAttrMap.get("name").toString() + "\n" + "\t* @iconName " + mainAttrMap.get("iconName").toString() + "\n" + "\t* @implClass " + mainAttrMap.get("implClass").toString() + "\n" + "\t* @wrapperClass " + mainAttrMap.get("wrapperClass").toString() + "\n" + "\t* @editClass " + mainAttrMap.get("editClass").toString() + "\n" + "\t* @wizardClass " + mainAttrMap.get("wizardClass").toString() + "\n" + "\t* @visable " + mainAttrMap.get("visable").toString() + "\n" + "\t* @document " + mainAttrMap.get("document").toString() + "\n" + "\t* @childElements " + mainAttrMap.get("childElements").toString() + "\n" + "\t* @attributes " + mainAttrMap.get("attributes").toString() + "\n\n" + "\t*/\n" + "public class TestAction extends EMPAction {\n" + attrs + "\n\n\n\t/*\u4e1a\u52a1\u903b\u8f91\u64cd\u4f5c\u5355\u5143\u7684\u6267\u884c\u5165\u53e3*/\n" + "\tpublic String execute(Context context)\n" + "\t{\n\t\treturn \"0\";\n\t}\n" + method + "\n}\n";
        src = "package " + pkgStr + ";\n" + src.replaceAll("TestAction", className);
        return src;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.ecc.ide", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof PrjViewXMLNode) {
                obj = ((PrjViewXMLNode)obj).getProject();
            }
            if (obj instanceof IProject) {
                IProject prj;
                this.project = prj = (IProject)obj;
                try {
                    this.javaProject = (IJavaProject)this.project.getNature("org.eclipse.jdt.core.javanature");
                    String path = prj.getFullPath().toString();
                    IPackageFragmentRoot[] roots = this.javaProject.getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        String resouce = roots[i].getResource().toString();
                        if (resouce.indexOf(path) != -1) {
                            this.packageFragmentRoot = roots[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception path) {}
            } else if (obj instanceof IJavaProject) {
                IJavaProject prj = (IJavaProject)obj;
                this.project = prj.getProject();
                this.javaProject = prj;
                String path = prj.getProject().getFullPath().toString();
                try {
                    IPackageFragmentRoot[] roots = prj.getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        String resouce = roots[i].getResource().toString();
                        if (resouce.indexOf(path) != -1) {
                            this.packageFragmentRoot = roots[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception roots) {}
            } else if (obj instanceof IPackageFragment) {
                IPackageFragment ip = (IPackageFragment)obj;
                IJavaProject prj = ip.getJavaProject();
                String path = prj.getPath().toString();
                IPackageFragmentRoot root = (IPackageFragmentRoot)ip.getParent();
                System.out.println(root.getPath());
                this.project = prj.getProject();
                this.javaProject = prj;
                this.packageFragmentRoot = root;
            }
        }
    }

    private String getTime() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("", Locale.SIMPLIFIED_CHINESE);
        formatter.applyPattern("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2");
        String time = formatter.format(date);
        return time;
    }

    public static void setAttrList(TableItem tableItem) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", tableItem.getText(0));
        map.put("name", tableItem.getText(1));
        map.put("mustSet", tableItem.getText(2));
        map.put("editable", tableItem.getText(3));
        map.put("attrType", tableItem.getText(4));
        map.put("editorClass", tableItem.getText(5));
        map.put("desc", tableItem.getText(6));
        attrList.add(map);
        System.out.println(attrList.size());
    }

    private String[] getAttrType() {
        String[] attrType = new String[attrList.size()];
        int i = 0;
        while (i < attrList.size()) {
            HashMap map = (HashMap)attrList.get(i);
            attrType[i] = map.get("attrType").toString();
            ++i;
        }
        return attrType;
    }

    private String[] getAttrs() {
        String[] attr = new String[attrList.size()];
        int i = 0;
        while (i < attrList.size()) {
            HashMap map = (HashMap)attrList.get(i);
            attr[i] = map.get("id").toString();
            ++i;
        }
        return attr;
    }

    private String getStringAttr() {
        String[] attr = this.getAttrs();
        String[] attrType = this.getAttrType();
        String attrStr = "";
        int i = 0;
        while (i < attr.length) {
            attrStr = String.valueOf(attrStr) + "\n\tprivate " + attrType[i] + " " + attr[i] + ";";
            ++i;
        }
        return attrStr;
    }

    private String getSetAndGetMetheod() {
        String attributes = " ";
        String[] attr = this.getAttrs();
        String[] attrType = this.getAttrType();
        String attrStr = "";
        int i = 0;
        while (i < attr.length) {
            String str = attr[i].substring(0, 1).toUpperCase();
            str = String.valueOf(str) + attr[i].substring(1, attr[i].length());
            String arg = "new" + str;
            attrStr = String.valueOf(attrStr) + this.getJavaDoc(attr[i]);
            attrStr = String.valueOf(attrStr) + "\n\tpublic void ";
            attrStr = String.valueOf(attrStr) + "set" + str + "(" + attrType[i] + " " + arg + "){";
            attributes = String.valueOf(attributes) + "set" + str + "(" + attrType[i] + " " + arg + ") ";
            attrStr = String.valueOf(attrStr) + "\n\t\t" + attr[i] + " = " + arg + ";\n\t}";
            attrStr = String.valueOf(attrStr) + "\n\tpublic " + attrType[i] + " get" + str + "(){";
            attrStr = String.valueOf(attrStr) + "\n\t\treturn " + attr[i] + ";\n\t}";
            ++i;
        }
        NewMCIActionComponentWizard.setMainAttrMap("attributes", attributes);
        return attrStr;
    }

    private String getJavaDoc(String str) {
        HashMap map = this.findAttr(str);
        if (map == null) {
            return null;
        }
        String javaDoc = "\n\t/**\n";
        javaDoc = String.valueOf(javaDoc) + "\t\t* @id " + str + "\n";
        javaDoc = String.valueOf(javaDoc) + "\t\t* @name " + map.get("name").toString() + "\n" + "\t\t* @desc " + map.get("desc").toString() + "\n" + "\t\t* @mustSet " + map.get("mustSet").toString() + "\n" + "\t\t* @editable " + map.get("editable").toString() + "\n" + "\t\t* @attrType " + map.get("attrType").toString() + "\n" + "\t\t* @editorClass " + map.get("editorClass").toString() + "\n" + "\t\t* @isAttribute " + "true\n" + "\t\t* @valueList\n" + "\t\t* @defaultValue\n";
        javaDoc = String.valueOf(javaDoc) + "\t*/\n\n";
        return javaDoc;
    }

    private HashMap findAttr(String str) {
        int i = 0;
        while (i < attrList.size()) {
            HashMap map = (HashMap)attrList.get(i);
            if (str.equals(map.get("id").toString())) {
                return map;
            }
            ++i;
        }
        return null;
    }

    private static void initMainAttrMap() {
        mainAttrMap.put("id", "");
        mainAttrMap.put("name", "");
        mainAttrMap.put("iconName", "");
        mainAttrMap.put("implClass", "");
        mainAttrMap.put("wrapperClass", "");
        mainAttrMap.put("editClass", "");
        mainAttrMap.put("wizardClass", "");
        mainAttrMap.put("visable", "");
        mainAttrMap.put("childElements", "");
        mainAttrMap.put("document", "");
        mainAttrMap.put("attributes", "");
    }

    public static void setMainAttrMap(String str, String attr) {
        mainAttrMap.put(str, attr);
    }
}

