/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewMCIBusinessLogicWizardPage
extends WizardPage {
    private Text classifyText;
    private Text trxNameText;
    private Text trxCodeText;
    private Text containerText;
    private Text fileText;
    private ISelection selection;

    public NewMCIBusinessLogicWizardPage(ISelection selection) {
        super(Messages.getString("NewMCITransactionWizardPage.wizardPage_1"));
        this.setTitle(Messages.getString("NewMCITransactionWizardPage.ECC_MCI_Transaction_Editor_File_2"));
        this.setDescription(Messages.getString("NewMCITransactionWizardPage.This_wizard_creates_a_new_file_with_*.mtx_extension_that_can_be_opened_by_a_MCI_Transaction_editor._3"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Text(container, 2052);
        this.containerText.setEnabled(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMCIBusinessLogicWizardPage.this.dialogChanged();
            }
        });
        Label label_1 = new Label(container, 0);
        label_1.setText("Business logic ID:");
        this.trxCodeText = new Text(container, 2048);
        this.trxCodeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMCIBusinessLogicWizardPage.this.fileText.setText(String.valueOf(NewMCIBusinessLogicWizardPage.this.trxCodeText.getText()) + ".biz");
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 199;
        this.trxCodeText.setLayoutData((Object)gridData);
        Label label_2 = new Label(container, 0);
        label_2.setText(Messages.getString("NewMCITransactionWizardPage.TrxName__7"));
        this.trxNameText = new Text(container, 2048);
        GridData gridData_1 = new GridData(768);
        gridData_1.horizontalSpan = 2;
        this.trxNameText.setLayoutData((Object)gridData_1);
        Label label_3 = new Label(container, 0);
        label_3.setText(Messages.getString("NewMCITransactionWizardPage.Classify__8"));
        this.classifyText = new Text(container, 2048);
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 147;
        gridData_2.horizontalSpan = 2;
        this.classifyText.setLayoutData((Object)gridData_2);
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMCIBusinessLogicWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IProject) {
                IProject prj = (IProject)obj;
                this.containerText.setText(prj.getFullPath() + "/designFiles/MCITrxs/");
            } else if (obj instanceof IJavaProject) {
                IJavaProject prj = (IJavaProject)obj;
                this.containerText.setText(prj.getPath() + "/designFiles/MCITrxs/");
            } else if (obj instanceof IPackageFragment) {
                IPackageFragment ip = (IPackageFragment)obj;
                String path = String.valueOf(ip.getJavaProject().getPath().toString()) + "/designFiles/MCITrxs/";
                this.containerText.setText(path);
            } else if (obj instanceof IResource) {
                IResource rc = (IResource)obj;
                String path = String.valueOf(rc.getProject().getFullPath().toString()) + "/designFiles/MCITrxs/";
                this.containerText.setText(path);
            }
        }
        this.fileText.setText("newEMPBusinessLogic.biz");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.getString("NewMCITransactionWizardPage.Select_new_file_container_15"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toOSString());
        }
    }

    private void dialogChanged() {
        String ext;
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus(Messages.getString("NewMCITransactionWizardPage.File_container_must_be_specified_16"));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.getString("NewMCITransactionWizardPage.File_name_must_be_specified_17"));
            return;
        }
        int dotLoc = fileName.indexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase("biz")) {
            this.updateStatus("File extension must be \"biz\"");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getTrxCode() {
        return this.trxCodeText.getText();
    }

    public String getTrxName() {
        return this.trxNameText.getText();
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getClassify() {
        return this.classifyText.getText();
    }
}

