/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.wizards.ComponentPropertyPage;
import com.ecc.ide.plugin.wizards.Messages;
import com.ecc.ide.plugin.wizards.NewMCIServiceComponentWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewMCIServiceComponentWizard
extends Wizard
implements INewWizard {
    private NewMCIServiceComponentWizardPage page;
    private ComponentPropertyPage propertyPage;
    private ISelection selection;
    private IJavaProject javaProject;
    private IProject project;
    private IPackageFragmentRoot packageFragmentRoot;
    private EditorProfile profile;
    private Element element;

    public NewMCIServiceComponentWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewMCIServiceComponentWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
        this.propertyPage = new ComponentPropertyPage(this.selection);
        this.addPage((IWizardPage)this.propertyPage);
        try {
            this.element = new Element();
            ECCIDEPlugin plugin = ECCIDEPlugin.getDefault();
            this.profile = IDEProfile.getEditorProfile(this.project, 13);
            XMLNode classDefine = IDEContent.getSettingNode(this.project, 27);
            this.propertyPage.setEditorProfile(this.profile);
            this.propertyPage.setElement(this.element);
            this.propertyPage.setDefinedClass(classDefine);
            this.propertyPage.setFunctionProfile(IDEProfile.getEditorProfile(this.project, 16));
            this.propertyPage.setFunctionXMLNode(IDEContent.getSettingNode(this.project, 16));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean performFinish() {
        String containerName = this.page.getContainerName();
        String fileName = this.page.getFileName();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Container [" + containerName + "] not exist!"));
            return false;
        }
        final String cName = containerName;
        final String pkgName = this.page.getPackage();
        final String className = this.page.getClassName();
        String elementName = this.page.getElementName();
        this.element.setElementName(className);
        this.element.setLabel(elementName);
        this.element.setIconName("/images/newElement.gif");
        this.element.setImplClass(String.valueOf(pkgName) + "." + className);
        ElementCatalog catalog = this.profile.getElementCatalog("extendedElements");
        if (catalog == null) {
            catalog = new ElementCatalog();
            catalog.setCatalogName("extendedElements");
            catalog.setLabel("extendedElements");
            this.profile.addElementCatalog(catalog);
        }
        catalog.addElement(this.element);
        Element svcsElement = this.profile.getElement("Services");
        ElementChild eChild = new ElementChild();
        eChild.setChildElementId(className);
        eChild.setAllowCount("*");
        svcsElement.addChild(eChild);
        IDEProfile.saveEditorProfile(this.project, 13);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewMCIServiceComponentWizard.this.doFinish(cName, pkgName, className, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String pkgName, String className, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + className + ".java", 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        IPackageFragment pkgFragment = this.packageFragmentRoot.createPackageFragment(pkgName, false, monitor);
        String content = this.openContentStream(pkgName, className);
        ICompilationUnit compUnit = pkgFragment.createCompilationUnit(String.valueOf(className) + ".java", content, false, monitor);
        String fileName = compUnit.getResource().getProjectRelativePath().toString();
        final IFile file = container.getProject().getFile((IPath)new Path(fileName));
        monitor.worked(1);
        monitor.setTaskName(Messages.getString("NewHtmlTransactionWizard.Opening_file_for_editing..._12"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private String openContentStream(String pkgStr, String className) {
        String src = "import org.w3c.dom.Node;\nimport com.ecc.cte.base.CTEException;\nimport com.ecc.cte.base.Service;\npublic class TestService extends Service {\n/**\n* \u7c7b\u521d\u59cb\u5316\u5165\u53e3\uff0c\u5728\u5916\u90e8\u5b9a\u4e49\u5b9e\u5217\u5316\u65f6\u8c03\u7528, return null \u4ee3\u8868\u4e0d\u9700\u8981\u5e73\u53f0\n* \u89e3\u91ca\u4ed6\u5e26\u7684\u5b50\u8282\u70b9\uff0creturn this \u4ee3\u8868\u9700\u8981\u5e73\u53f0\u89e3\u91ca\u4ed6\u5e26\u7684\u5b50\u8282\u70b9\n* @param aNode org.w3c.dom.Node\n* @return java.lang.Object\n*/\n\tpublic Object persistentFrom(Node aNode)throws CTEException {\n\t\t//return null;\n\t\treturn this;\n\t}\n\t/**\n\t* \u7ed3\u675f\u670d\u52a1\uff0c\u7531\u7cfb\u7edf\u8c03\u7528\uff0c\u5f53\u9700\u8981\u505c\u6b62\u670d\u52a1\u65f6\u8c03\u7528\uff0c\u8ba9\u670d\u52a1\u8fdb\u884c\u6e05\u7406\u52a8\u4f5c\uff0c\u5982\u5728\u91cd\u65b0\u542f\u52a8\u670d\u52a1\u5668\u65f6\u3002\n\t* \u5728\u6b64\u65b9\u6cd5\u4e2d\u5e94\u8be5\u5b9e\u73b0\u5fc5\u8981\u7684\u6e05\u7406\u5de5\u4f5c\u3002\n\t*\n\t* @exception com.ecc.cte.base.CTEException The exception description.\n\t*/\n\tpublic void terminate() throws CTEException {\n\t}\n}\n";
        src = "package " + pkgStr + ";\n" + src.replaceAll("TestService", className);
        return src;
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.ecc.ide", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IProject) {
                IProject prj;
                this.project = prj = (IProject)obj;
                try {
                    this.javaProject = (IJavaProject)this.project.getNature("org.eclipse.jdt.core.javanature");
                    String path = prj.getFullPath().toString();
                    IPackageFragmentRoot[] roots = this.javaProject.getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        String resouce = roots[i].getResource().toString();
                        if (resouce.indexOf(path) != -1) {
                            this.packageFragmentRoot = roots[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception path) {}
            } else if (obj instanceof IJavaProject) {
                IJavaProject prj = (IJavaProject)obj;
                this.project = prj.getProject();
                this.javaProject = prj;
                String path = prj.getProject().getFullPath().toString();
                try {
                    IPackageFragmentRoot[] roots = prj.getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        String resouce = roots[i].getResource().toString();
                        if (resouce.indexOf(path) != -1) {
                            this.packageFragmentRoot = roots[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception roots) {
                    // empty catch block
                }
                System.out.println(this.packageFragmentRoot.getPath());
            } else if (obj instanceof IPackageFragment) {
                IPackageFragment ip = (IPackageFragment)obj;
                IJavaProject prj = ip.getJavaProject();
                String path = prj.getPath().toString();
                IPackageFragmentRoot root = (IPackageFragmentRoot)ip.getParent();
                System.out.println(root.getPath());
                this.project = prj.getProject();
                this.javaProject = prj;
                this.packageFragmentRoot = root;
            }
        }
    }
}

