/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.plugin.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewMCIServiceComponentWizardPage
extends WizardPage {
    private Text containerText;
    private Text packageText;
    private Text classNameText;
    private Text nameText;
    private ISelection selection;

    public NewMCIServiceComponentWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(Messages.getString("NewServiceWizard.titleLabel"));
        this.setDescription(Messages.getString("NewServiceWizard.descLabel"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(Messages.getString("NewComponentWizard.sourceFolderLabel"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMCIServiceComponentWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString("NewComponentWizard.packageNameLabel"));
        this.packageText = new Text(container, 2052);
        gd = new GridData(768);
        this.packageText.setLayoutData((Object)gd);
        this.packageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMCIServiceComponentWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString("NewComponentWizard.componentIdLabel"));
        this.classNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.classNameText.setLayoutData((Object)gd);
        this.classNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMCIServiceComponentWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(Messages.getString("NewComponentWizard.componentNameLabel"));
        this.nameText = new Text(container, 2052);
        gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMCIServiceComponentWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IProject) {
                IProject prj = (IProject)obj;
                this.containerText.setText(prj.getFullPath().toString());
            } else if (obj instanceof IJavaProject) {
                IJavaProject prj = (IJavaProject)obj;
                String path = prj.getProject().getFullPath().toString();
                IPackageFragmentRoot root = null;
                try {
                    IPackageFragmentRoot[] roots = prj.getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        String resouce = roots[i].getResource().toString();
                        if (resouce.indexOf(path) != -1) {
                            root = roots[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception roots) {
                    // empty catch block
                }
                if (root != null) {
                    this.containerText.setText(root.getResource().getFullPath().toString());
                } else {
                    this.containerText.setText(prj.getPath().toString());
                }
            } else if (obj instanceof IPackageFragment) {
                IPackageFragment ip = (IPackageFragment)obj;
                IJavaProject prj = ip.getJavaProject();
                String path = prj.getPath().toString();
                IPackageFragmentRoot root = (IPackageFragmentRoot)ip.getParent();
                this.containerText.setText(root.getResource().getFullPath().toString());
                this.packageText.setText(ip.getElementName());
            } else if (obj instanceof IResource) {
                IResource rc = (IResource)obj;
                String path = rc.getProject().getFullPath().toString();
                this.containerText.setText(path);
            }
        }
        this.classNameText.setText("MyNewMCIService");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.getString("NewHtmlTransactionWizardPage.Select_new_file_container_12"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toOSString());
        }
    }

    private void dialogChanged() {
        String container = this.getContainerName();
        String fileName = this.getFileName();
        if (container.length() == 0) {
            this.updateStatus(Messages.getString("NewHtmlTransactionWizardPage.File_container_must_be_specified_13"));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(Messages.getString("NewHtmlTransactionWizardPage.File_name_must_be_specified_14"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        return String.valueOf(this.classNameText.getText()) + ".java";
    }

    public String getPackage() {
        return this.packageText.getText();
    }

    public String getClassName() {
        return this.classNameText.getText();
    }

    public String getElementName() {
        return this.nameText.getText();
    }
}

