/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.plugin.wizards.NewMCITransactionWizardPage;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewMCITransactionWizard
extends Wizard
implements INewWizard {
    private NewMCITransactionWizardPage page;
    private String trxCode = null;
    private IFolder parentFolder = null;

    public NewMCITransactionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        String grpId = IDEContent.getGroupId(this.parentFolder.getLocation().toOSString());
        this.page = new NewMCITransactionWizardPage(this.parentFolder.getProject(), grpId);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.trxCode = this.page.getTrxCode();
        if (this.trxCode == null || this.trxCode.length() == 0) {
            return false;
        }
        if (this.parentFolder == null || this.parentFolder.findMember(this.page.getFileName()) != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("BizModel[" + this.trxCode + "] already exists!"));
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.ecc.ide", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setSelection(IStructuredSelection selection) {
    }

    public String getBizId() {
        if (this.trxCode.endsWith(".biz")) {
            this.trxCode = this.trxCode.substring(0, this.trxCode.lastIndexOf(".biz"));
        }
        return this.trxCode;
    }

    public String getTmplateBizId() {
        return this.page.getTemplateBizId();
    }

    public void setParentFolder(Object parentFolder) {
        if (parentFolder instanceof IFolder) {
            this.parentFolder = (IFolder)parentFolder;
        }
    }
}

