/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards;

import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.wizards.Messages;
import com.ecc.ide.plugin.wizards.NewTellerTransactionWizardPage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewTellerTransactionWizard
extends Wizard
implements INewWizard {
    private NewTellerTransactionWizardPage page;
    private ISelection selection;
    private String trxCode = null;
    private String trxName = null;
    private String srvTrxCode = null;
    private String classify = null;
    private IProject project;

    public NewTellerTransactionWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new NewTellerTransactionWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        this.trxCode = this.page.getTrxCode();
        this.srvTrxCode = this.page.getSrvTrxCode();
        this.trxName = this.page.getTrxName();
        this.classify = this.page.getClassify();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null || !resource.exists() || !(resource instanceof IContainer)) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewTellerTransactionWizard.Error_1"), (String)(String.valueOf(Messages.getString("NewTellerTransactionWizard.Container_[_2")) + containerName + Messages.getString("NewTellerTransactionWizard.]_not_exist_!_3")));
            return false;
        }
        if (this.classify.length() > 0) {
            try {
                ECCIDEPlugin.createFolders(containerName, "designFiles/tellerTrxs", this.classify);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewTellerTransactionWizard.Error_5"), (String)Messages.getString("NewTellerTransactionWizard.failed_to_create_classify_folder_!_6"));
                return false;
            }
            containerName = String.valueOf(containerName) + "/" + this.classify;
        }
        final String cName = containerName;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewTellerTransactionWizard.this.doFinish(cName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewTellerTransactionWizard.Error_8"), (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(String.valueOf(Messages.getString("NewTellerTransactionWizard.Container___10")) + containerName + Messages.getString("NewTellerTransactionWizard.__does_not_exist._11"));
        }
        IContainer container = (IContainer)resource;
        this.project = container.getProject();
        final IFile file = container.getFile((IPath)new Path(fileName));
        if (file.exists()) {
            this.throwCoreException(Messages.getString("NewTellerTransactionWizard.File_still_exist_!_12"));
        }
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException stream) {
            // empty catch block
        }
        try {
            XMLNode aTask = new XMLNode();
            aTask.setNodeName("TaskInfo");
            aTask.setAttrValue("transactionCode", this.trxCode);
            aTask.setAttrValue("name", this.trxName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.getString("NewTellerTransactionWizard.Opening_file_for_editing..._16"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream() {
        String encoding = System.getProperty("file.encoding");
        if (ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("setXMLEncodingNamually")) {
            encoding = ECCIDEPlugin.getDefault().getPreferenceStore().getString("xmlEncoding");
        }
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<?xml version=\"1.0\" encoding=\"");
        strBuf.append(encoding);
        strBuf.append("\" ?>\n\n");
        strBuf.append("<TellerTransaction ");
        if (this.trxCode != null && this.trxCode.length() > 0) {
            strBuf.append(" trxCode=\"" + this.trxCode + "\"");
        }
        if (this.trxName != null && this.trxName.length() > 0) {
            strBuf.append(" trxName=\"" + this.trxName + "\"");
        }
        if (this.srvTrxCode != null) {
            strBuf.append(" srvTrxCode=\"" + this.srvTrxCode + "\"");
        }
        if (this.classify != null && this.classify.length() > 0) {
            strBuf.append(" classify=\"" + this.classify + "\"");
        }
        try {
            EditorProfile profile = IDEProfile.getEditorProfile(this.project, 18);
            Element element = profile.getElement("TaskProperty");
            Vector attrs = element.getAttributes();
            int i = 0;
            while (i < attrs.size()) {
                ElementAttribute attr = (ElementAttribute)attrs.elementAt(i);
                String dftValue = attr.getDefaultValue();
                String attrId = attr.getAttrID();
                if (attrId != null && dftValue != null) {
                    strBuf.append(" ");
                    strBuf.append(attrId);
                    strBuf.append("=\"");
                    strBuf.append(dftValue);
                    strBuf.append("\"");
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        strBuf.append(" />");
        return new ByteArrayInputStream(strBuf.toString().getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.ecc.ide", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

