/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.plugin.wizards.newFile;

import com.ecc.ide.plugin.wizards.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class NewMVCModelWizardPage
extends WizardPage {
    private Text containerText;
    private Text mvcIdText;
    private ISelection selection;
    private Text fileText;

    public NewMVCModelWizardPage(ISelection selection) {
        super("EMP Application");
        this.setTitle("EMP Application");
        this.setDescription("\u6b64\u5411\u5bfc\u5c06\u521b\u5efa\u4e00\u4e2a\u4ee5 *.mvc \u4e3a\u540e\u7f00\u7684EMP\u8868\u73b0\u903b\u8f91\u5904\u7406\u6a21\u578b\u6587\u4ef6\uff0c\u5b83\u53ef\u4ee5\u7531MVC\u7f16\u8f91\u5668\u8fdb\u884c\u53ef\u89c6\u7f16\u8f91.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label sourceFolderLabel = new Label(container, 0);
        sourceFolderLabel.setLayoutData((Object)new GridData(89, 18));
        sourceFolderLabel.setText("Source Folder:");
        this.containerText = new Text(container, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 240;
        this.containerText.setLayoutData((Object)gridData);
        Label label_3 = new Label(container, 0);
        label_3.setText("\u8868\u73b0\u903b\u8f91\u6784\u4ef6ID:");
        this.mvcIdText = new Text(container, 2048);
        GridData gridData_2 = new GridData(378, -1);
        this.mvcIdText.setLayoutData((Object)gridData_2);
        Label label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Text(container, 2052);
        this.fileText.setEnabled(false);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.fileText.setLayoutData((Object)gd);
        this.mvcIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewMVCModelWizardPage.this.fileText.setText(String.valueOf(NewMVCModelWizardPage.this.mvcIdText.getText()) + ".mvc");
            }
        });
        this.fileText.setText(".mvc");
        this.initialize();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IProject) {
                IProject prj = (IProject)obj;
                this.containerText.setText(prj.getFullPath().toString());
            } else if (obj instanceof IJavaProject) {
                IJavaProject prj = (IJavaProject)obj;
                String path = prj.getProject().getFullPath().toString();
                IPackageFragmentRoot root = null;
                try {
                    IPackageFragmentRoot[] roots = prj.getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < roots.length) {
                        String resouce = roots[i].getResource().toString();
                        if (resouce.indexOf(path) != -1) {
                            root = roots[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (Exception roots) {
                    // empty catch block
                }
                if (root != null) {
                    this.containerText.setText(root.getResource().getFullPath().toString());
                } else {
                    this.containerText.setText(prj.getPath().toString());
                }
            } else if (obj instanceof IPackageFragment) {
                IPackageFragment ip = (IPackageFragment)obj;
                IJavaProject prj = ip.getJavaProject();
                String path = prj.getPath().toString();
                IPackageFragmentRoot root = (IPackageFragmentRoot)ip.getParent();
                this.containerText.setText(root.getResource().getFullPath().toString());
            } else if (obj instanceof IResource) {
                IResource rc = (IResource)obj;
                String path = rc.getProject().getFullPath().toString();
                this.containerText.setText(path);
            }
        }
    }

    private void handleBrowse() {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, Messages.getString("NewMCITransactionWizardPage.Select_new_file_container_15"));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            int cfr_ignored_0 = result.length;
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public String getMvcId() {
        return this.mvcIdText.getText();
    }

    public String getContainerTextName() {
        return this.containerText.getText();
    }
}

