/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.MCITransactionBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.popup.actions.IDEPluginAction;
import com.ecc.ide.popup.actions.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IObjectActionDelegate;

public class BuildAllMCITrxAction
extends IDEPluginAction
implements IObjectActionDelegate,
BuildProblemReporter {
    private Vector filesToBuild = new Vector();

    public void initPath() {
        String webContentPath = this.prjSettings.getWebContentPath();
        String settingsRootPath = this.prjSettings.getSettingsRootPath();
        String businessLogicPath = this.prjSettings.getBusinessLogicPath();
        this.relativePath = "/" + webContentPath;
        this.settingPath = "/" + webContentPath + "/" + settingsRootPath + "/" + businessLogicPath;
        this.targetPath = this.project.getLocation() + this.settingPath;
    }

    public void run(IProgressMonitor monitor) {
        this.reportProblem(0, Messages.getString("BuildAllMCITrxAction._u91CD_u5EFA_u5168_u90E8MCI_u4EA4_u6613..._1"), "", "", null);
        if (this.targetPath == null || this.targetPath.length() == 0) {
            return;
        }
        this.filesToBuild.removeAllElements();
        String path = String.valueOf(this.project.getLocation().toString()) + "/designFiles/MCITrxs";
        this.scanMCITrxList(path);
        this.fileName = new String[this.filesToBuild.size()];
        this.relativeFilePath = new String[this.filesToBuild.size()];
        int i = 0;
        while (i < this.fileName.length) {
            this.fileName[i] = (String)this.filesToBuild.elementAt(i);
            int p = this.fileName[i].lastIndexOf("/");
            if (p != -1) {
                this.relativeFilePath[i] = this.fileName[i].substring(p);
            }
            ++i;
        }
        MCITransactionBuilder builder = new MCITransactionBuilder();
        builder.setOutputPath(this.targetPath);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        builder.setProblemReporter(this);
        try {
            builder.setDataDictionaryEditorProfile(IDEProfile.getEditorProfile(this.project, 1));
            builder.setFlowEditorProfile(ModuleUtility.getActionFlowProfile(this.project));
            builder.setServiceEditorProfile(IDEProfile.getEditorProfile(this.project, 13));
            builder.setDataDictionary(IDEContent.getSettingNode(this.project, 0));
            builder.setFlow(IDEContent.getSettingNode(this.project, 5));
            builder.setHostSettings(IDEContent.getSettingNode(this.project, 11));
            builder.setPackageType(IDEContent.getSettingNode(this.project, 14));
            builder.setStateMachineEditorProfile(IDEProfile.getEditorProfile(this.project, 23));
            builder.setStateEditorProfile(ModuleUtility.getActionFlowProfile(this.project));
            builder.setCommonStates(IDEContent.getSettingNode(this.project, 23));
            builder.setCommonStateMachine(IDEContent.getSettingNode(this.project, 21));
            builder.setBuildStateMachineAsOperation(ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("buildStateMachineAsOperation"));
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
        monitor.beginTask(Messages.getString("BuildMCITrxAction.Build_MCI_Transaction_runtime__!_3"), this.fileName.length);
        int i2 = 0;
        while (i2 < this.fileName.length) {
            monitor.subTask(String.valueOf(Messages.getString("BuildMCITrxAction.Build_MCI_Transaction__4")) + this.relativeFilePath[i2]);
            monitor.worked(1);
            builder.buildMCITransaction(this.fileName[i2]);
            this.reportProblem(0, Messages.getString("BuildMCITrxAction.Build_ECC_MCI_Trx_finished_!_3"), this.relativeFilePath[i2], "", null);
            XMLNode content = builder.loadXMLContent(this.fileName[i2]);
            String classify = content.getAttrValue("classify");
            String string = content.getAttrValue("trxCode");
            ++i2;
        }
        try {
            this.project.getFolder(this.settingPath).refreshLocal(1, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.reportProblem(0, Messages.getString("BuildAllMCITrxAction._u91CD_u5EFA_u5168_u90E8MCI_u4EA4_u6613_u5B8C_u6210_3"), "", "", null);
    }

    private void scanMCITrxList(String path) {
        try {
            File TrxPathFolder = new File(path);
            String[] files = TrxPathFolder.list();
            int i = 0;
            while (i < files.length) {
                try {
                    if (files[i].endsWith(".mtx")) {
                        this.filesToBuild.add(String.valueOf(path) + "/" + files[i]);
                    } else {
                        FileInputStream in = new FileInputStream(String.valueOf(path) + "/" + files[i]);
                        if (in != null) {
                            // empty if block
                        }
                    }
                }
                catch (FileNotFoundException ee) {
                    this.scanMCITrxList(String.valueOf(path) + "/" + files[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

