/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.TellerTransactionBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.popup.actions.IDEPluginAction;
import com.ecc.ide.popup.actions.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IObjectActionDelegate;

public class BuildAllTellerTrxAction
extends IDEPluginAction
implements IObjectActionDelegate,
BuildProblemReporter {
    private Vector filesToBuild = new Vector();

    public void initPath() {
        String webContentPath = this.prjSettings.getWebContentPath();
        String settingsRootPath = this.prjSettings.getSettingsRootPath();
        this.relativePath = "/" + webContentPath;
        this.settingPath = "/" + webContentPath + "/tellerClient/operations";
        this.targetPath = this.project.getLocation() + this.settingPath;
    }

    public void run(IProgressMonitor monitor) {
        this.reportProblem(0, Messages.getString("BuildAllTellerTrxAction._u91CD_u5EFA_u5168_u90E8Teller_u4EA4_u6613..._1"), "", "", null);
        if (this.targetPath == null || this.targetPath.length() == 0) {
            return;
        }
        this.filesToBuild.removeAllElements();
        String path = String.valueOf(this.project.getLocation().toString()) + "/designFiles/tellerTrxs";
        this.scanTellerTrxList(path);
        this.fileName = new String[this.filesToBuild.size()];
        this.relativeFilePath = new String[this.filesToBuild.size()];
        int i = 0;
        while (i < this.fileName.length) {
            this.fileName[i] = (String)this.filesToBuild.elementAt(i);
            int p = this.fileName[i].lastIndexOf("/");
            if (p != -1) {
                this.relativeFilePath[i] = this.fileName[i].substring(p);
            }
            ++i;
        }
        TellerTransactionBuilder builder = new TellerTransactionBuilder();
        builder.setProblemReporter(this);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        try {
            builder.setDataDictionaryEditorProfile(IDEProfile.getEditorProfile(this.project, 1));
            builder.setFlowEditorProfile(IDEProfile.getEditorProfile(this.project, 9));
            builder.setServiceEditorProfile(IDEProfile.getEditorProfile(this.project, 14));
            builder.setDataDictionary(IDEContent.getSettingNode(this.project, 0));
            builder.setFlow(IDEContent.getSettingNode(this.project, 10));
            builder.setFmtHeader(IDEContent.getSettingNode(this.project, 17));
            builder.setPackageType(IDEContent.getSettingNode(this.project, 14));
            builder.setStateMachineEditorProfile(IDEProfile.getEditorProfile(this.project, 23));
            builder.setStateEditorProfile(IDEProfile.getEditorProfile(this.project, 9));
            builder.setCommonStates(IDEContent.getSettingNode(this.project, 24));
            builder.setCommonStateMachine(IDEContent.getSettingNode(this.project, 22));
            builder.setBuildStateMachineAsOperation(ECCIDEPlugin.getDefault().getPreferenceStore().getBoolean("buildStateMachineAsOperation"));
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
        monitor.beginTask("Build Teller Transaction runtime !", this.fileName.length);
        int i2 = 0;
        while (i2 < this.fileName.length) {
            monitor.worked(1);
            monitor.subTask(String.valueOf(Messages.getString("BuildTellerTrxAction.Build_Teller_Transaction__3")) + this.relativeFilePath[i2]);
            builder.setOutputPath(this.targetPath);
            builder.buildTellerTransaction(this.fileName[i2]);
            builder.setOutputPath(this.project.getLocation() + "/WebContent/tellerClient/views");
            builder.buildTellerView(this.fileName[i2]);
            builder.setOutputPath(this.project.getLocation() + "/WebContent/tellerClient/receipts");
            builder.buildTellerReceipt(this.fileName[i2]);
            XMLNode taskNode = builder.loadXMLContent(this.fileName[i2]);
            this.addToTaskInfo(taskNode);
            this.reportProblem(0, Messages.getString("BuildTellerTrxAction.Build_ECC_Teller_Transaction_finished_!_3"), this.relativeFilePath[i2], "", null);
            ++i2;
        }
        try {
            this.project.getFolder(String.valueOf(this.relativePath) + "/tellerClient/operations").refreshLocal(2, null);
            this.project.getFolder(String.valueOf(this.relativePath) + "/tellerClient/views").refreshLocal(2, null);
            this.project.getFolder(String.valueOf(this.relativePath) + "/tellerClient/receipts").refreshLocal(2, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.reportProblem(0, Messages.getString("BuildAllTellerTrxAction._u91CD_u5EFA_u5168_u90E8Teller_u4EA4_u6613_u5B8C_u6210_4"), "", "", null);
    }

    private void scanTellerTrxList(String path) {
        try {
            File TrxPathFolder = new File(path);
            String[] files = TrxPathFolder.list();
            int i = 0;
            while (i < files.length) {
                try {
                    if (files[i].endsWith(".ttx")) {
                        this.filesToBuild.add(String.valueOf(path) + "/" + files[i]);
                    } else {
                        FileInputStream in = new FileInputStream(String.valueOf(path) + "/" + files[i]);
                        if (in != null) {
                            // empty if block
                        }
                    }
                }
                catch (FileNotFoundException ee) {
                    this.scanTellerTrxList(String.valueOf(path) + "/" + files[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addToTaskInfo(XMLNode TellerTrxNode) {
        try {
            XMLNode linkTasks;
            String classify = null;
            classify = TellerTrxNode.getAttrValue("classify");
            String trxCode = TellerTrxNode.getAttrValue("trxCode");
            if (TellerTrxNode == null) {
                return;
            }
            XMLNode taskInfo = new XMLNode();
            taskInfo.setNodeName("TaskInfo");
            taskInfo.setAttrValue("transactionCode", trxCode);
            taskInfo.setAttrValue("name", TellerTrxNode.getAttrValue("trxName"));
            taskInfo.setAttrValue("longDescription", TellerTrxNode.getAttrValue("trxName"));
            taskInfo.setAttrValue("operationName", String.valueOf(trxCode) + "CltOp");
            XMLNode viewsNode = TellerTrxNode.getChild("views");
            int i = 0;
            while (viewsNode != null && i < viewsNode.getChilds().size()) {
                taskInfo.setAttrValue("isXMLView", "true");
                XMLNode viewNode = (XMLNode)viewsNode.getChilds().elementAt(i);
                String viewType = viewNode.getAttrValue("viewType");
                if (viewType != null) {
                    int inIdx = viewType.indexOf("Input");
                    int inOutIdx = viewType.indexOf("In/Out");
                    int outIdx = viewType.indexOf("Output");
                    if (inIdx != -1 || inOutIdx != -1) {
                        if (classify != null) {
                            taskInfo.setAttrValue("inputViewName", String.valueOf(classify) + "/" + trxCode + viewNode.getAttrValue("id"));
                        } else {
                            taskInfo.setAttrValue("inputViewName", String.valueOf(trxCode) + viewNode.getAttrValue("id"));
                        }
                    }
                    if (outIdx != -1) {
                        if (classify != null) {
                            taskInfo.setAttrValue("outputViewName", String.valueOf(classify) + "/" + trxCode + viewNode.getAttrValue("id"));
                        } else {
                            taskInfo.setAttrValue("outputViewName", String.valueOf(trxCode) + viewNode.getAttrValue("id"));
                        }
                    }
                }
                ++i;
            }
            XMLNode taskPropertys = TellerTrxNode.getChild("TaskProperty");
            if (taskPropertys != null) {
                Enumeration keys = taskPropertys.getAttrs().keys();
                while (keys.hasMoreElements()) {
                    XMLNode taskProperty = new XMLNode();
                    taskProperty.setNodeName("TaskProperty");
                    String key = (String)keys.nextElement();
                    taskProperty.setAttrValue("id", key);
                    taskProperty.setAttrValue("value", taskPropertys.getAttrValue(key));
                    taskInfo.add(taskProperty);
                }
            }
            if ((linkTasks = TellerTrxNode.getChild("trxLinks")) != null && linkTasks.getChilds() != null) {
                int i2 = 0;
                while (i2 < linkTasks.getChilds().size()) {
                    XMLNode linkTask = (XMLNode)linkTasks.getChilds().elementAt(i2);
                    XMLNode taskLink = new XMLNode();
                    taskInfo.add(taskLink);
                    taskLink.setNodeName("LinkTask");
                    Enumeration keys = linkTask.getAttrs().keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        if (key.equals("id")) continue;
                        taskLink.setAttrValue(key, linkTask.getAttrValue(key));
                    }
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            this.reportProblem(2, String.valueOf(Messages.getString("BuildTellerTrxAction.Failed_to_add_this_teller_trx_to_taskInfo_!_Exception___39")) + e, "", "", e);
        }
    }
}

