/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.builder.HTMLTransactionBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.popup.actions.IDEPluginAction;
import com.ecc.ide.popup.actions.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IObjectActionDelegate;

public class BuildAllWMLTrxAction
extends IDEPluginAction
implements IObjectActionDelegate,
BuildProblemReporter {
    private Vector filesToBuild = new Vector();

    public void initPath() {
        String webContentPath = this.prjSettings.getWebContentPath();
        String settingsRootPath = this.prjSettings.getSettingsRootPath();
        String wmlLogicPath = this.prjSettings.getWmlLogicPath();
        this.relativePath = "/" + webContentPath;
        this.settingPath = "/" + webContentPath + "/" + settingsRootPath + "/" + wmlLogicPath;
        this.targetPath = this.project.getLocation() + this.settingPath;
    }

    public void run(IProgressMonitor monitor) {
        this.reportProblem(0, Messages.getString("BuildAllHtmlTrxAction._u91CD_u5EFA_u5168_u90E8Html_u4EA4_u6613..._1"), "", "", null);
        if (this.targetPath == null || this.targetPath.length() == 0) {
            return;
        }
        this.filesToBuild.removeAllElements();
        String path = String.valueOf(this.project.getLocation().toString()) + "/designFiles/wmlTrxs";
        this.scanHtmlTrxList(path);
        this.fileName = new String[this.filesToBuild.size()];
        this.relativeFilePath = new String[this.filesToBuild.size()];
        int i = 0;
        while (i < this.fileName.length) {
            this.fileName[i] = (String)this.filesToBuild.elementAt(i);
            int p = this.fileName[i].lastIndexOf("/");
            if (p != -1) {
                this.relativeFilePath[i] = this.fileName[i].substring(p);
            }
            ++i;
        }
        HTMLTransactionBuilder builder = new HTMLTransactionBuilder();
        builder.setTargetPath(this.targetPath);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        builder.setJspPath(this.prjSettings.getWmlJspPath());
        try {
            XMLNode jsFunctionNode = IDEContent.getSettingNode(this.project, 20);
            builder.setJSFunctionNode(jsFunctionNode);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
        builder.setProblemReporter(this);
        int i2 = 0;
        while (i2 < this.fileName.length) {
            monitor.subTask(String.valueOf(Messages.getString("BuildHtmlTrxAction.Build_HTML_Transaction__3")) + this.relativeFilePath[i2]);
            monitor.worked(1);
            builder.buildHtmlTransaction(this.fileName[i2]);
            this.reportProblem(0, Messages.getString("BuildHtmlTrxAction.Build_ECC_Html_Trx_finished_!_3"), this.relativeFilePath[i2], "", null);
            ++i2;
        }
        try {
            this.project.getFolder(this.settingPath).refreshLocal(2, null);
            this.project.getFolder("WebContent").refreshLocal(2, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.reportProblem(0, Messages.getString("BuildAllHtmlTrxAction._u91CD_u5EFA_u5168_u90E8Html_u4EA4_u6613_u5B8C_u6210_4"), "", "", null);
    }

    private void scanHtmlTrxList(String path) {
        try {
            File TrxPathFolder = new File(path);
            String[] files = TrxPathFolder.list();
            int i = 0;
            while (i < files.length) {
                try {
                    if (files[i].endsWith(".wtx")) {
                        this.filesToBuild.add(String.valueOf(path) + "/" + files[i]);
                    } else {
                        FileInputStream in = new FileInputStream(String.valueOf(path) + "/" + files[i]);
                        if (in != null) {
                            // empty if block
                        }
                    }
                }
                catch (FileNotFoundException ee) {
                    this.scanHtmlTrxList(String.valueOf(path) + "/" + files[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

