/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.builder.BizGrpBuilder;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.popup.actions.IDEPluginAction;
import com.ecc.ide.popup.actions.Messages;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IObjectActionDelegate;

public class BuildMCIProjectAction
extends IDEPluginAction
implements IObjectActionDelegate,
BuildProblemReporter {
    public void initPath() {
        String webContentPath = this.prjSettings.getWebContentPath();
        String settingsRootPath = this.prjSettings.getSettingsRootPath();
        this.relativePath = "/" + webContentPath;
        this.settingPath = "/" + webContentPath + "/" + settingsRootPath;
        this.targetPath = this.project.getLocation() + this.settingPath;
    }

    public void run(IProgressMonitor monitor) {
        this.reportProblem(0, Messages.getString("BuildMCIProjectAction.build_MCI_Project......_1"), "", "", null);
        if (this.targetPath == null || this.targetPath.length() == 0) {
            return;
        }
        BizGrpBuilder builder = new BizGrpBuilder();
        builder.setOutputPath(this.targetPath);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        builder.setProblemReporter(this);
        builder.setProgressMonitor(monitor);
        monitor.beginTask(Messages.getString("BuildMCIProjectAction.Build_MCI_Project_runtime__!_3"), 10);
        monitor.setTaskName(Messages.getString("BuildMCIProjectAction.Build_MCI_Project_runtime_4"));
        builder.buildProject();
        try {
            XMLNode settingsNode = IDEContent.getSettingNode(this.project, 1);
            EditorProfile serviceProfile = IDEProfile.getEditorProfile(this.project, 13);
            this.setServiceSettings(settingsNode, serviceProfile);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
        try {
            this.project.getFolder("WebContent/WEB-INF/server").refreshLocal(1, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.reportProblem(0, Messages.getString("BuildMCIProjectAction.build_MCI_Project_finished._4"), "", "", null);
    }

    private void setServiceSettings(XMLNode settingsNode, EditorProfile serviceProfile) {
        XMLNode node = settingsNode.findChildNode("kColl", "settings");
        XMLNode tagsNode = node.findChildNode("kColl", "tags");
        XMLNode svcNode = tagsNode.findChildNode("kColl", "services");
        Vector catalogs = serviceProfile.getCagalogs();
        if (catalogs == null) {
            return;
        }
        if (svcNode != null) {
            tagsNode.remove(svcNode);
        } else {
            svcNode = new XMLNode();
            svcNode.setNodeName("kColl");
            svcNode.setAttrValue("id", "services");
        }
        try {
            int i = 0;
            while (i < catalogs.size()) {
                ElementCatalog catalog = (ElementCatalog)catalogs.elementAt(i);
                int k = 0;
                while (k < catalog.getElements().size()) {
                    Element element = (Element)catalog.getElements().elementAt(k);
                    if (element.getImplClass() != null) {
                        String elementName = element.getElementName();
                        XMLNode elementSettingNode = svcNode.findChildNode(elementName);
                        if (elementSettingNode == null) {
                            elementSettingNode = new XMLNode();
                            elementSettingNode.setNodeName("field");
                            elementSettingNode.setAttrValue("id", elementName);
                            svcNode.add(elementSettingNode);
                        }
                        elementSettingNode.setAttrValue("value", element.getImplClass());
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.MESSAGE, "Failed to set services Settings: " + e, "", "", e);
            e.printStackTrace();
        }
        tagsNode.add(svcNode);
    }
}

