/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.HTMLTransactionBuilder;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.popup.actions.IDEPluginAction;
import com.ecc.ide.popup.actions.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BuildWMLTrxAction
extends IDEPluginAction
implements IObjectActionDelegate {
    public void initPath() {
        String webContentPath = this.prjSettings.getWebContentPath();
        String settingsRootPath = this.prjSettings.getSettingsRootPath();
        String wmlLogicPath = this.prjSettings.getWmlLogicPath();
        this.relativePath = "/" + webContentPath;
        this.settingPath = "/" + webContentPath + "/" + settingsRootPath + "/" + wmlLogicPath;
        this.targetPath = this.project.getLocation() + this.settingPath;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IProgressMonitor monitor) {
        if (this.project == null) {
            this.reportProblem(2, Messages.getString("BuildHtmlTrxAction.Build_ECC_Html_Transaction_error_1"), "", "", null);
            return;
        }
        HTMLTransactionBuilder builder = new HTMLTransactionBuilder();
        builder.setTargetPath(this.targetPath);
        if (this.prjSettings.getSetXMLEncodeManually()) {
            builder.setXMLEncoding(this.prjSettings.getXMLEncoding());
        }
        builder.setJspPath(this.prjSettings.getWmlJspPath());
        try {
            XMLNode jsFunctionNode = IDEContent.getSettingNode(this.project, 20);
            builder.setJSFunctionNode(jsFunctionNode);
        }
        catch (Exception e) {
            this.reportProblem(BuildProblemObject.ERROR, "Exception: " + e.getMessage(), "", "", e);
        }
        builder.setProblemReporter(this);
        builder.setProgressMonitor(monitor);
        int i = 0;
        while (i < this.fileName.length) {
            monitor.beginTask(String.valueOf(Messages.getString("BuildHtmlTrxAction.Build_HTML_Transaction__3")) + this.relativeFilePath[i], 10);
            builder.buildHtmlTransaction(this.fileName[i]);
            this.reportProblem(0, Messages.getString("BuildHtmlTrxAction.Build_ECC_Html_Trx_finished_!_3"), this.relativeFilePath[i], "", null);
            ++i;
        }
        try {
            this.project.getFolder(this.settingPath).refreshLocal(2, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

