/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.popup.actions.GenProfilePage;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class EMPGenProfileWizard
extends Wizard {
    ICompilationUnit javaFile;
    GenProfilePage page;

    public EMPGenProfileWizard(ICompilationUnit javaFile) {
        this.javaFile = javaFile;
    }

    public void addPages() {
        try {
            this.page = new GenProfilePage(this.javaFile);
            this.addPage((IWizardPage)this.page);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return null;
    }

    public boolean performFinish() {
        String actionId = this.page.getActionId();
        String actionName = this.page.getActionName();
        String[] attrs = this.page.getAttrs();
        String[] prjs = this.page.getSelectProjects();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        int i = 0;
        while (i < prjs.length) {
            try {
                IProject prj = workspace.getRoot().getProject(prjs[i]);
                EditorProfile profile = IDEProfile.getEditorProfile(prj, 5);
                if (profile.getElement(actionId) != null) {
                    MessageDialog.openInformation(null, (String)"\u81ea\u52a8\u751f\u6210Profile", (String)("ID\u4e3a\uff1a" + actionId + "\u7684Action\u5728" + prj.getName() + "\u9879\u76ee\u4e2d\u5df2\u7ecf\u5b9a\u4e49"));
                } else {
                    String prjName = this.javaFile.getResource().getProject().getName();
                    ElementCatalog catalog = profile.getElementCatalog(prjName);
                    if (catalog == null) {
                        catalog = new ElementCatalog();
                        catalog.setCatalogName(prjName);
                        profile.addElementCatalog(catalog);
                    }
                    Element element = new Element();
                    element.setElementName(actionId);
                    element.setLabel(actionName);
                    element.setImplClass(this.javaFile.getTypes()[0].getFullyQualifiedName());
                    element.setWrapperClassType("com.ecc.ide.editor.visualflow.ActionElementWrapper");
                    element.setVisualType("Label");
                    element.setIconName("/images/newElement.gif");
                    int w = 0;
                    while (w < attrs.length) {
                        String str = attrs[w];
                        ElementAttribute attr = new ElementAttribute();
                        attr.setAttrID(str);
                        attr.setAttrName(str);
                        element.addAttribute(attr);
                        ++w;
                    }
                    catalog.addElement(element);
                    ElementCatalog sFlowCata = profile.getElementCatalog("rootCatalog");
                    Element flow = sFlowCata.getElement("flow");
                    Vector schilds = flow.getAllowedChilds().getObjects();
                    boolean exsit = false;
                    int j = 0;
                    while (j < schilds.size()) {
                        ElementChild schild = (ElementChild)schilds.elementAt(j);
                        String sname = schild.getChildElementId();
                        if (sname.equals(actionId)) {
                            exsit = true;
                            break;
                        }
                        ++j;
                    }
                    if (!exsit) {
                        ElementChild child = new ElementChild();
                        child.setChildElementId(actionId);
                        child.setAllowCount("*");
                        flow.addChild(child);
                    }
                    IDEProfile.saveEditorProfile(prj, 5);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return true;
    }

    public boolean canFinish() {
        return true;
    }
}

