/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.module.EMPRefWizard;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.popup.actions.IDEPluginAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EMPRefAction
extends IDEPluginAction {
    public void selectionChanged(IAction action, ISelection selection) {
        IProject prj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel == null || ssel.size() != 1) {
            action.setEnabled(false);
            return;
        }
        Object obj = ssel.getFirstElement();
        if (obj instanceof IProject) {
            this.project = prj = (IProject)obj;
            this.targetPath = this.project.getLocation() + this.relativePath;
        } else if (obj instanceof IJavaProject) {
            prj = (IJavaProject)obj;
            this.project = prj.getProject();
            this.targetPath = this.project.getLocation() + this.relativePath;
        }
        if (this.project == null) {
            action.setEnabled(false);
            return;
        }
        IFile file = this.project.getFile("ECCMCIProject.xml");
        if (file != null && file.exists()) {
            action.setEnabled(false);
        } else {
            action.setEnabled(true);
        }
    }

    public void run(IAction action) {
        IDEProjectSettings settings = IDEContent.getPRJSettings(this.project);
        if (settings == null) {
            settings = IDEContent.getDefaultPRJSettings(this.project);
        }
        EMPRefWizard wizard = new EMPRefWizard(this.project, settings);
        try {
            Shell shell = this.getWorkbenchWindow().getShell();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            int ret = dialog.open();
            if (ret != 0) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IDEContent.saveSettingNode(this.project, 35, settings.getSettingsNode());
        ModuleUtility.addModuleToPrj(wizard.getSelectedModules(), this.project);
        XMLNode modules = wizard.getSelectedModules();
        int i = 0;
        while (i < modules.getChilds().size()) {
            XMLNode module = (XMLNode)modules.getChilds().elementAt(i);
            if ("module".equals(module.getNodeName())) {
                XMLNode aNode = new XMLNode("module");
                aNode.setAttrValue("id", module.getAttrValue("id"));
                settings.getModules().add(aNode);
            }
            ++i;
        }
        try {
            IFile file;
            IFolder folder = this.project.getFolder("designFiles");
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            if (!(folder = this.project.getFolder("designFiles/commons")).exists()) {
                folder.create(true, true, null);
            }
            if (!(file = this.project.getFile("designFiles/commons/EMPPrj.xml")).exists()) {
                file.create(null, true, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IDEContent.saveSettingNode(this.project, 35, settings.getSettingsNode());
        try {
            this.project.getFolder("src").refreshLocal(2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.project.refreshLocal(2, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run(IProgressMonitor monitor) {
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench iworkbench = this.getWorkbench();
        IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
        if (iworkbenchwindow == null) {
            IWorkbenchWindow[] aiworkbenchwindow = iworkbench.getWorkbenchWindows();
            int i = 0;
            while (i < aiworkbenchwindow.length) {
                if (!aiworkbenchwindow[i].getShell().isDisposed()) {
                    iworkbenchwindow = aiworkbenchwindow[i];
                    break;
                }
                ++i;
            }
        }
        return iworkbenchwindow;
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public void initPath() {
    }
}

