/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class GenProfilePage
extends WizardPage {
    private Text actionNameText;
    private Text actionIdText;
    private List attrList;
    private List selectPrjs;
    private List prjs;
    private ICompilationUnit javaFile;

    public GenProfilePage(ICompilationUnit javaFile) {
        super("wizardPage");
        this.setTitle("EMP Wizard");
        this.setDescription("\u81ea\u52a8\u4ea7\u751f\u4ea4\u6613\u6b65\u9aa4\u4ee3\u7801\u7684Profile");
        this.javaFile = javaFile;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.setControl((Control)container);
        Composite composite = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        Group actionProfileGroup = new Group(composite, 0);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 3;
        actionProfileGroup.setLayout((Layout)gridLayout_2);
        actionProfileGroup.setText("Action Profile");
        actionProfileGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite composite_1 = new Composite((Composite)actionProfileGroup, 0);
        composite_1.setLayout((Layout)new GridLayout());
        Label actionIdLabel = new Label(composite_1, 0);
        actionIdLabel.setText("Action Id");
        this.actionIdText = new Text(composite_1, 2048);
        this.actionIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label_1 = new Label(composite_1, 0);
        label_1.setText("Action \u540d\u79f0");
        this.actionNameText = new Text(composite_1, 2048);
        this.actionNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite composite_3 = new Composite((Composite)actionProfileGroup, 0);
        composite_3.setLayout((Layout)new GridLayout());
        Button addToFlowBtn = new Button(composite_3, 32);
        addToFlowBtn.setText("\u81ea\u52a8\u6dfb\u52a0\u5230\u6839\u5143\u7d20");
        addToFlowBtn.setSelection(true);
        Composite composite_2 = new Composite((Composite)actionProfileGroup, 0);
        composite_2.setLayoutData((Object)new GridData(4, 4, true, true));
        composite_2.setLayout((Layout)new GridLayout());
        Label label_2 = new Label(composite_2, 0);
        label_2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label_2.setText("\u5c5e\u6027\u5217\u8868");
        this.attrList = new List(composite_2, 2048);
        this.attrList.setLayoutData((Object)new GridData(4, 4, true, true));
        Group projectsGroup = new Group(composite, 0);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        projectsGroup.setLayout((Layout)gridLayout_1);
        projectsGroup.setText("Projects");
        projectsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.prjs = new List((Composite)projectsGroup, 2048);
        this.prjs.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        Button addPrjBtn = new Button((Composite)projectsGroup, 0);
        addPrjBtn.setText(">>");
        addPrjBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String prjName = GenProfilePage.this.prjs.getSelection()[0];
                GenProfilePage.this.selectPrjs.add(prjName);
                GenProfilePage.this.selectPrjs.setSelection(new String[]{prjName});
                GenProfilePage.this.prjs.remove(prjName);
            }
        });
        this.selectPrjs = new List((Composite)projectsGroup, 2048);
        this.selectPrjs.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        Button removePrjBtn = new Button((Composite)projectsGroup, 0);
        removePrjBtn.setText("<<");
        removePrjBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String prjName = GenProfilePage.this.selectPrjs.getSelection()[0];
                GenProfilePage.this.prjs.add(prjName);
                GenProfilePage.this.prjs.setSelection(new String[]{prjName});
                GenProfilePage.this.selectPrjs.remove(prjName);
            }
        });
        this.init();
    }

    private void init() {
        try {
            IType type = this.javaFile.getAllTypes()[0];
            String className = type.getElementName();
            this.actionIdText.setText(className);
            this.actionNameText.setText(className);
            this.attrList.add("label");
            IMethod[] methods = type.getMethods();
            Vector attrs = new Vector();
            int i = 0;
            while (i < methods.length) {
                String methodName = methods[i].getElementName();
                if (methodName.startsWith("set")) {
                    String attrName = methodName.substring(3, methodName.length());
                    String firstChar = attrName.substring(0, 1);
                    if (attrName.length() > 1) {
                        String secondChar = attrName.substring(1, 2);
                        if (!secondChar.toUpperCase().equals(secondChar)) {
                            firstChar = firstChar.toLowerCase();
                        }
                    } else {
                        firstChar = firstChar.toLowerCase();
                    }
                    attrName = String.valueOf(firstChar) + attrName.substring(1, attrName.length());
                    this.attrList.add(attrName);
                }
                ++i;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] projects = workspace.getRoot().getProjects();
            Vector result = new Vector();
            int i2 = 0;
            while (i2 < projects.length) {
                IProject prj = projects[i2];
                IFolder folder = prj.getFolder("designFiles");
                if (folder != null && folder.exists()) {
                    this.prjs.add(prj.getName());
                }
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getSelectProjects() {
        return this.selectPrjs.getItems();
    }

    public String[] getAttrs() {
        return this.attrList.getItems();
    }

    public String getActionName() {
        return this.actionNameText.getText();
    }

    public String getActionId() {
        return this.actionIdText.getText();
    }
}

