/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.builder.BuildProblemObject;
import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.plugin.views.BuilderProblemView;
import com.ecc.ide.popup.actions.Messages;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class IDEPluginAction
implements IObjectActionDelegate,
BuildProblemReporter,
IRunnableWithProgress,
IWorkbenchWindowActionDelegate {
    protected IDEProjectSettings prjSettings;
    protected IProject project;
    protected String[] fileName;
    protected String[] relativeFilePath;
    protected String relativePath;
    protected String settingPath;
    protected String targetPath;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public abstract void initPath();

    public void run(IAction action) {
        if (this.project == null) {
            this.reportProblem(2, Messages.getString("BuildMCITrxDesignDocumentAction.Build_ECC_MCI_Transaction_error_1"), "", "", null);
            return;
        }
        try {
            XMLNode prjSettingsNode = IDEContent.getSettingNode(this.project, 35);
            this.prjSettings = new IDEProjectSettings(prjSettingsNode);
            this.initPath();
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(new Shell(Display.getCurrent()));
            monitorDialog.run(true, false, (IRunnableWithProgress)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            if (ssel == null || ssel.size() == 0) {
                return;
            }
            Object[] objs = ssel.toArray();
            this.relativeFilePath = new String[objs.length];
            this.fileName = new String[objs.length];
            int i = 0;
            while (i < objs.length) {
                IProject prj;
                Object obj = objs[i];
                if (obj instanceof File) {
                    File file = (File)obj;
                    IProject prj2 = file.getProject();
                    if (this.project == null) {
                        this.project = prj2;
                    }
                    if (this.project != prj2) {
                        this.project = null;
                        Shell shell = new Shell();
                        MessageDialog.openError((Shell)shell, (String)"e-Channels IDE", (String)Messages.getString("IDEPluginAction.You_can__t_select_multi_file_from_different_project_to_build_!_3"));
                        return;
                    }
                    this.relativeFilePath[i] = file.getProjectRelativePath().toString();
                    this.fileName[i] = file.getLocation().toOSString();
                } else if (obj instanceof IProject) {
                    this.project = prj = (IProject)obj;
                    this.targetPath = this.project.getLocation() + this.relativePath;
                } else if (obj instanceof IJavaProject) {
                    prj = (IJavaProject)obj;
                    this.project = prj.getProject();
                }
                ++i;
            }
            if (this.project == null || action == null) {
                return;
            }
            IFile file = this.project.getFile("ECCMCIProject.xml");
            if (file != null && file.exists()) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reportProblem(int type, String msg, String location, String fileName, Exception e) {
        if (BuilderProblemView.display == null) {
            return;
        }
        String detailMsg = msg;
        if (e != null) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            detailMsg = new String(bo.toByteArray());
        }
        final BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), location, fileName);
        BuilderProblemView.display.asyncExec(new Runnable(){

            public void run() {
                ECCIDEPlugin.getDefault().addProblemElement(obj);
            }
        });
    }

    public void reportProblem(int type, String msg, String detail) {
        String detailMsg = msg;
        if (detail != null) {
            detailMsg = detail;
        }
        final BuildProblemObject obj = new BuildProblemObject(type, msg, detailMsg, this.project.getName(), "", "");
        BuilderProblemView.display.asyncExec(new Runnable(){

            public void run() {
                ECCIDEPlugin.getDefault().addProblemElement(obj);
            }
        });
    }

    public void init(IWorkbenchWindow iworkbenchwindow) {
        System.out.println("init:" + iworkbenchwindow);
    }

    public void dispose() {
    }

    public abstract void run(IProgressMonitor var1);
}

