/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.popup.actions;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.plugin.Messages;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.popup.actions.IDEPluginAction;
import com.ecc.ide.reverse.engin.ReverseEngin;
import com.ecc.ide.reverse.engin.ReverseEnginWizard;
import java.io.FileWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportSettingFilesAction
extends IDEPluginAction {
    ReverseEngin engin = new ReverseEngin();

    public void initPath() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IProject prj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel == null || ssel.size() != 1) {
            action.setEnabled(false);
            return;
        }
        Object obj = ssel.getFirstElement();
        if (obj instanceof IProject) {
            this.project = prj = (IProject)obj;
        } else if (obj instanceof IJavaProject) {
            prj = (IJavaProject)obj;
            this.project = prj.getProject();
        }
        if (action == null) {
            return;
        }
        if (this.project == null) {
            action.setEnabled(false);
            return;
        }
        IFile file = this.project.getFile("ECCMCIProject.xml");
        if (file != null && file.exists()) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    public void run(IAction action) {
        if (this.project == null) {
            this.reportProblem(2, Messages.getString("BuildMCITrxDesignDocumentAction.Build_ECC_MCI_Transaction_error_1"), "", "", null);
            return;
        }
        try {
            ReverseEnginWizard wizard = new ReverseEnginWizard();
            Shell shell = this.getWorkbenchWindow().getShell();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            int ret = dialog.open();
            if (ret == 0) {
                this.engin.settingsFile = wizard.getSettingsFileName();
                this.engin.outputPath = this.project.getLocation().toString();
                XMLNode prjSettingsNode = IDEContent.getSettingNode(this.project, 35);
                this.prjSettings = new IDEProjectSettings(prjSettingsNode);
                String webContentPath = this.prjSettings.getWebContentPath();
                String settingsRootPath = this.prjSettings.getSettingsRootPath();
                this.engin.settingsRootPath = String.valueOf(webContentPath) + "/" + settingsRootPath;
                this.engin.rootCtxName = wizard.getRootCtxName();
                this.engin.converterDefs = wizard.getFormatSettings();
                this.engin.groupDataByOp = wizard.getGroupDataByOp();
                try {
                    ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(new Shell(Display.getCurrent()));
                    monitorDialog.run(true, false, (IRunnableWithProgress)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(IProgressMonitor monitor) {
        this.reportProblem(0, "Import settings...", "", "", null);
        this.engin.monitor = monitor;
        this.engin.reporter = this;
        this.engin.run();
        try {
            String logFileName = this.project.getLocation() + "/designFiles/IDEImportLog.txt";
            FileWriter fw = new FileWriter(logFileName);
            fw.write(this.engin.getMessages());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.project.getFolder("WebContent/WEB-INF/server").refreshLocal(2, monitor);
            this.project.getFolder("designFiles").refreshLocal(2, monitor);
            this.project.getFolder("profiles").refreshLocal(2, monitor);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        ECCIDEPlugin.getDefault().refreshSettings(this.project);
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        IWorkbench iworkbench = this.getWorkbench();
        IWorkbenchWindow iworkbenchwindow = iworkbench.getActiveWorkbenchWindow();
        if (iworkbenchwindow == null) {
            IWorkbenchWindow[] aiworkbenchwindow = iworkbench.getWorkbenchWindows();
            int i = 0;
            while (i < aiworkbenchwindow.length) {
                if (!aiworkbenchwindow[i].getShell().isDisposed()) {
                    iworkbenchwindow = aiworkbenchwindow[i];
                    break;
                }
                ++i;
            }
        }
        return iworkbenchwindow;
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }
}

