/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.preferences;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.plugin.ECCIDEPlugin;
import com.ecc.ide.preferences.Messages;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ECCIDEPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String AUTO_BUILD = "autoBuild";
    public static final String BUILD_STATEMACHINE_AS_OPERATION = "buildStateMachineAsOperation";
    public static final String SET_XML_ENCODING_MANUALLY = "setXMLEncodingNamually";
    public static final String XML_ENCODING = "xmlEncoding";
    public static final String usingIDELayout = "usingIDELayout";
    public static final String contentDIVID = "contentDIVID";
    public static final String BUILD_JSP_WITH_TAGLIB = "buildJspWithTaglib";
    public static final String TAG_PREFIX = "tagPrefix";
    private BooleanFieldEditor buildAutoField;
    private StringFieldEditor tagPrefix;

    public ECCIDEPreferencePage() {
        super(1);
        this.setDescription(Messages.getString("ECCIDEPreferencePage.e-Channels_MCI_IDE_2004_Preferences_2"));
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        Preferences store = ECCIDEPlugin.getDefault().getPluginPreferences();
        IPreferenceStore pStore = ECCIDEPlugin.getDefault().getPreferenceStore();
        if (pStore == null) {
            return;
        }
        this.setPreferenceStore(pStore);
        pStore.setValue(AUTO_BUILD, store.getBoolean(AUTO_BUILD));
        pStore.setDefault(AUTO_BUILD, true);
        pStore.setValue(BUILD_STATEMACHINE_AS_OPERATION, store.getBoolean(BUILD_STATEMACHINE_AS_OPERATION));
        pStore.setDefault(BUILD_STATEMACHINE_AS_OPERATION, false);
        pStore.setValue(SET_XML_ENCODING_MANUALLY, store.getBoolean(SET_XML_ENCODING_MANUALLY));
        pStore.setDefault(SET_XML_ENCODING_MANUALLY, true);
        String encoding = "GB2312";
        pStore.setValue(XML_ENCODING, store.getBoolean(XML_ENCODING));
        pStore.setDefault(XML_ENCODING, encoding);
        pStore.setValue(usingIDELayout, store.getBoolean(usingIDELayout));
        pStore.setDefault(usingIDELayout, false);
        pStore.setValue(contentDIVID, store.getBoolean(contentDIVID));
        pStore.setDefault(contentDIVID, "content");
        pStore.setValue(BUILD_JSP_WITH_TAGLIB, store.getBoolean(BUILD_JSP_WITH_TAGLIB));
        pStore.setDefault(BUILD_JSP_WITH_TAGLIB, false);
        pStore.setValue(TAG_PREFIX, store.getBoolean(TAG_PREFIX));
        pStore.setDefault(TAG_PREFIX, "ctp:");
        pStore.setDefault("unused", "unused!");
    }

    public void createFieldEditors() {
        this.buildAutoField = new BooleanFieldEditor(AUTO_BUILD, Messages.getString("ECCIDEPreferencePage.Build_Automatically_3"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.buildAutoField);
        this.tagPrefix = new StringFieldEditor(TAG_PREFIX, Messages.getString("JSP_Tag_lib_prefix"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.tagPrefix);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.tagPrefix.getStringValue().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"error", (String)"You have select build jsp with taglib, but not set the taglib prefix!");
            return false;
        }
        this.saveSettings();
        return super.performOk();
    }

    private void saveSettings() {
        Preferences store = ECCIDEPlugin.getDefault().getPluginPreferences();
        store.setValue(AUTO_BUILD, this.buildAutoField.getBooleanValue());
        store.setValue(TAG_PREFIX, this.tagPrefix.getStringValue());
        IDEConstance.tagPrefix = this.tagPrefix.getStringValue();
        ECCIDEPlugin.getDefault().savePluginPreferences();
    }

    protected void checkState() {
        if (this.tagPrefix.getStringValue().length() == 0) {
            this.setErrorMessage("Please input the tag prefix value!");
            this.setValid(false);
            return;
        }
        this.setValid(true);
    }

    public void performApply() {
        this.performOk();
    }
}

