/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.refactor;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.module.ModuleUtility;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.jdt.ui.JavadocContentAccess;

public class IDEClassRefactor {
    private static Element createElement(String elementName, IType type, Element defaultElement) {
        if (defaultElement == null) {
            return null;
        }
        try {
            Element element = new Element();
            if (elementName == null || elementName.length() == 0) {
                elementName = type.getElementName();
            }
            element.setElementName(elementName);
            element.setImplClass(type.getFullyQualifiedName());
            HashMap javaDocMap = IDEClassRefactor.getJavaDoc((IMember)type);
            try {
                String name = (String)javaDocMap.get("emp:name");
                if (name == null || name.length() == 0) {
                    name = type.getElementName();
                }
                element.setLabel(name);
            }
            catch (Exception name) {
                // empty catch block
            }
            try {
                String catalog = (String)javaDocMap.get("emp:catalog");
                if (catalog == null || catalog.length() == 0) {
                    catalog = "extendedElements";
                }
                element.destCatalog = catalog;
            }
            catch (Exception catalog) {
                // empty catch block
            }
            try {
                String iconName = (String)javaDocMap.get("emp:iconName");
                if (iconName == null || iconName.length() == 0) {
                    iconName = defaultElement.getIconName();
                }
                element.setIconName(iconName);
            }
            catch (Exception iconName) {
                // empty catch block
            }
            try {
                if ("false".equals((String)javaDocMap.get("emp:visible"))) {
                    element.setVisable(false);
                }
                element.setVisable(true);
            }
            catch (Exception e) {
                element.setVisable(true);
            }
            try {
                String wrapperClass = (String)javaDocMap.get("emp:wrapperClass");
                if (wrapperClass == null || wrapperClass.length() == 0) {
                    wrapperClass = defaultElement.getWrapperClassType();
                }
                element.setWrapperClassType(wrapperClass);
            }
            catch (Exception wrapperClass) {
                // empty catch block
            }
            try {
                String editClass = (String)javaDocMap.get("emp:editClass");
                if (editClass == null || editClass.length() == 0) {
                    editClass = defaultElement.getEditClass();
                }
                element.setEditClass(editClass);
            }
            catch (Exception editClass) {
                // empty catch block
            }
            try {
                String wizardClass = (String)javaDocMap.get("emp:wizardClass");
                if (wizardClass == null) {
                    wizardClass = defaultElement.getWizardClassType();
                }
                if (wizardClass != null && wizardClass.length() > 0) {
                    element.setWizardClassType(wizardClass);
                }
            }
            catch (Exception wizardClass) {
                // empty catch block
            }
            try {
                String document = (String)javaDocMap.get("emp:document");
                if (document == null) {
                    document = defaultElement.getDocument();
                }
                element.setDocument(document);
            }
            catch (Exception document) {
                // empty catch block
            }
            try {
                ElementAttribute attr;
                XMLNode attrNode;
                String states = (String)javaDocMap.get("emp:states");
                if (states != null && states.length() > 0) {
                    attrNode = new XMLNode("attr");
                    attrNode.setAttrValue("id", "states");
                    attrNode.setAttrValue("attrName", "states");
                    attrNode.setAttrValue("editable", "false");
                    attrNode.setAttrValue("valueList", states);
                    attr = new ElementAttribute(attrNode);
                    element.addAttribute(attr);
                } else {
                    attrNode = new XMLNode("attr");
                    attrNode.setAttrValue("id", "states");
                    attrNode.setAttrValue("attrName", "states");
                    attrNode.setAttrValue("editable", "false");
                    attrNode.setAttrValue("valueList", "0=\u6210\u529f;");
                    attr = new ElementAttribute(attrNode);
                    element.addAttribute(attr);
                }
            }
            catch (Exception states) {
                // empty catch block
            }
            int i = 0;
            while (i < defaultElement.getAttributes().size()) {
                ElementAttribute attr = (ElementAttribute)defaultElement.getAttributes().elementAt(i);
                element.addAttribute(attr);
                ++i;
            }
            IMethod[] methods = type.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                block67: {
                    String isAttribute;
                    String attrName;
                    block68: {
                        String methodName = methods[i2].getElementName();
                        if (!methodName.startsWith("set")) break block67;
                        attrName = methodName.substring(3, methodName.length());
                        String firstChar = attrName.substring(0, 1);
                        if (attrName.length() > 1) {
                            String secondChar = attrName.substring(1, 2);
                            if (!secondChar.toUpperCase().equals(secondChar)) {
                                firstChar = firstChar.toLowerCase();
                            }
                        } else {
                            firstChar = firstChar.toLowerCase();
                        }
                        attrName = String.valueOf(firstChar) + attrName.substring(1, attrName.length());
                        if (element.getAttributes() == null) break block68;
                        boolean hasThisAttribute = false;
                        int j = 0;
                        while (j < element.getAttributes().size()) {
                            if (((ElementAttribute)element.getAttributes().elementAt(j)).getAttrID().equals(attrName)) {
                                hasThisAttribute = true;
                                break;
                            }
                            ++j;
                        }
                        if (hasThisAttribute) break block67;
                    }
                    if ((isAttribute = (String)(javaDocMap = IDEClassRefactor.getJavaDoc((IMember)methods[i2])).get("emp:isAttribute")) != null && isAttribute.equals("true")) {
                        XMLNode attrNode = new XMLNode("attr");
                        attrNode.setAttrValue("id", attrName);
                        try {
                            String name = (String)javaDocMap.get("emp:name");
                            if (name == null || name.length() == 0) {
                                name = attrName;
                            }
                            attrNode.setAttrValue("name", name);
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        try {
                            attrNode.setAttrValue("valueList", (String)javaDocMap.get("emp:valueList"));
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        try {
                            attrNode.setAttrValue("editorClass", (String)javaDocMap.get("emp:editClass"));
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        try {
                            attrNode.setDocument((String)javaDocMap.get("emp:desc"));
                            attrNode.setAttrValue("desc", (String)javaDocMap.get("emp:desc"));
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        try {
                            attrNode.setAttrValue("mustSet", (String)javaDocMap.get("emp:mustSet"));
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        try {
                            attrNode.setAttrValue("mustInputFormula", (String)javaDocMap.get("emp:mustSetFormula"));
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        try {
                            attrNode.setAttrValue("enableFormula", (String)javaDocMap.get("emp:enableFormula"));
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        try {
                            attrNode.setAttrValue("editable", (String)javaDocMap.get("emp:editable"));
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        try {
                            attrNode.setAttrValue("attrType", (String)javaDocMap.get("emp:attrType"));
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        try {
                            attrNode.setAttrValue("defaultValue", (String)javaDocMap.get("emp:defaultValue"));
                        }
                        catch (Exception name) {
                            // empty catch block
                        }
                        ElementAttribute attr = new ElementAttribute(attrNode);
                        element.addAttribute(attr);
                    }
                }
                ++i2;
            }
            try {
                i2 = 0;
                while (i2 < defaultElement.getChilds().size()) {
                    ElementChild child = (ElementChild)defaultElement.getChilds().elementAt(i2);
                    element.addChild(child);
                    ++i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return element;
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    private static Element createElementWithChild(String elementName, IProject project, IType type, Element defaultElement, EditorProfile profile) {
        try {
            Element element = IDEClassRefactor.createElement(elementName, type, defaultElement);
            try {
                if (type.isInterface()) {
                    element.setClassPattern(type.getFullyQualifiedName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                block22: {
                    try {
                        ElementChild child;
                        String childName;
                        String childFlag;
                        block23: {
                            String methodName = methods[i].getElementName();
                            if (!methodName.startsWith("add") && !methodName.startsWith("set")) break block22;
                            HashMap javaDocMap = IDEClassRefactor.getJavaDoc((IMember)methods[i]);
                            childFlag = (String)javaDocMap.get("emp:isChild");
                            childName = (String)javaDocMap.get("emp:childName");
                            if (childFlag == null) break block22;
                            if (childName == null || childName.length() == 0) {
                                childName = childFlag;
                                if (childFlag.indexOf(".") != -1) {
                                    childName = childFlag.substring(childFlag.lastIndexOf(".") + 1, childFlag.length());
                                }
                            }
                            child = new ElementChild();
                            child.setChildElementId(childName);
                            try {
                                String allowCount = (String)javaDocMap.get("emp:allowCount");
                                if (allowCount != null && allowCount.length() > 0) {
                                    child.setAllowCount(allowCount);
                                } else {
                                    if (methodName.startsWith("add")) {
                                        child.setAllowCount("*");
                                    }
                                    if (methodName.startsWith("set")) {
                                        child.setAllowCount("1");
                                    }
                                }
                            }
                            catch (Exception e) {
                                if (methodName.startsWith("add")) {
                                    child.setAllowCount("*");
                                }
                                if (!methodName.startsWith("set")) break block23;
                                child.setAllowCount("1");
                            }
                        }
                        IType childtype = type.getJavaProject().findType(childFlag);
                        if (childtype.isBinary()) {
                            Element childElement = IDEClassRefactor.getBinaryElement(project, childtype);
                            if (childElement == null) break block22;
                            profile.deleteElement(childElement.getElementName());
                            ElementCatalog catalog = profile.getElementCatalog("extendedElements");
                            if (catalog == null) {
                                catalog = new ElementCatalog();
                                catalog.setCatalogName("extendedElements");
                                profile.add(catalog);
                            }
                            catalog.addElement(childElement);
                            childElement.setEditorProfile(profile);
                        } else {
                            Element childDefaultElement = IDEClassRefactor.getComponentInterfaceElement(project, childtype);
                            Element childElement = IDEClassRefactor.createElementWithChild(childName, project, childtype, childDefaultElement, profile);
                            if (childtype.isInterface()) {
                                childElement.addClassSelect();
                            }
                        }
                        element.addChild(child);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
            }
            profile.deleteElement(element.getElementName());
            ElementCatalog catalog = profile.getElementCatalog("extendedElements");
            if (catalog == null) {
                catalog = new ElementCatalog();
                catalog.setCatalogName("extendedElements");
                profile.add(catalog);
            }
            catalog.addElement(element);
            element.setEditorProfile(profile);
            return element;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static HashMap getJavaDoc(IMember member) throws JavaModelException {
        HashMap<String, String> javaDocMap = new HashMap<String, String>();
        try {
            JavaDocCommentReader javaDocReader = (JavaDocCommentReader)JavadocContentAccess.getContentReader((IMember)member, (boolean)true);
            if (javaDocReader == null) {
                return new HashMap();
            }
            javaDocReader.reset();
            int ch = javaDocReader.read();
            while (ch >= 0) {
                if (ch == 64) {
                    int offset = javaDocReader.getOffset();
                    while ((ch = javaDocReader.read()) >= 0 && ch != 32 && ch != 13 && ch != 10) {
                    }
                    int length = javaDocReader.getOffset() - offset - 1;
                    char[] keyBuf = new char[length];
                    javaDocReader.reset();
                    while (javaDocReader.getOffset() < offset) {
                        javaDocReader.read();
                    }
                    javaDocReader.read(keyBuf, 0, length);
                    offset = javaDocReader.getOffset();
                    while ((ch = javaDocReader.read()) >= 0 && ch != 13 && ch != 10) {
                    }
                    length = javaDocReader.getOffset() - offset - 2;
                    if (length < 0) continue;
                    char[] valueBuf = new char[length];
                    javaDocReader.reset();
                    while (javaDocReader.getOffset() <= offset) {
                        javaDocReader.read();
                    }
                    javaDocReader.read(valueBuf, 0, length);
                    javaDocReader.read();
                    javaDocMap.put(new String(keyBuf), new String(valueBuf));
                    continue;
                }
                ch = javaDocReader.read();
            }
            return javaDocMap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    public static Element createElement(IFile file, String destComponentType) {
        IType type = IDEClassRefactor.getType(file);
        if (type == null) {
            return null;
        }
        Element interfaceElement = IDEClassRefactor.getComponentInterfaceElement(file.getProject(), type);
        if (!(destComponentType == null || interfaceElement != null && interfaceElement.getElementName().endsWith(destComponentType))) {
            return null;
        }
        Element element = IDEClassRefactor.createElement(null, type, interfaceElement);
        return element;
    }

    public static Element updateElement(IProject project, Element oldElement, String className) {
        IType type = IDEClassRefactor.getType(project, className);
        if (type == null) {
            return IDEClassRefactor.getComponentInterfaceElement(project, oldElement);
        }
        if (type.isBinary()) {
            Element element = IDEClassRefactor.getBinaryElement(project, type);
            if (element == null) {
                return IDEClassRefactor.getComponentInterfaceElement(project, oldElement);
            }
            element.setClassPattern(oldElement.getClassPattern());
            return element;
        }
        Element defaultElement = IDEClassRefactor.getComponentInterfaceElement(project, type);
        Element element = IDEClassRefactor.createElement(null, type, defaultElement);
        element.addClassSelect();
        element.setClassPattern(oldElement.getClassPattern());
        return element;
    }

    public static Element updateElementWithChild(IProject project, Element oldElement, String className, EditorProfile profile) {
        try {
            IType type = IDEClassRefactor.getType(project, className);
            if (type == null) {
                return IDEClassRefactor.getComponentInterfaceElement(project, oldElement);
            }
            if (type.isBinary()) {
                Element element = IDEClassRefactor.getBinaryElement(project, type);
                if (element == null) {
                    return IDEClassRefactor.getComponentInterfaceElement(project, oldElement);
                }
                element.setClassPattern(oldElement.getClassPattern());
                return element;
            }
            Element defaultElement = IDEClassRefactor.getComponentInterfaceElement(project, type);
            Element element = IDEClassRefactor.createElementWithChild(null, project, type, defaultElement, profile);
            element.setClassPattern(oldElement.getClassPattern());
            return element;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static IType getType(IFile file) {
        try {
            IJavaElement o = JavaCore.create((IFile)file);
            CompilationUnit d = (CompilationUnit)o;
            IType type = d.getAllTypes()[0];
            return type;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static IType getType(IProject project, String className) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IType type = javaProject.findType(className);
            return type;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Element getComponentInterfaceElement(IProject project, IType type) {
        EditorProfile profile2;
        try {
            profile2 = ModuleUtility.getComponentProfile(project, 41);
            EditorProfile componentProfile = ModuleUtility.getComponentProfile(project, 40);
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] superTypes = typeHierarchy.getAllClasses();
            IType[] interfaces = typeHierarchy.getAllInterfaces();
            Vector elements = profile2.getElements();
            int w = 0;
            while (w < superTypes.length) {
                String className = superTypes[w].getFullyQualifiedName();
                if (componentProfile.getElement(className) != null) {
                    return componentProfile.getElement(className);
                }
                ++w;
            }
            int i = 0;
            while (i < elements.size()) {
                Element element = (Element)elements.elementAt(i);
                int w2 = 0;
                while (w2 < superTypes.length) {
                    String className = superTypes[w2].getFullyQualifiedName();
                    if (element.getElementName().equals(className)) {
                        return element;
                    }
                    ++w2;
                }
                w2 = 0;
                while (w2 < interfaces.length) {
                    IType interfaceType = interfaces[w2];
                    if (element.getElementName().equals(interfaceType.getFullyQualifiedName())) {
                        return element;
                    }
                    ++w2;
                }
                ++i;
            }
        }
        catch (Exception profile2) {
            // empty catch block
        }
        try {
            profile2 = ModuleUtility.getComponentProfile(project, 41);
            return profile2.getElement("defaultElement");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Element getBinaryElement(IProject project, IType type) {
        try {
            EditorProfile profile = ModuleUtility.getComponentProfile(project, 40);
            Element element = profile.getElement(type.getFullyQualifiedName());
            if (element != null) {
                return element;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Element getComponentInterfaceElement(IProject project, Element oldElement) {
        try {
            EditorProfile profile = ModuleUtility.getComponentProfile(project, 41);
            return profile.getElement(oldElement.getClassPattern());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

