/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.refactor.editor;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.base.IDEContent;
import com.ecc.ide.base.IDEProfile;
import com.ecc.ide.editor.ContentChangedEvent;
import com.ecc.ide.editor.ContentChangedListener;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.plugin.properties.IDEProjectSettings;
import com.ecc.ide.refactor.editor.ClassMapDefinePanel;
import com.ecc.ide.refactor.editor.XMLEditorFramePanel;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class GenXMLEditor
extends MultiPageEditorPart
implements ContentChangedListener {
    private XMLEditorFramePanel trxPanel;
    private XMLNode xmlNode;
    private boolean isChanged = false;
    private IDEProjectSettings prjSettings;
    public IProject project;

    protected void createPages() {
        this.trxPanel = new XMLEditorFramePanel(this.getContainer(), 0);
        int index = this.addPage((Control)this.trxPanel);
        this.setPageText(index, "\u5185\u5bb9\u7f16\u8f91");
        try {
            IFileEditorInput fileInput = (IFileEditorInput)this.getEditorInput();
            InputStream content = fileInput.getFile().getContents();
            XMLLoader xmlLoader2 = new XMLLoader();
            xmlLoader2.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            this.xmlNode = (XMLNode)xmlLoader2.loadXMLContent(content);
            this.project = ((FileEditorInput)fileInput).getFile().getProject();
            EditorProfile profile = IDEProfile.getEditorProfile(this.project, 31);
            this.trxPanel.setEditorProfile(profile);
            this.prjSettings = IDEContent.getPRJSettings(this.project);
            ClassMapDefinePanel classMapDefinePanel = new ClassMapDefinePanel(this.getContainer(), 0, this.xmlNode.getChild("classMap"), fileInput.getFile().getProject());
            index = this.addPage((Control)classMapDefinePanel);
            this.setPageText(index, "\u7c7b\u6620\u5c04\u5b9a\u4e49");
            this.trxPanel.setXMLContent(this.xmlNode);
            this.trxPanel.setRootPath(this.project.getLocation().toString());
            XMLNode externResource = IDEContent.getSettingNode(this.project, 30);
            this.trxPanel.setExternResource(externResource);
            this.xmlNode.addContentChangedListener(this, this.project, 0);
            this.setTitle(fileInput.getFile().getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.xmlNode != null) {
            StringBuffer strBuf = new StringBuffer();
            String encoding = IDEConstance.encoding;
            if (this.prjSettings.getSetXMLEncodeManually()) {
                this.xmlNode.setEncoding(this.prjSettings.getXMLEncoding());
                encoding = this.prjSettings.getXMLEncoding();
            }
            this.xmlNode.toXMLContent(0, strBuf);
            IFileEditorInput fileInput = (IFileEditorInput)this.getEditorInput();
            IFile file = fileInput.getFile();
            try {
                file.setContents((InputStream)new ByteArrayInputStream(strBuf.toString().getBytes(encoding)), 1, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isChanged = false;
            this.firePropertyChange(257);
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void contentChanged(ContentChangedEvent event) {
        if (!this.isChanged) {
            this.isChanged = true;
            this.firePropertyChange(257);
            this.firePropertyChange(258);
        }
    }

    public boolean isDirty() {
        if (this.isChanged) {
            return true;
        }
        try {
            IEditorPart editor = this.getEditor(0);
            if (editor != null) {
                return editor.isDirty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

