/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.refactor.editor;

import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.WrapperOwner;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.refactor.IDEClassRefactor;
import org.eclipse.swt.widgets.TreeItem;

public class XMLElementWrapper
implements Wrapper {
    XMLNode xmlNode;
    Element element;
    TreeItem item;
    XMLElementWrapper parent;
    private Object beanTreeObj;
    protected WrapperOwner owner;

    public Object getWrappedObject() {
        return this.xmlNode;
    }

    public XMLElementWrapper(XMLNode node, EditorProfile profile) {
        if (node == null) {
            return;
        }
        this.xmlNode = node;
        this.element = profile.getElement(node.getNodeName());
        if (this.element == null) {
            String className = this.xmlNode.getAttrValue("class");
            this.element = profile.getElement(className.substring(className.lastIndexOf(".") + 1));
        }
        if (this.xmlNode.getAttrValue("class") != null && this.xmlNode.getAttrValue("class").length() > 0) {
            try {
                String classPattern = this.element.getClassPattern();
                boolean hasClassAttr = this.element.hasClassAttr();
                String className = this.xmlNode.getAttrValue("class");
                this.element = IDEClassRefactor.updateElementWithChild(profile.getProject(), this.element, className, profile);
                if (hasClassAttr) {
                    this.element.addClassSelect();
                }
                this.element.setClassPattern(classPattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public XMLElementWrapper(XMLNode node, Element element) {
        if (node == null) {
            return;
        }
        this.xmlNode = node;
        this.element = element;
    }

    public Element getElement() {
        if (this.xmlNode.getAttrValue("class") != null && this.xmlNode.getAttrValue("class").length() > 0) {
            try {
                EditorProfile profile = this.element.getEditorProfile();
                String classPattern = this.element.getClassPattern();
                boolean hasClassAttr = this.element.hasClassAttr();
                String className = this.xmlNode.getAttrValue("class");
                try {
                    if (className.equals(this.element.getElementName())) {
                        return this.element;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.element = IDEClassRefactor.updateElementWithChild(profile.getProject(), this.element, className, profile);
                if (hasClassAttr) {
                    this.element.addClassSelect();
                }
                this.element.setClassPattern(classPattern);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.element;
    }

    public String getObjectName() {
        return null;
    }

    public String getAttrValue(String attrName) {
        return this.xmlNode.getAttrValue(attrName);
    }

    public void setAttrValue(String attrName, Object value) {
        if (value != null) {
            this.xmlNode.setAttrValue(attrName, value.toString());
        } else {
            this.xmlNode.setAttrValue(attrName, null);
        }
        try {
            this.item.setText(this.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getText() {
        String desc = this.xmlNode.getAttrValue("label");
        if (desc != null && desc.length() > 0) {
            return desc;
        }
        return this.xmlNode.toString();
    }

    public void setBeanTreeObject(Object obj) {
        this.beanTreeObj = obj;
    }

    public Object getBeanTreeObject() {
        return this.beanTreeObj;
    }

    public WrapperOwner getWrapperOwner() {
        return this.owner;
    }

    public void setWrapperOwner(WrapperOwner owner) {
        this.owner = owner;
    }
}

