/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.reverse.engin;

import com.ecc.ide.reverse.engin.ChannelDefine;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ChannelSettingsPage
extends WizardPage {
    private Table table;
    private Text channelSessionCtxText;
    private Text channelCtxText;
    private Text channelIDText;
    private Hashtable channelDefs = new Hashtable();

    public ChannelSettingsPage(String pageName) {
        super(pageName);
    }

    public ChannelSettingsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Label label = new Label(container, 0);
        label.setText("Channel ID:");
        this.channelIDText = new Text(container, 2048);
        this.channelIDText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.channelIDText.setLayoutData((Object)new GridData(768));
        Label label_1 = new Label(container, 0);
        label_1.setText("ChannelContext:");
        this.channelCtxText = new Text(container, 2048);
        this.channelCtxText.setLayoutData((Object)new GridData(768));
        Label label_2 = new Label(container, 0);
        label_2.setText("ChannelSessionContext:");
        this.channelSessionCtxText = new Text(container, 2048);
        this.channelSessionCtxText.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(container, 0);
        GridData gridData = new GridData(640);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChannelSettingsPage.this.addChannelDefine();
            }
        });
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 80;
        button.setLayoutData((Object)gridData_2);
        button.setText("Add");
        Button button_1 = new Button(composite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChannelSettingsPage.this.deleteChannelDefine();
            }
        });
        GridData gridData_3 = new GridData(128);
        gridData_3.widthHint = 80;
        button_1.setLayoutData((Object)gridData_3);
        button_1.setText("Delete");
        Button button_2 = new Button(composite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        GridData gridData_4 = new GridData(128);
        gridData_4.widthHint = 80;
        button_2.setLayoutData((Object)gridData_4);
        button_2.setText("Update");
        this.table = new Table(container, 2048);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChannelSettingsPage.this.setActivateItem();
            }
        });
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 2;
        this.table.setLayoutData((Object)gridData_1);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText("Channel ID");
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(139);
        tableColumn_1.setText("Channel Context");
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(150);
        tableColumn_2.setText("Session context");
    }

    public boolean canFlipToNextPage() {
        return this.table.getItemCount() > 0;
    }

    private void setActivateItem() {
        TableItem[] items = this.table.getSelection();
        if (items == null || items.length != 1) {
            return;
        }
        ChannelDefine def = (ChannelDefine)items[0].getData();
        this.channelIDText.setText(def.channelID);
        this.channelCtxText.setText(def.rootContextName);
        this.channelSessionCtxText.setText(def.sessionContextName);
    }

    private void updateActivateItem() {
        TableItem[] items = this.table.getSelection();
        if (items == null || items.length != 1) {
            return;
        }
        ChannelDefine def = (ChannelDefine)items[0].getData();
        String channelID = this.channelIDText.getText();
        String rootCtxName = this.channelCtxText.getText();
        String sessionCtxName = this.channelSessionCtxText.getText();
        if (channelID.length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)"Please input proper channelID!");
            return;
        }
        ChannelDefine aDef = (ChannelDefine)this.channelDefs.get(channelID);
        if (aDef != null && aDef != def) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)"Duplicated channelID!");
            return;
        }
        if (rootCtxName.length() == 0 && sessionCtxName.length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)"You should set at lease one context!");
            return;
        }
        this.channelDefs.remove(def.channelID);
        ChannelDefine newDef = new ChannelDefine(channelID, rootCtxName, sessionCtxName);
        this.channelDefs.put(channelID, newDef);
        items[0].setText(channelID);
        items[0].setText(1, rootCtxName);
        items[0].setText(2, sessionCtxName);
        items[0].setData((Object)newDef);
    }

    private void addChannelDefine() {
        String channelID = this.channelIDText.getText();
        String rootCtxName = this.channelCtxText.getText();
        String sessionCtxName = this.channelSessionCtxText.getText();
        if (channelID.length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)"Please input proper channelID!");
            return;
        }
        if (this.channelDefs.get(channelID) != null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)"Duplicated channelID!");
            return;
        }
        if (rootCtxName.length() == 0 && sessionCtxName.length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)"You should set at lease one context!");
            return;
        }
        ChannelDefine def = new ChannelDefine(channelID, rootCtxName, sessionCtxName);
        this.channelDefs.put(channelID, def);
        TableItem item = new TableItem(this.table, 0);
        item.setText(channelID);
        item.setText(1, rootCtxName);
        item.setText(2, sessionCtxName);
        item.setData((Object)def);
        this.getContainer().updateButtons();
    }

    private void deleteChannelDefine() {
        TableItem[] items = this.table.getSelection();
        if (items == null || items.length == 0) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            ChannelDefine def = (ChannelDefine)items[i].getData();
            this.channelDefs.remove(def.channelID);
            items[i].dispose();
            ++i;
        }
        this.getContainer().updateButtons();
    }

    public Hashtable getChannelSettings() {
        return this.channelDefs;
    }
}

