/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.reverse.engin;

import com.ecc.ide.reverse.engin.ChannelDefine;
import com.ecc.ide.reverse.engin.FmtConverterDefine;
import com.ecc.ide.reverse.engin.FormatConverter;
import com.ecc.ide.reverse.engin.Messages;
import java.util.Hashtable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FormatSettingsPage
extends WizardPage {
    private Text pkgTypeText;
    private Combo fmtConverCombo;
    private Table table;
    private Text tagNameText;
    private Hashtable converterDefs = new Hashtable();

    public FormatSettingsPage(String pageName) {
        super(pageName);
    }

    public FormatSettingsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        Label label_1 = new Label(container, 0);
        label_1.setText(Messages.getString("FormatSettingsPage.Converter__2"));
        this.fmtConverCombo = new Combo(container, 0);
        this.fmtConverCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormatSettingsPage.this.setConverterClass();
            }
        });
        this.fmtConverCombo.setLayoutData((Object)new GridData(768));
        this.fmtConverCombo.setTextLimit(70);
        Label label = new Label(container, 0);
        label.setText(Messages.getString("FormatSettingsPage.tag_Name__1"));
        this.tagNameText = new Text(container, 2056);
        this.tagNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        this.tagNameText.setLayoutData((Object)new GridData(768));
        Label label_2 = new Label(container, 0);
        label_2.setText(Messages.getString("FormatSettingsPage.PackageType__3"));
        this.pkgTypeText = new Text(container, 2056);
        GridData gridData_5 = new GridData();
        gridData_5.widthHint = 155;
        this.pkgTypeText.setLayoutData((Object)gridData_5);
        Composite composite = new Composite(container, 0);
        GridData gridData = new GridData(640);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 3;
        composite.setLayout((Layout)gridLayout_1);
        Button button = new Button(composite, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatSettingsPage.this.addFormatDefine();
            }
        });
        GridData gridData_2 = new GridData();
        gridData_2.widthHint = 80;
        button.setLayoutData((Object)gridData_2);
        button.setText(Messages.getString("FormatSettingsPage.Add_4"));
        Button button_1 = new Button(composite, 0);
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatSettingsPage.this.deleteFormatDefine();
            }
        });
        GridData gridData_3 = new GridData(128);
        gridData_3.widthHint = 80;
        button_1.setLayoutData((Object)gridData_3);
        button_1.setText(Messages.getString("FormatSettingsPage.Delete_5"));
        Button button_2 = new Button(composite, 0);
        button_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        GridData gridData_4 = new GridData(128);
        gridData_4.widthHint = 80;
        button_2.setLayoutData((Object)gridData_4);
        button_2.setText(Messages.getString("FormatSettingsPage.Update_6"));
        this.table = new Table(container, 2048);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatSettingsPage.this.setActivateItem();
            }
        });
        GridData gridData_1 = new GridData(1808);
        gridData_1.horizontalSpan = 2;
        this.table.setLayoutData((Object)gridData_1);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(293);
        tableColumn_1.setText(Messages.getString("FormatSettingsPage.Converter_Class_9"));
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(100);
        tableColumn.setText(Messages.getString("FormatSettingsPage.TagName_7"));
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(100);
        tableColumn_2.setText(Messages.getString("FormatSettingsPage.PackageType_8"));
        this.searchFormatConverterClass();
    }

    public boolean canFlipToNextPage() {
        return this.table.getItemCount() > 0;
    }

    private void setActivateItem() {
        TableItem[] items = this.table.getSelection();
        if (items == null || items.length != 1) {
            return;
        }
        FmtConverterDefine def = (FmtConverterDefine)items[0].getData();
        this.tagNameText.setText(def.tagName);
        this.fmtConverCombo.setText(def.converterClass);
    }

    private void updateActivateItem() {
        TableItem[] items = this.table.getSelection();
        if (items == null || items.length != 1) {
            return;
        }
        FmtConverterDefine def = (FmtConverterDefine)items[0].getData();
        String tagName = this.tagNameText.getText();
        String className = this.fmtConverCombo.getText();
        String pkgType = this.pkgTypeText.getText();
        if (tagName.length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)Messages.getString("FormatSettingsPage.Please_input_proper_tagName_!_11"));
            return;
        }
        FmtConverterDefine aDef = (FmtConverterDefine)this.converterDefs.get(tagName);
        if (aDef != null && aDef != def) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)Messages.getString("FormatSettingsPage.Duplicated_tagName_!_13"));
            return;
        }
        this.converterDefs.remove(def.tagName);
        FmtConverterDefine newDef = new FmtConverterDefine(tagName, className, pkgType);
        this.converterDefs.put(tagName, newDef);
        items[0].setText(className);
        items[0].setText(1, tagName);
        items[0].setText(2, pkgType);
        items[0].setData((Object)newDef);
    }

    private void addFormatDefine() {
        String tagName = this.tagNameText.getText();
        String className = this.fmtConverCombo.getText();
        String pkgType = this.pkgTypeText.getText();
        if (tagName.length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)Messages.getString("FormatSettingsPage.Please_input_proper_tagName_!_15"));
            return;
        }
        if (this.converterDefs.get(tagName) != null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Message", (String)Messages.getString("FormatSettingsPage.Duplicated_tagName_!_17"));
            return;
        }
        FmtConverterDefine def = new FmtConverterDefine(tagName, className, pkgType);
        this.converterDefs.put(tagName, def);
        TableItem item = new TableItem(this.table, 0);
        item.setText(className);
        item.setText(1, tagName);
        item.setText(2, pkgType);
        item.setData((Object)def);
        this.getContainer().updateButtons();
    }

    private void deleteFormatDefine() {
        TableItem[] items = this.table.getSelection();
        if (items == null || items.length == 0) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            ChannelDefine def = (ChannelDefine)items[i].getData();
            this.converterDefs.remove(def.channelID);
            items[i].dispose();
            ++i;
        }
        this.getContainer().updateButtons();
    }

    public Hashtable getFormatSettings() {
        return this.converterDefs;
    }

    private void searchFormatConverterClass() {
        try {
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            SearchPattern pattern = SearchPattern.createPattern((String)"com.ecc.ide.reverse.engin.FormatConverter", (int)0, (int)1, (int)0);
            SearchEngine searchEngine = new SearchEngine();
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    Object obj = match.getElement();
                    if (obj instanceof IJavaElement) {
                        IJavaElement element = (IJavaElement)match.getElement();
                        String className = element.getElementName();
                        IJavaElement pElement = element.getParent().getParent();
                        String packageName = pElement.getElementName();
                        FormatSettingsPage.this.fmtConverCombo.add(String.valueOf(packageName) + "." + className);
                    }
                }
            }, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setConverterClass() {
        String className = this.fmtConverCombo.getText();
        try {
            Object obj = Class.forName(className).newInstance();
            if (obj instanceof FormatConverter) {
                FormatConverter converter = (FormatConverter)obj;
                String[] tags = converter.getSupportedTags();
                String pkgType = converter.getPackageType();
                String tagsStr = null;
                int i = 0;
                while (i < tags.length) {
                    tagsStr = i == 0 ? tags[i] : String.valueOf(tagsStr) + ";" + tags[i];
                    ++i;
                }
                this.tagNameText.setText(tagsStr);
                this.pkgTypeText.setText(pkgType);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void aboutToStart() {
    }

    public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) throws CoreException {
        String className = enclosingElement.getElementName();
        IJavaElement pElement = enclosingElement.getParent().getParent();
        String packageName = pElement.getElementName();
        this.fmtConverCombo.add(String.valueOf(packageName) + "." + className);
    }

    public void done() {
    }

    public IProgressMonitor getProgressMonitor() {
        return null;
    }
}

