/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.reverse.engin;

import com.ecc.ide.builder.BuildProblemReporter;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.ide.reverse.engin.FmtConverterDefine;
import com.ecc.ide.reverse.engin.FormatConverter;
import com.ecc.ide.reverse.engin.NewXMLElementObjectMaker;
import com.ecc.ide.reverse.engin.NewXMLLoader;
import com.ecc.ide.reverse.engin.ReverseEnginWizard;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReverseEngin
implements Runnable {
    public IProject project = null;
    public IProgressMonitor monitor = null;
    public BuildProblemReporter reporter;
    public String settingsFile;
    public String outputPath;
    public String rootCtxName;
    public String settingsRootPath;
    public boolean groupDataByOp = false;
    protected ReverseEnginWizard wizard;
    private String rootPath;
    private XMLNode srvFlowNode;
    protected Hashtable channelDefs;
    public Hashtable converterDefs;
    private XMLNode dataDictionaryNode;
    private XMLNode commonDataNode;
    private XMLNode channelsNode;
    private XMLNode serviceNode;
    private XMLNode formatNode;
    private XMLNode contextNode;
    private XMLNode dataNode;
    private XMLNode curOpNode;
    private XMLNode formatDefNode;
    private EditorProfile srvActionProfile;
    private ElementCatalog actionCatalog;
    private Element flowElement;
    private StringBuffer messageBuffer;
    private EditorProfile srvServiceProfile;
    private ElementCatalog svcCatalog;
    private Element servicesElement;
    XMLNode settingsNode;
    private XMLNode operTagsNode;
    private XMLNode opStepTagsNode;
    private XMLNode servicesTagsNode;
    private XMLNode opDefsNode;
    private XMLNode dataGroupNode;
    private NewXMLLoader xmlLoader = new NewXMLLoader();

    public ReverseEngin() {
        this.xmlLoader.addObjectMaker(new NewXMLElementObjectMaker());
    }

    public void run() {
        try {
            FileWriter fw;
            StringBuffer strBuf;
            ElementCatalog catalog;
            String entities;
            this.messageBuffer = new StringBuffer();
            this.dataDictionaryNode = new XMLNode();
            this.dataDictionaryNode.setNodeName("dataDictionary.xml");
            this.channelsNode = new XMLNode();
            this.channelsNode.setNodeName("channelSettings");
            this.formatNode = new XMLNode("Fmts");
            this.settingsFile = this.settingsFile.replace('\\', '/');
            int idx = this.settingsFile.lastIndexOf(47);
            this.rootPath = this.settingsFile.substring(0, idx);
            this.beginWork("reverse from: " + this.settingsFile, 1);
            this.reportProgress("Load settings file...");
            XMLNode settingsFileNode = (XMLNode)this.xmlLoader.loadXMLFile(this.settingsFile);
            this.reportProgress("Load settings Ok.", 1);
            this.settingsNode = settingsFileNode.findChildNode("settings");
            XMLNode tagsNode = this.settingsNode.findChildNode("kColl", "tags");
            this.operTagsNode = tagsNode.findChildNode("operations");
            this.opStepTagsNode = tagsNode.findChildNode("opSteps");
            this.servicesTagsNode = tagsNode.findChildNode("services");
            XMLNode fsNode = this.settingsNode.findChildNode("files");
            this.opDefsNode = fsNode.findChildNode("operations");
            if (this.opDefsNode == null) {
                this.opDefsNode = new XMLNode("kColl");
                this.opDefsNode.setAttrValue("id", "operations");
                fsNode.add(this.opDefsNode);
            }
            this.mergeSettingsFile(this.settingsNode);
            XMLNode pathNode = this.settingsNode.findChildNode("kColl", "paths");
            if (pathNode != null && (pathNode = pathNode.findChildNode("entities")) != null && !(entities = pathNode.getAttrValue("value")).startsWith(".")) {
                this.rootPath = entities;
            }
            this.showMessage("Root Path: " + this.rootPath);
            this.beginWork("Loading setting file: ", 4);
            XMLNode filesNode = this.settingsNode.findChildNode("kColl", "files");
            XMLNode dataFileNameNode = filesNode.findChildNode("data");
            this.reportProgress("Load Data file...");
            String fileName = String.valueOf(this.rootPath) + "/" + dataFileNameNode.getAttrValue("value");
            dataFileNameNode.setAttrValue("value", "data.xml");
            this.showMessage("Loading file: " + fileName);
            this.dataNode = (XMLNode)this.xmlLoader.loadXMLFile(fileName);
            this.mergeFile(this.dataNode, this.dataNode);
            this.reportProgress("Load Context file...", 1);
            XMLNode ctxFileNameNode = filesNode.findChildNode("context");
            fileName = String.valueOf(this.rootPath) + "/" + ctxFileNameNode.getAttrValue("value");
            ctxFileNameNode.setAttrValue("value", "contexts.xml");
            this.showMessage("Loading file: " + fileName);
            XMLNode ctxNode = (XMLNode)this.xmlLoader.loadXMLFile(fileName);
            this.mergeFile(ctxNode, ctxNode);
            this.contextNode = ctxNode;
            this.reportProgress("Load Format file...", 2);
            XMLNode fmtFileNameNode = filesNode.findChildNode("format");
            fileName = String.valueOf(this.rootPath) + "/" + fmtFileNameNode.getAttrValue("value");
            fmtFileNameNode.setAttrValue("value", "formats.xml");
            this.showMessage("Loading file: " + fileName);
            XMLNode fmtNode = (XMLNode)this.xmlLoader.loadXMLFile(fileName);
            this.mergeFile(fmtNode, fmtNode);
            this.formatDefNode = fmtNode;
            this.reportProgress("Load Services file...", 3);
            XMLNode svcFileNameNode = filesNode.findChildNode("service");
            fileName = String.valueOf(this.rootPath) + "/" + svcFileNameNode.getAttrValue("value");
            svcFileNameNode.setAttrValue("value", "services.xml");
            this.showMessage("Loading file: " + fileName);
            XMLNode svcNode = (XMLNode)this.xmlLoader.loadXMLFile(fileName);
            this.mergeFile(svcNode, svcNode);
            this.serviceNode = svcNode;
            this.reportProgress("Load Operation file...", 4);
            XMLNode operFileNameNode = filesNode.findChildNode("operation");
            fileName = String.valueOf(this.rootPath) + "/" + operFileNameNode.getAttrValue("value");
            operFileNameNode.setAttrValue("value", "operatoins.xml");
            this.showMessage("Loading file: " + fileName);
            XMLNode operNode = (XMLNode)this.xmlLoader.loadXMLFile(fileName);
            this.mergeFile(operNode, operNode);
            this.beginWork("Loading editor profiles...", 2);
            this.reportProgress("Load Srv Action profile file...");
            this.showMessage("Loading editorprofile file: .profiles/emptySrvActionProfile.xml");
            this.srvActionProfile = this.openEditorProfileFile(String.valueOf(this.outputPath) + "/.profiles/emptySrvActionProfile.xml");
            int i = 0;
            while (i < this.srvActionProfile.getCagalogs().size()) {
                catalog = (ElementCatalog)this.srvActionProfile.getCagalogs().elementAt(i);
                if ("Imported Element".equals(catalog.getCatalogName())) {
                    this.srvActionProfile.deleteElementCatalog(catalog);
                    break;
                }
                ++i;
            }
            this.actionCatalog = new ElementCatalog();
            this.actionCatalog.setCatalogName("Imported Element");
            this.actionCatalog.setShowInToolPanel(true);
            this.srvActionProfile.addElementCatalog(this.actionCatalog);
            this.flowElement = this.srvActionProfile.getElement("flow");
            this.showMessage("Loading editorprofile file: .profiles/emptySrvServiceProfile.xml");
            this.reportProgress("Load Srv Service profile file...", 1);
            this.srvServiceProfile = this.openEditorProfileFile(String.valueOf(this.outputPath) + "/.profiles/emptySrvServiceProfile.xml");
            i = 0;
            while (i < this.srvServiceProfile.getCagalogs().size()) {
                catalog = (ElementCatalog)this.srvServiceProfile.getCagalogs().elementAt(i);
                if ("Imported Element".equals(catalog.getCatalogName())) {
                    this.srvServiceProfile.deleteElementCatalog(catalog);
                    break;
                }
                ++i;
            }
            this.svcCatalog = new ElementCatalog();
            this.svcCatalog.setCatalogName("Imported Element");
            this.svcCatalog.setShowInToolPanel(true);
            this.srvServiceProfile.addElementCatalog(this.svcCatalog);
            this.servicesElement = this.srvServiceProfile.getElement("Services");
            this.reportProgress("Load Srv Service profile file OK.", 2);
            this.processContextAndData(ctxNode);
            this.processCommonFormat(fmtNode);
            this.processCommonOperationFile(operNode);
            this.processCommonServiceNode();
            this.processOperations();
            if (this.dataDictionaryNode.findChildNode("constant") == null) {
                XMLNode node = new XMLNode("dataElement");
                node.setAttrValue("id", "constant");
                node.setAttrValue("access", "common");
                node.setAttrValue("label", "\u5e38\u91cf\u5b9a\u4e49");
                this.dataDictionaryNode.add(node);
            }
            this.showMessage("reverse finished, saving files...");
            this.saveXMLFile(String.valueOf(this.outputPath) + "/designFiles/dataDictionary.xml", this.dataDictionaryNode);
            this.saveXMLFile(String.valueOf(this.outputPath) + "/designFiles/channelSettings.xml", this.channelsNode);
            this.saveXMLFile(String.valueOf(this.outputPath) + "/designFiles/srvServices.xml", this.serviceNode);
            this.saveXMLFile(String.valueOf(this.outputPath) + "/designFiles/srvFormats.xml", this.formatNode);
            this.saveXMLFile(String.valueOf(this.outputPath) + "/designFiles/serverFlow.xml", this.srvFlowNode);
            this.saveXMLFile(String.valueOf(this.outputPath) + "/" + this.settingsRootPath + "/settings.xml", settingsFileNode);
            try {
                strBuf = new StringBuffer();
                this.srvActionProfile.toXMLString(strBuf);
                fw = new FileWriter(String.valueOf(this.outputPath) + "/.profiles/srvActionProfile.xml");
                fw.write(strBuf.toString());
                fw.close();
            }
            catch (Exception e) {
                this.showMessage(e.toString());
                e.printStackTrace();
            }
            try {
                strBuf = new StringBuffer();
                this.srvServiceProfile.toXMLString(strBuf);
                fw = new FileWriter(String.valueOf(this.outputPath) + "/.profiles/srvServiceProfile.xml");
                fw.write(strBuf.toString());
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            this.showMessage(e.toString());
            e.printStackTrace();
        }
        this.showMessage("reverse finished!");
        if (this.reporter != null) {
            this.reporter.reportProblem(2, "Import messages, please see detail message", this.messageBuffer.toString());
        }
    }

    private void processOperations() {
        this.showMessage("Processing selfDefined operations...");
        XMLNode opDefsNode = this.settingsNode.findChildNode("files");
        opDefsNode = opDefsNode.findChildNode("operations");
        NewXMLLoader xmlLoader = new NewXMLLoader();
        xmlLoader.addObjectMaker(new NewXMLElementObjectMaker());
        this.beginWork("Process self defined operations...", opDefsNode.getChilds().size());
        this.commonDataNode = new XMLNode("CommonData");
        this.dataDictionaryNode.add(this.commonDataNode);
        int i = 0;
        while (i < opDefsNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)opDefsNode.getChilds().elementAt(i);
            if ("operDef".equals(aNode.getNodeName())) {
                String id = aNode.getAttrValue("id");
                String value = aNode.getAttrValue("value");
                if (this.groupDataByOp) {
                    this.dataGroupNode = new XMLNode("dataGroup");
                    this.dataGroupNode.setAttrValue("name", id);
                    this.dataDictionaryNode.add(this.dataGroupNode);
                }
                String fileName = String.valueOf(this.rootPath) + "/" + value;
                try {
                    XMLNode refKCollNode;
                    XMLNode kCollNode;
                    String pCtxName;
                    String ctxName;
                    XMLNode ctxNode;
                    XMLNode opDefNode;
                    this.showMessage("Process self define operation file: " + fileName);
                    this.reportProgress("Process operation define file:" + fileName, i);
                    this.curOpNode = opDefNode = (XMLNode)xmlLoader.loadXMLFile(fileName);
                    XMLNode trxNode = new XMLNode("MCITransaction");
                    trxNode.setAttrValue("trxCode", id);
                    trxNode.setAttrValue("refToStateMachine", "false");
                    trxNode.setAttrValue("useStateMachine", "false");
                    trxNode.setAttrValue("refToMainFlow", "false");
                    String classify = value;
                    int idx = value.lastIndexOf(47);
                    if (idx != -1) {
                        classify = value.substring(0, idx);
                    }
                    File aFile = new File(String.valueOf(this.outputPath) + "/designFiles/MCITrxs/" + classify);
                    aFile.mkdirs();
                    trxNode.setAttrValue("classify", classify);
                    XMLNode operationNode = opDefNode.findChildNode(id);
                    String document = this.getNodePrefComment(operationNode);
                    if (document != null && document.length() > 0) {
                        trxNode.setDocument(document);
                    }
                    if ((ctxNode = opDefNode.findChildNode("context", ctxName = operationNode.getAttrValue("operationContext"))) == null) {
                        ctxNode = this.contextNode.findChildNode(ctxName);
                    }
                    if ((pCtxName = ctxNode.getAttrValue("parent")) != null) {
                        trxNode.setAttrValue("nonSessionTrx", "true");
                        trxNode.setAttrValue("chainedChannelId", pCtxName);
                    }
                    if ((kCollNode = opDefNode.findChildNode("kColl", (refKCollNode = ctxNode.getChild("refKColl")).getAttrValue("refId"))) == null) {
                        kCollNode = this.dataNode.findChildNode(refKCollNode.getAttrValue("refId"));
                    }
                    XMLNode refDataNode = new XMLNode("datas");
                    trxNode.add(refDataNode);
                    this.reportProgress("process context and datas...");
                    this.showMessage("Process context and data...");
                    this.processDataCollectionNode(refDataNode, kCollNode, "private");
                    XMLNode flowNode = new XMLNode("flow");
                    trxNode.add(flowNode);
                    flowNode.setAttrValue("id", "SelfFlow");
                    flowNode.setAttrValue("name", "SelfFlow");
                    flowNode.setAttrValue("x", "1");
                    flowNode.setAttrValue("y", "2");
                    flowNode.setAttrValue("width", "600");
                    flowNode.setAttrValue("height", "400");
                    String opClassId = operationNode.getNodeName();
                    XMLNode classNode = this.operTagsNode.findChildNode(opClassId);
                    if (classNode != null) {
                        flowNode.setAttrValue("implClass", classNode.getAttrValue("value"));
                    }
                    this.showMessage("Process flow...");
                    this.reportProgress("process operation flow...");
                    if (this.operTagsNode.findChildNode(operationNode.getNodeName()) == null) {
                        flowNode.setAttrValue("implClass", operationNode.getNodeName());
                    }
                    int y = 10;
                    int count = 0;
                    int k = 0;
                    while (k < operationNode.getChilds().size()) {
                        XMLNode stepDefNode = (XMLNode)operationNode.getChilds().elementAt(k);
                        String nodeName = stepDefNode.getNodeName();
                        if ("opStep".equals(nodeName)) {
                            XMLNode nextNode = null;
                            int l = k + 1;
                            while (l < operationNode.getChilds().size()) {
                                XMLNode node = (XMLNode)operationNode.getChilds().elementAt(l);
                                if (node.getNodeName().equals("opStep")) {
                                    nextNode = node;
                                    break;
                                }
                                ++l;
                            }
                            XMLNode stepNode = this.processOpStepNode(stepDefNode, nextNode);
                            if (count > 2 && count % 3 == 0) {
                                y += 60;
                            }
                            stepNode.setAttrValue("x", String.valueOf(10 + 200 * (count % 3)));
                            stepNode.setAttrValue("y", String.valueOf(y));
                            stepNode.setAttrValue("height", "50");
                            stepNode.setAttrValue("width", "120");
                            flowNode.add(stepNode);
                            ++count;
                        }
                        ++k;
                    }
                    XMLNode endStepNode = new XMLNode("END");
                    endStepNode.setAttrValue("name", "END0");
                    endStepNode.setAttrValue("x", "10");
                    endStepNode.setAttrValue("y", String.valueOf((y += 60) + 20));
                    endStepNode.setAttrValue("height", "35");
                    endStepNode.setAttrValue("width", "120");
                    flowNode.setAttrValue("height", String.valueOf(y + 20));
                    flowNode.add(endStepNode);
                    this.showMessage("Process format ...");
                    this.reportProgress("process formats...");
                    XMLNode fmtsNode = new XMLNode("formats");
                    trxNode.add(fmtsNode);
                    int k2 = 0;
                    while (k2 < operationNode.getChilds().size()) {
                        XMLNode refFmtDefNode = (XMLNode)operationNode.getChilds().elementAt(k2);
                        String nodeName = refFmtDefNode.getNodeName();
                        if ("refFormat".equals(nodeName)) {
                            XMLNode fmtNode;
                            String fmtId = refFmtDefNode.getAttrValue("refId");
                            String fmtName = refFmtDefNode.getAttrValue("name");
                            XMLNode fmtDefNode = opDefNode.findChildNode("fmtDef", fmtId);
                            if (fmtDefNode != null && (fmtNode = this.convertFmtNode(fmtDefNode)) != null) {
                                fmtsNode.add(fmtNode);
                                document = this.getNodePrefComment(fmtDefNode);
                                if (document != null && document.length() > 0) {
                                    fmtNode.setDocument(document);
                                }
                            }
                        }
                        ++k2;
                    }
                    this.showMessage("Process Services...");
                    this.reportProgress("process services...");
                    XMLNode servicesNode = new XMLNode("services");
                    trxNode.add(servicesNode);
                    int k3 = 0;
                    while (k3 < ctxNode.getChilds().size()) {
                        XMLNode node = (XMLNode)ctxNode.getChilds().elementAt(k3);
                        String nodeName = node.getNodeName();
                        if ("refService".equals(nodeName)) {
                            boolean fromCommon = false;
                            String refId = node.getAttrValue("refId");
                            String name = node.getAttrValue("alias");
                            XMLNode svcDefNode = opDefNode.findChildNode(refId);
                            if (svcDefNode == null) {
                                fromCommon = true;
                                svcDefNode = this.serviceNode.findChildNode(refId);
                            }
                            if (svcDefNode != null) {
                                svcDefNode.setAttrValue("alias", name);
                                if (!fromCommon) {
                                    document = this.getNodePrefComment(svcDefNode);
                                    if (document != null && document.length() > 0) {
                                        svcDefNode.setDocument(document);
                                    }
                                    servicesNode.add(svcDefNode);
                                }
                                this.processServiceNode(this.servicesElement, svcDefNode);
                            }
                        }
                        ++k3;
                    }
                    this.reportProgress("saving file...");
                    this.saveXMLFile(String.valueOf(this.outputPath) + "/designFiles/MCITrxs/" + classify + "/" + id + ".mtx", trxNode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.showMessage("Failed to process: " + e);
                }
            }
            ++i;
        }
    }

    private void processCommonOperationFile(XMLNode opersNode) {
        this.srvFlowNode = new XMLNode("FlowDefs");
        this.showMessage("Process Common defined operations...");
        this.beginWork("Process common defined operations...", opersNode.getChilds().size());
        int i = 0;
        while (i < opersNode.getChilds().size()) {
            XMLNode operNode = (XMLNode)opersNode.getChilds().elementAt(i);
            if (!"#comment".equals(operNode.getNodeName())) {
                this.reportProgress("Process operation define of: " + operNode.getAttrValue("id"), i);
                XMLNode aFlowNode = this.processOperationNode(operNode);
                this.srvFlowNode.add(aFlowNode);
            }
            ++i;
        }
    }

    private XMLNode processOperationNode(XMLNode operDefNode) {
        String ctxName;
        XMLNode flowNode = new XMLNode("flow");
        flowNode.setAttrValue("id", operDefNode.getAttrValue("id"));
        flowNode.setAttrValue("name", operDefNode.getAttrValue("id"));
        flowNode.setAttrValue("x", "1");
        flowNode.setAttrValue("y", "2");
        flowNode.setAttrValue("width", "700");
        flowNode.setAttrValue("height", "400");
        if (this.operTagsNode.findChildNode(operDefNode.getNodeName()) == null) {
            flowNode.setAttrValue("implClass", operDefNode.getNodeName());
        }
        if ((ctxName = operDefNode.getAttrValue("operationContext")) != null && ctxName.length() > 0) {
            XMLNode xMLNode = this.contextNode.findChildNode(ctxName);
        }
        int y = 10;
        int count = 0;
        int i = 0;
        while (i < operDefNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)operDefNode.getChilds().elementAt(i);
            String nodeName = aNode.getNodeName();
            if (!"refFormat".equals(nodeName) && "opStep".equals(nodeName)) {
                XMLNode nextNode = null;
                try {
                    nextNode = (XMLNode)operDefNode.getChilds().elementAt(i + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                XMLNode stepNode = this.processOpStepNode(aNode, nextNode);
                if (count > 2 && count % 3 == 0) {
                    y += 60;
                }
                stepNode.setAttrValue("x", String.valueOf(200 * (count % 3)));
                stepNode.setAttrValue("y", String.valueOf(y));
                stepNode.setAttrValue("height", "50");
                stepNode.setAttrValue("width", "120");
                flowNode.add(stepNode);
                ++count;
            }
            ++i;
        }
        XMLNode endStepNode = new XMLNode("END");
        endStepNode.setAttrValue("name", "END0");
        endStepNode.setAttrValue("x", "10");
        endStepNode.setAttrValue("y", String.valueOf(y += 60));
        endStepNode.setAttrValue("height", "35");
        endStepNode.setAttrValue("width", "120");
        flowNode.setAttrValue("height", String.valueOf(y + 20));
        flowNode.add(endStepNode);
        return flowNode;
    }

    private void processCommonServiceNode() {
        int i = 0;
        while (i < this.serviceNode.getChilds().size()) {
            Element element;
            XMLNode svcDefNode = (XMLNode)this.serviceNode.getChilds().elementAt(i);
            if (!"#comment".equals(svcDefNode.getNodeName()) && !"document".equals(svcDefNode.getNodeName()) && (element = this.srvServiceProfile.getElement(svcDefNode.getNodeName())) == null) {
                this.processServiceNode(this.servicesElement, svcDefNode);
                String document = this.getNodePrefComment(svcDefNode);
                if (document != null && document.length() > 0) {
                    svcDefNode.setDocument(document);
                }
            }
            ++i;
        }
    }

    private void processServiceNode(Element pElement, XMLNode svcNode) {
        String svcId = svcNode.getNodeName();
        Element element = this.srvServiceProfile.getElement(svcId);
        if (element == null) {
            element = new Element();
            element.setElementName(svcId);
            XMLNode svcSettingNode = this.servicesTagsNode.findChildNode(svcId);
            if (svcSettingNode != null) {
                String implClass = svcSettingNode.getAttrValue("value");
                element.setImplClass(implClass);
            }
            element.setIconName("/images/newElement.gif");
            this.svcCatalog.addElement(element);
            ElementChild child = new ElementChild();
            child.setAllowCount("*");
            child.setChildElementId(svcId);
            pElement.addChild(child);
        } else {
            ElementChild child = new ElementChild();
            child.setAllowCount("*");
            child.setChildElementId(svcId);
            pElement.addChild(child);
        }
        Hashtable attrs = svcNode.getAttrs();
        Enumeration atts = attrs.keys();
        while (atts.hasMoreElements()) {
            String key = (String)atts.nextElement();
            ElementAttribute attr = new ElementAttribute();
            attr.setAttrID(key);
            element.addAttribute(attr);
        }
        int i = 0;
        while (i < svcNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)svcNode.getChilds().elementAt(i);
            if (!"#comment".equals(aNode.getNodeName()) && !"document".equals(aNode.getNodeName())) {
                this.processServiceNode(element, aNode);
            }
            ++i;
        }
    }

    private XMLNode processOpStepNode(XMLNode stepNode, XMLNode nextNode) {
        Element element;
        String stepId;
        String id = stepNode.getAttrValue("alias");
        if (id == null) {
            id = stepNode.getAttrValue("id");
        }
        String opStepID = stepId = stepNode.getAttrValue("id");
        String implClass = "";
        XMLNode stepSettingNode = this.opStepTagsNode.findChildNode(stepId);
        if (stepSettingNode == null) {
            this.showMessage("opSetp not set in ini file for: " + stepNode);
        } else {
            implClass = stepSettingNode.getAttrValue("value");
            int idx = implClass.lastIndexOf(46);
            opStepID = implClass.substring(idx + 1);
        }
        XMLNode stepDefNode = new XMLNode(opStepID);
        stepDefNode.setAttrValue("name", id);
        String document = this.getNodePrefComment(stepNode);
        if (document != null && document.length() > 0) {
            stepDefNode.setAttrValue("label", document);
        }
        if ((element = this.srvActionProfile.getElement(opStepID)) == null) {
            element = new Element();
            element.setElementName(opStepID);
            element.setImplClass(implClass);
            element.setIconName("/images/newElement.gif");
            element.setWrapperClassType("com.ecc.ide.editor.visualflow.ActionElementWrapper");
            ElementAttribute attr = new ElementAttribute();
            attr.setAttrID("label");
            element.addAttribute(attr);
            this.actionCatalog.addElement(element);
            ElementChild child = new ElementChild();
            child.setAllowCount("*");
            child.setChildElementId(opStepID);
            this.flowElement.addChild(child);
        }
        String valueList = "";
        Hashtable attrs = stepNode.getAttrs();
        Enumeration atts = attrs.keys();
        while (atts.hasMoreElements()) {
            String key = (String)atts.nextElement();
            int idx1 = key.indexOf("on");
            int idx2 = key.indexOf("Do");
            if (idx1 != -1 && idx2 != -1) {
                id = key.substring(idx1 + 2, idx2);
                valueList = String.valueOf(valueList) + id + "=" + id + ";";
                XMLNode transitionNode = new XMLNode("transition");
                transitionNode.setAttrValue("id", id);
                String dest = (String)attrs.get(key);
                if (dest.equals("end")) {
                    dest = "END0";
                } else if (dest.equals("next") && nextNode != null && (dest = nextNode.getAttrValue("alias")) == null) {
                    dest = nextNode.getAttrValue("id");
                }
                transitionNode.setAttrValue("dest", dest);
                stepDefNode.add(transitionNode);
                continue;
            }
            if ("id".equals(key)) continue;
            stepDefNode.setAttrValue(key, (String)attrs.get(key));
            ElementAttribute attr = new ElementAttribute();
            attr.setAttrID(key);
            element.addAttribute(attr);
        }
        ElementAttribute attr = new ElementAttribute();
        attr.setAttrID("states");
        attr.setEditable(false);
        attr.setValueListStr(valueList);
        element.addAttribute(attr);
        return stepDefNode;
    }

    private void processCommonFormat(XMLNode fmtNode) {
        this.showMessage("Process common format defines...");
        this.formatNode = new XMLNode("GenFmts");
        this.beginWork("Process common format defines...", fmtNode.getChilds().size());
        int i = 0;
        while (i < fmtNode.getChilds().size()) {
            XMLNode fmtDefNode = (XMLNode)fmtNode.getChilds().elementAt(i);
            if (!"#comment".equals(fmtDefNode.getNodeName())) {
                this.reportProgress("Process format define: " + fmtDefNode.getAttrValue("id"), i);
                XMLNode node = this.convertFmtNode(fmtDefNode);
                if (node == null) {
                    StringBuffer buf = new StringBuffer();
                    fmtDefNode.toXMLContent(0, buf);
                    this.showMessage("Failed to convert format:\n" + buf.toString());
                } else {
                    String comment = this.getNodePrefComment(fmtDefNode);
                    if (comment != null && comment.length() > 0) {
                        node.setDocument(comment);
                    }
                    this.formatNode.add(node);
                }
            }
            ++i;
        }
    }

    private XMLNode convertFmtNode(XMLNode fmtDefNode) {
        FormatConverter converter;
        block6: {
            try {
                converter = null;
                Enumeration fmtDefs = this.converterDefs.elements();
                while (fmtDefs.hasMoreElements()) {
                    FmtConverterDefine fmtDef = (FmtConverterDefine)fmtDefs.nextElement();
                    FormatConverter converter1 = fmtDef.getFormatConverter();
                    if (converter1 == null) continue;
                    String[] tagNames = converter1.getSupportedTags();
                    int i = 0;
                    while (i < tagNames.length) {
                        XMLNode node = fmtDefNode.findChild(tagNames[i]);
                        if (node != null) {
                            converter = converter1;
                            break;
                        }
                        ++i;
                    }
                    if (converter != null) break;
                }
                if (converter != null) break block6;
                this.showMessage("Fmt converter not define for:\n " + fmtDefNode.toString());
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        converter.setCommonFmtDefNode(this.formatDefNode);
        XMLNode node = converter.convertFormat(fmtDefNode);
        return node;
    }

    private void processContextAndData(XMLNode contextNode) {
        try {
            this.beginWork("Process root context datas...", 2);
            this.showMessage("Process root Context...");
            XMLNode rootCtxNode = contextNode.findChildNode(this.rootCtxName);
            XMLNode refKCollNode = rootCtxNode.getChild("refKColl");
            this.reportProgress("Process dataElements...");
            this.showMessage("process root data Elements...");
            XMLNode kCollNode = this.dataNode.findChildNode(refKCollNode.getAttrValue("refId"));
            this.processDataCollectionNode(null, kCollNode, "common");
            this.showMessage("process root data Elements OK.");
            this.reportProgress("Process Services...", 1);
            this.showMessage("Process root services...");
            this.processServices(null, rootCtxNode, "common");
            this.showMessage("Process root services OK.");
            this.reportProgress("Process Services OK.", 2);
            this.showMessage("Process root Context OK.");
            this.processChannelSettings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processChannelSettings() {
        Vector channelNodes = this.findChildCtxNode(this.rootCtxName);
        this.beginWork("Process root channel settings...", channelNodes.size());
        int i = 0;
        while (i < channelNodes.size()) {
            String channelId;
            this.reportProgress("Process channel settings..", i);
            XMLNode channelRootNode = (XMLNode)channelNodes.elementAt(i);
            Vector sessionNodes = this.findChildCtxNode(channelRootNode.getAttrValue("id"));
            if (sessionNodes.size() <= 1) {
                channelId = channelRootNode.getAttrValue("id");
                if (sessionNodes.size() > 0) {
                    this.genChannelSettings(channelId, channelRootNode, (XMLNode)sessionNodes.elementAt(0));
                } else {
                    this.genChannelSettings(channelId, channelRootNode, null);
                }
            } else {
                channelId = channelRootNode.getAttrValue("id");
                int k = 0;
                while (k < sessionNodes.size()) {
                    XMLNode sessionNode = (XMLNode)sessionNodes.elementAt(k);
                    String chId = sessionNode.getAttrValue("id");
                    this.genChannelSettings(chId, channelRootNode, sessionNode);
                    ++k;
                }
            }
            ++i;
        }
    }

    private void genChannelSettings(String channelId, XMLNode channelCtxNode, XMLNode channelSessionCtxNode) {
        XMLNode kCollNode;
        XMLNode refKCollNode;
        this.showMessage("Process channel: " + channelId);
        this.reportProgress("Process channel settings of:" + channelId);
        XMLNode aChannelNode = new XMLNode();
        aChannelNode.setNodeName("channel");
        aChannelNode.setAttrValue("id", channelId);
        if (channelCtxNode != null) {
            aChannelNode.setAttrValue("channelCtxName", channelCtxNode.getAttrValue("id"));
        }
        if (channelSessionCtxNode != null) {
            aChannelNode.setAttrValue("channelSessionName", channelSessionCtxNode.getAttrValue("id"));
        }
        this.channelsNode.add(aChannelNode);
        XMLNode refDataNode = new XMLNode();
        refDataNode.setNodeName("sessionDatas");
        aChannelNode.add(refDataNode);
        XMLNode refSvcNode = new XMLNode();
        refSvcNode.setNodeName("refServices");
        aChannelNode.add(refSvcNode);
        if (channelCtxNode != null) {
            this.reportProgress("Process channel root settings");
            this.showMessage("Process channel root Context " + channelCtxNode);
            refKCollNode = channelCtxNode.getChild("refKColl");
            this.showMessage("process channel root data Elements...");
            kCollNode = this.dataNode.findChildNode(refKCollNode.getAttrValue("refId"));
            this.processDataCollectionNode(refDataNode, kCollNode, "common");
            this.showMessage("process channel root data Elements OK.");
            this.showMessage("Process channel root services...");
            this.processServices(refSvcNode, channelCtxNode, "common");
            this.showMessage("Process channel root services OK.");
        }
        if (channelSessionCtxNode != null) {
            this.reportProgress("Process channel session settings");
            this.showMessage("Process channel session Context " + channelSessionCtxNode);
            refKCollNode = channelSessionCtxNode.getChild("refKColl");
            this.showMessage("process channel session data Elements...");
            kCollNode = this.dataNode.findChildNode(refKCollNode.getAttrValue("refId"));
            this.processDataCollectionNode(refDataNode, kCollNode, "session");
            this.showMessage("process channel session data Elements OK.");
            this.showMessage("Process channel session services...");
            this.processServices(refSvcNode, channelSessionCtxNode, "session");
            this.showMessage("Process channel session services OK.");
        }
    }

    private Vector findChildCtxNode(String ctxName) {
        Vector<XMLNode> childs = new Vector<XMLNode>(20);
        int i = 0;
        while (i < this.contextNode.getChilds().size()) {
            XMLNode node = (XMLNode)this.contextNode.getChilds().elementAt(i);
            String parent = node.getAttrValue("parent");
            if (ctxName.equals(parent)) {
                childs.addElement(node);
            }
            ++i;
        }
        return childs;
    }

    private void processServices(XMLNode includeNode, XMLNode ctxNode, String access) {
        int i = 0;
        while (i < ctxNode.getChilds().size()) {
            XMLNode node = (XMLNode)ctxNode.getChilds().elementAt(i);
            if ("refService".equals(node.getNodeName())) {
                String refId = node.getAttrValue("refId");
                XMLNode svcNode = this.serviceNode.findChildNode(refId);
                if (svcNode == null) {
                    this.showMessage("Failed to find the service define: " + node);
                } else {
                    if (includeNode != null) {
                        includeNode.add(node);
                        node.setAttrValue("access", access);
                        node.setAttrValue("id", refId);
                    } else {
                        svcNode.setAttrValue("access", access);
                    }
                    String comment = this.getNodePrefComment(svcNode);
                    if (comment != null && comment.length() > 0) {
                        svcNode.setDocument(comment);
                    }
                    this.processServiceNode(this.servicesElement, svcNode);
                }
            }
            ++i;
        }
    }

    private void processDataCollectionNode(XMLNode includeNode, XMLNode kCollNode, String access) {
        try {
            int i = 0;
            while (i < kCollNode.getChilds().size()) {
                XMLNode aDataNode = (XMLNode)kCollNode.getChilds().elementAt(i);
                String nodeName = aDataNode.getNodeName();
                String id = aDataNode.getAttrValue("id");
                if (nodeName.equals("field") || nodeName.equals("secureField")) {
                    this.addDataNode(includeNode, aDataNode, access);
                } else if (nodeName.equals("refData")) {
                    String refId = aDataNode.getAttrValue("refId");
                    XMLNode refNode = this.dataNode.findChildNode(refId);
                    if (refNode != null) {
                        XMLNode refCommonNode = new XMLNode("refCommData");
                        refCommonNode.setAttrValue("refId", refId);
                        includeNode.add(refCommonNode);
                        XMLNode cDNode = this.commonDataNode.findChildNode(refId);
                        if (cDNode == null) {
                            if (refNode.getNodeName().equals("field") || nodeName.equals("secureField")) {
                                this.addDataNode(this.commonDataNode, refNode, access);
                            } else if (refNode.getNodeName().equals("iColl")) {
                                this.processICollNode(this.commonDataNode, refNode, access);
                            } else if (refNode.getNodeName().equals("kColl")) {
                                XMLNode grpNode = new XMLNode("dataGroup");
                                grpNode.setAttrValue("id", refId);
                                grpNode.setAttrValue("name", refId);
                                this.commonDataNode.add(grpNode);
                                this.processDataCollectionNode(grpNode, refNode, access);
                            }
                        }
                    } else {
                        refNode = this.curOpNode.findChildNode(refId);
                        if (refNode != null) {
                            if (refNode.getNodeName().equals("field") || nodeName.equals("secureField")) {
                                this.addDataNode(includeNode, refNode, access);
                            } else if (refNode.getNodeName().equals("iColl")) {
                                this.processICollNode(includeNode, refNode, access);
                            } else if (refNode.getNodeName().equals("kColl")) {
                                this.processDataCollectionNode(includeNode, refNode, access);
                            }
                        }
                    }
                } else if (nodeName.equals("iColl")) {
                    this.processICollNode(includeNode, aDataNode, access);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDataNode(XMLNode includeNode, XMLNode aDataNode, String access) {
        String id = aDataNode.getAttrValue("id");
        if (this.dataDictionaryNode.findChildNode(id) == null) {
            String label;
            XMLNode node = new XMLNode();
            node.setNodeName("dataElement");
            node.setAttrValue("type", aDataNode.getNodeName());
            node.setAttrValue("id", aDataNode.getAttrValue("id"));
            node.setAttrValue("label", aDataNode.getAttrValue("id"));
            if ("secureField".equals(aDataNode.getNodeName())) {
                node.setAttrValue("isSecureField", "true");
            }
            if ((label = this.getNodeComment(aDataNode)) != null) {
                node.setAttrValue("label", label);
            }
            if (aDataNode.getAttrValue("value") != null) {
                node.setAttrValue("defaultValue", aDataNode.getAttrValue("value"));
            }
            if (this.dataGroupNode != null) {
                this.dataGroupNode.add(node);
            } else {
                this.dataDictionaryNode.add(node);
            }
            if (includeNode == null) {
                node.setAttrValue("access", access);
            }
        }
        if (includeNode != null) {
            XMLNode aNode = new XMLNode();
            aNode.setNodeName("refData");
            aNode.setAttrValue("refId", aDataNode.getAttrValue("id"));
            aNode.setAttrValue("access", access);
            if (aDataNode.getAttrValue("value") != null) {
                aNode.setAttrValue("defaultValue", aDataNode.getAttrValue("value"));
            }
            includeNode.add(aNode);
        }
    }

    private String getNodeComment(XMLNode node) {
        Vector childs = node.getParent().getChilds();
        int idx = childs.indexOf(node);
        if (idx == childs.size() - 1) {
            return null;
        }
        XMLNode aNode = (XMLNode)childs.elementAt(idx + 1);
        if ("#comment".equals(aNode.getNodeName())) {
            return aNode.getAttrValue("value");
        }
        return null;
    }

    private String getNodePrefComment(XMLNode node) {
        Vector childs = node.getParent().getChilds();
        int idx = childs.indexOf(node);
        if (idx == 0) {
            return null;
        }
        String comment = "";
        int i = idx - 1;
        while (i >= 0) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            if (!"#comment".equals(aNode.getNodeName())) break;
            comment = String.valueOf(comment) + aNode.getAttrValue("value") + "\r\n";
            --i;
        }
        return comment;
    }

    private void processICollNode(XMLNode includeNode, XMLNode iCollNode, String access) {
        String id = iCollNode.getAttrValue("id");
        if (this.dataDictionaryNode.findChildNode(id) != null) {
            return;
        }
        XMLNode iNode = new XMLNode();
        iNode.setNodeName("dataCollection");
        iNode.setAttrValue("id", id);
        iNode.setAttrValue("label", id);
        iNode.setAttrValue("access", access);
        if (includeNode == null) {
            this.dataDictionaryNode.add(iNode);
        } else if ("dataCollection".equals(includeNode.getNodeName())) {
            includeNode.add(iNode);
        } else {
            XMLNode aNode = new XMLNode();
            aNode.setNodeName("refData");
            aNode.setAttrValue("refId", id);
            aNode.setAttrValue("access", access);
            includeNode.add(aNode);
            this.dataDictionaryNode.add(iNode);
        }
        this.processDataCollectionNode(iNode, iCollNode, access);
    }

    private void saveXMLFile(String fileName, XMLNode node) {
        try {
            StringBuffer strBuf = new StringBuffer();
            node.toXMLContent(0, strBuf);
            FileWriter fw = new FileWriter(fileName);
            fw.write(strBuf.toString());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private EditorProfile openEditorProfileFile(String fileName) {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            EditorProfile profile = (EditorProfile)xmlLoader.loadXMLFile(fileName);
            return profile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void showMessage(String msg) {
        System.out.println(msg);
        if (this.messageBuffer != null) {
            this.messageBuffer.append(msg);
            this.messageBuffer.append("\r\n");
        }
    }

    public String getMessages() {
        return this.messageBuffer.toString();
    }

    public void reportProgress(String msg) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.subTask(msg);
    }

    public void reportProgress(String msg, int worked) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.subTask(msg);
        this.monitor.worked(worked);
    }

    public void beginWork(String msg, int works) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.beginTask(msg, works);
    }

    private void mergeSettingsFile(XMLNode sNode) {
        XMLNode linkNode = sNode.findChildNode("linkFiles");
        if (linkNode == null) {
            return;
        }
        sNode.remove(linkNode);
        int i = 0;
        while (i < linkNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)linkNode.getChilds().elementAt(i);
            if ("field".equals(aNode.getNodeName())) {
                String settingsFile = String.valueOf(this.rootPath) + "/" + aNode.getAttrValue("value");
                try {
                    XMLNode opDsNode;
                    XMLNode settingsFileNode = (XMLNode)this.xmlLoader.loadXMLFile(settingsFile);
                    XMLNode stNode = settingsFileNode.findChildNode("settings");
                    XMLNode tgsNode = stNode.findChildNode("kColl", "tags");
                    if (tgsNode != null) {
                        XMLNode servicesTgsNode;
                        XMLNode opStepTgsNode;
                        XMLNode operTgsNode = tgsNode.findChildNode("operations");
                        if (operTgsNode != null) {
                            this.copyChildNodes(operTgsNode, this.operTagsNode);
                        }
                        if ((opStepTgsNode = tgsNode.findChildNode("opSteps")) != null) {
                            this.copyChildNodes(opStepTgsNode, this.opStepTagsNode);
                        }
                        if ((servicesTgsNode = tgsNode.findChildNode("services")) != null) {
                            this.copyChildNodes(servicesTgsNode, this.servicesTagsNode);
                        }
                    }
                    if ((opDsNode = stNode.findChildNode("files")) != null) {
                        opDsNode = opDsNode.findChildNode("operations");
                    }
                    if (opDsNode != null) {
                        this.copyChildNodes(opDsNode, this.opDefsNode);
                    }
                    this.mergeSettingsFile(stNode);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            ++i;
        }
    }

    private void copyChildNodes(XMLNode srcNode, XMLNode dstNode) {
        int i = 0;
        while (i < srcNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)srcNode.getChilds().elementAt(i);
            dstNode.add(aNode);
            ++i;
        }
    }

    private void mergeFile(XMLNode orgNode, XMLNode node) {
        XMLNode linkNode = node.findChildNode("linkFiles");
        if (linkNode == null) {
            return;
        }
        node.remove(linkNode);
        int i = 0;
        while (i < linkNode.getChilds().size()) {
            XMLNode aNode = (XMLNode)linkNode.getChilds().elementAt(i);
            if ("field".equals(aNode.getNodeName())) {
                String fileName = aNode.getAttrValue("value");
                if (fileName == null) {
                    fileName = aNode.getAttrValue("fileName");
                }
                String settingsFile = String.valueOf(this.rootPath) + "/" + fileName;
                try {
                    XMLNode settingsFileNode = (XMLNode)this.xmlLoader.loadXMLFile(settingsFile);
                    int k = 0;
                    while (k < settingsFileNode.getChilds().size()) {
                        XMLNode cNode = (XMLNode)settingsFileNode.getChilds().elementAt(k);
                        if (!"linkFiles".equals(cNode.getNodeName())) {
                            orgNode.add(cNode);
                        }
                        ++k;
                    }
                    this.mergeFile(orgNode, settingsFileNode);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
            ++i;
        }
    }
}

