/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.test.visualeditor;

import com.ecc.ide.test.visualeditor.Line;
import com.ecc.ide.test.visualeditor.VisualComponent;
import java.awt.Point;
import java.util.Vector;
import org.eclipse.swt.graphics.GC;

public class ComponentLink {
    private VisualComponent startComponent;
    private VisualComponent endComponent;
    private String label;
    private Vector points = new Vector(10);
    Vector components;
    Vector links;

    public ComponentLink(VisualComponent sc, VisualComponent ec, String label) {
        this.startComponent = sc;
        this.endComponent = ec;
        this.label = label;
    }

    public void addPoints(Point p) {
        this.points.add(p);
    }

    public void paintControl(GC gc) {
        if (this.points.size() == 0) {
            return;
        }
        Point s = (Point)this.points.elementAt(0);
        int i = 1;
        while (i < this.points.size()) {
            Point e = (Point)this.points.elementAt(i);
            gc.drawLine(s.x, s.y, e.x, e.y);
            s = e;
            ++i;
        }
        gc.fillRectangle(s.x - 2, s.y - 2, 5, 5);
    }

    public void calLink(Vector components, Vector links) {
        this.components = components;
        this.links = links;
        Line l1 = new Line(this.startComponent.x, this.startComponent.y + this.startComponent.height, this.startComponent.x + this.startComponent.width, this.startComponent.y + this.startComponent.height);
        Line l2 = new Line(this.endComponent.x, this.endComponent.y, this.endComponent.x + this.endComponent.width, this.endComponent.y);
        Line frLine = this.getFreeLine(l1, l2, 1);
        if (frLine != null) {
            Point p1 = new Point(frLine.x0, frLine.y0);
            this.points.add(p1);
            Point p2 = new Point(frLine.x1, frLine.y1);
            this.points.add(p2);
            return;
        }
        l1 = new Line(this.startComponent.x + this.startComponent.width, this.startComponent.y, this.startComponent.x + this.startComponent.width, this.startComponent.y + this.startComponent.height);
        l2 = new Line(this.endComponent.x, this.endComponent.y, this.endComponent.x, this.endComponent.y + this.endComponent.height);
        frLine = this.getFreeLine(l1, l2, 0);
        if (frLine != null) {
            Point p1 = new Point(frLine.x0, frLine.y0);
            this.points.add(p1);
            Point p2 = new Point(frLine.x1, frLine.y1);
            this.points.add(p2);
            return;
        }
    }

    public Line getFreeLine(Line l1, Line l2, int direction) {
        if (direction == 0) {
            Line crosLine = l1.getCrossLine(l2);
            if (crosLine == null) {
                return null;
            }
            int y0 = (crosLine.y1 + crosLine.y0) / 2;
            return this.getFreeLine(l1.x0, y0, l2.x0, y0, direction);
        }
        Line crosLine = l1.getCrossLine(l2);
        if (crosLine == null) {
            return null;
        }
        int x0 = (crosLine.x1 + crosLine.x0) / 2;
        return this.getFreeLine(x0, l1.y0, x0, l2.y0, direction);
    }

    public Line getFreeLine(int x0, int y0, int x1, int y1, int direction) {
        int yy1;
        int yy0;
        if (direction == 0) {
            int xx1;
            int xx0;
            int minX = x1;
            if (x0 > x1) {
                xx0 = x1;
                xx1 = x0;
                minX = x0;
            } else {
                xx0 = x0;
                xx1 = x1;
            }
            int i = 0;
            while (i < this.components.size()) {
                VisualComponent comp = (VisualComponent)this.components.elementAt(i);
                if (comp.y <= y0 && comp.y + comp.height > y0 && comp.x <= xx0 && comp.x + comp.width > xx0) {
                    if (x0 < x1 && minX > comp.x) {
                        minX = comp.x;
                    } else if (x0 > x1 && minX < comp.x + comp.width) {
                        minX = comp.x + comp.width;
                    }
                }
                ++i;
            }
            return new Line(x0, y0, minX, y0);
        }
        int minY = y1;
        if (y0 > y1) {
            yy0 = y1;
            yy1 = y0;
            minY = x0;
        } else {
            yy0 = y0;
            yy1 = y1;
        }
        int i = 0;
        while (i < this.components.size()) {
            VisualComponent comp = (VisualComponent)this.components.elementAt(i);
            if (comp.x <= x0 && comp.x + comp.width > x0 && comp.y <= yy0 && comp.y + comp.height > yy0) {
                if (y0 < y1 && minY > comp.y) {
                    minY = comp.y;
                } else if (y0 > y1 && minY < comp.y + comp.height) {
                    minY = comp.y + comp.height;
                }
            }
            ++i;
        }
        return new Line(x0, y0, x0, minY);
    }

    public String toString() {
        return "Link[" + this.label + "] from " + this.startComponent.toString() + " to " + this.endComponent.toString();
    }
}

