/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.test.visualeditor;

import com.ecc.ide.test.visualeditor.ComponentLink;
import com.ecc.ide.test.visualeditor.VisualComponent;
import java.util.Vector;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VisualContentPanel
extends Composite {
    int gridSize = 15;
    private Vector components = new Vector(10);
    private Vector links = new Vector(10);

    public VisualContentPanel(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                VisualContentPanel.this.paintControlImp(e);
            }
        });
    }

    public void addComponent(VisualComponent component) {
        this.components.addElement(component);
        this.redraw();
    }

    public void addLink(ComponentLink link) {
        this.links.add(link);
        this.redraw();
    }

    public void paintControlImp(PaintEvent event) {
        Point size = this.getSize();
        Image image = new Image((Device)Display.getDefault(), size.x, size.y);
        GC gc = new GC((Drawable)image);
        Color bkColor = event.gc.getBackground();
        gc.setBackground(this.getDisplay().getSystemColor(1));
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.setForeground(this.getDisplay().getSystemColor(15));
        int i = 0;
        while (i < size.y) {
            gc.drawLine(0, i, size.x, i);
            i += this.gridSize;
        }
        int j = 0;
        while (j < size.x) {
            gc.drawLine(j, 0, j, size.y);
            j += this.gridSize;
        }
        gc.setForeground(this.getDisplay().getSystemColor(2));
        i = 0;
        while (i < this.components.size()) {
            VisualComponent component = (VisualComponent)this.components.elementAt(i);
            component.paintControl(gc);
            ++i;
        }
        gc.setForeground(this.getDisplay().getSystemColor(13));
        gc.setBackground(this.getDisplay().getSystemColor(13));
        i = 0;
        while (i < this.links.size()) {
            ComponentLink link = (ComponentLink)this.links.elementAt(i);
            link.paintControl(gc);
            ++i;
        }
        event.gc.drawImage(image, 0, 0);
        image.dispose();
        gc.dispose();
    }

    public void doLink() {
        int i = 0;
        while (i < this.links.size()) {
            ComponentLink link = (ComponentLink)this.links.elementAt(i);
            link.calLink(this.components, this.links);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public static void main(String[] argv) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Test Visual component Link ");
        VisualContentPanel test = new VisualContentPanel((Composite)shell, 2048);
        VisualComponent comp1 = new VisualComponent(20, 30, 100, 60, "comp1");
        test.addComponent(comp1);
        VisualComponent comp2 = new VisualComponent(20, 180, 150, 80, "comp2");
        test.addComponent(comp2);
        VisualComponent comp3 = new VisualComponent(160, 30, 100, 60, "comp3");
        test.addComponent(comp3);
        VisualComponent comp4 = new VisualComponent(220, 180, 150, 80, "comp4");
        test.addComponent(comp4);
        ComponentLink link1 = new ComponentLink(comp1, comp2, "c1-c2");
        test.addLink(link1);
        ComponentLink link2 = new ComponentLink(comp1, comp3, "c1-c3");
        test.addLink(link2);
        ComponentLink link3 = new ComponentLink(comp2, comp4, "c2-c4");
        test.addLink(link3);
        ComponentLink link4 = new ComponentLink(comp1, comp4, "c1-c4");
        test.addLink(link4);
        ComponentLink link5 = new ComponentLink(comp3, comp4, "c3-c4");
        test.addLink(link5);
        test.doLink();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

