/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.validater;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.validater.ValidateError;
import com.ecc.ide.validater.Validater;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;

public class MVCValidater
extends Validater {
    public void validateMVCViewReference() throws ValidateError {
        XMLNode modelNode = this.loadXMLContent(this.file);
        if ("2.1".equals(modelNode.getAttrValue("version"))) {
            return;
        }
        ValidateError error = new ValidateError();
        List viewNodes = this.findRequiredNodes(modelNode, "view");
        viewNodes.addAll(this.findRequiredNodes(modelNode, "jspWizzardView"));
        int i = 0;
        while (i < viewNodes.size()) {
            int idx;
            XMLNode node = (XMLNode)viewNodes.get(i);
            String jspFilePath = node.getAttrValue("designFile");
            if (jspFilePath == null || jspFilePath.trim().length() == 0) {
                jspFilePath = node.getAttrValue("jspFile");
            }
            if (jspFilePath != null && (idx = jspFilePath.indexOf(63)) > -1) {
                jspFilePath = jspFilePath.substring(0, idx);
            }
            IFolder folder = (IFolder)this.file.getParent();
            while (!folder.getParent().getName().equals("mvcs")) {
                folder = (IFolder)folder.getParent();
            }
            if (folder.findMember(jspFilePath) == null) {
                error.addValidateMsg(String.valueOf(jspFilePath) + " is not exists!");
            }
            ++i;
        }
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }

    public void validateMVCFlowReference() throws ValidateError {
        XMLNode modelNode = this.loadXMLContent(this.file);
        if ("2.1".equals(modelNode.getAttrValue("version"))) {
            return;
        }
        ValidateError error = new ValidateError();
        List flowNodes = this.findRequiredNodes(modelNode, "flow");
        int i = 0;
        while (i < flowNodes.size()) {
            XMLNode node = (XMLNode)flowNodes.get(i);
            String bizFilePath = node.getAttrValue("fileName");
            String bizGrp = IDEContent.getBizGroupIdFromMVCFile(this.project, this.file.getProjectRelativePath().toString());
            IFile bizFile = (IFile)this.project.findMember("designFiles/bizs/" + bizGrp + "/" + bizFilePath);
            if (bizFile == null) {
                error.addValidateMsg(String.valueOf(bizFilePath) + " is not exists!");
            } else {
                XMLElementObjectMaker maker = new XMLElementObjectMaker();
                XMLLoader loader = new XMLLoader();
                loader.addObjectMaker((ObjectMaker)maker);
                try {
                    String opRefName;
                    XMLNode opNode;
                    String filePath = bizFile.getLocation().toOSString();
                    XMLNode bizNode = (XMLNode)loader.loadXMLFile(filePath);
                    String bizName = bizNode.getAttrValue("trxCode");
                    String bizRefName = node.getAttrValue("id");
                    if (!bizRefName.equals(bizName)) {
                        error.addValidateMsg("BIZ[" + bizRefName + "] is not defined!");
                    } else if (!filePath.endsWith(".mtx") && (opNode = bizNode.findChildNodeWithAttrValue("operation", "id", opRefName = node.getAttrValue("refId"))) == null) {
                        error.addValidateMsg("Operation[" + opRefName + "] is not defined!");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }

    public void disableValidateMVCModelUpdater() throws ValidateError {
        XMLNode modelNode = this.loadXMLContent(this.file);
        if ("2.1".equals(modelNode.getAttrValue("version"))) {
            return;
        }
        ValidateError error = new ValidateError();
        List updaterNodes = this.findRequiredNodes(modelNode, "modelUpdater");
        int i = 0;
        while (i < updaterNodes.size()) {
            XMLNode node = (XMLNode)updaterNodes.get(i);
            XMLNode datasNode = node.findChild("datas");
            XMLNode referenceNode = node.findChild("reference");
            XMLNode bizDatasNode = null;
            XMLNode flowNode = modelNode.findChildNodeNamed("flow", referenceNode.getAttrValue("dest"));
            String bizFilePath = flowNode.getAttrValue("fileName");
            IFile bizFile = (IFile)this.project.findMember(bizFilePath);
            if (bizFile != null) {
                XMLElementObjectMaker maker = new XMLElementObjectMaker();
                XMLLoader loader = new XMLLoader();
                loader.addObjectMaker((ObjectMaker)maker);
                try {
                    String filePath = bizFile.getLocation().toOSString();
                    XMLNode bizNode = (XMLNode)loader.loadXMLFile(filePath);
                    bizDatasNode = bizNode.findChild("datas");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (bizDatasNode == null) {
                error.addValidateMsg("Datas is not defined in flow!");
            } else {
                List refDataNodes = this.findRequiredNodes(datasNode, "refData");
                int j = 0;
                while (j < refDataNodes.size()) {
                    XMLNode bizrefDataNode;
                    XMLNode refDataNode = (XMLNode)refDataNodes.get(j);
                    String refDataId = refDataNode.getAttrValue("srcDataName");
                    if (refDataId == null) {
                        refDataId = refDataNode.getAttrValue("refId");
                    }
                    if ((bizrefDataNode = bizDatasNode.findChildNodeWithAttrValue("refData", "refId", refDataId)) == null) {
                        error.addValidateMsg("Data[" + refDataId + "] is not defined!");
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }

    public void validateMVCWizzardReference() throws ValidateError {
        XMLNode modelNode = this.loadXMLContent(this.file);
        if ("2.1".equals(modelNode.getAttrValue("version"))) {
            return;
        }
        ValidateError error = new ValidateError();
        String type = null;
        String actionName = null;
        String wizzardName = null;
        XMLNode actionNode = null;
        int i = 0;
        while (i < modelNode.getChilds().size()) {
            XMLNode childNode = (XMLNode)modelNode.getChilds().elementAt(i);
            if (!childNode.getNodeName().equals("#text")) {
                if (childNode.getNodeName().equals("action")) {
                    type = childNode.getAttrValue("type");
                    actionName = childNode.getAttrValue("id");
                    actionNode = childNode;
                }
                if (actionNode != null) {
                    int j = 0;
                    while (j < actionNode.getChilds().size()) {
                        XMLNode actionChildNode = (XMLNode)actionNode.getChilds().elementAt(j);
                        if (!actionChildNode.getNodeName().equals("#text") && actionChildNode.getNodeName().equals("reference")) {
                            int k = 0;
                            while (k < modelNode.getChilds().size()) {
                                XMLNode wizzardChildNode = (XMLNode)modelNode.getChilds().elementAt(k);
                                if (!wizzardChildNode.getNodeName().equals("#text") && wizzardChildNode.getNodeName().equals("jspWizzardView")) {
                                    wizzardName = wizzardChildNode.getAttrValue("name");
                                    if (actionChildNode.getAttrValue("dest").equals(wizzardName) && (type == null || !type.equals("wizzard"))) {
                                        error.addValidateMsg("Action\u3000" + actionName + "\u3000must be wizzard!");
                                        break;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }
}

