/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.validater;

import com.ecc.ide.ant.ValidateTask;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.validater.ValidateError;
import com.ecc.ide.validater.Validater;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class NodeSettingsValidater
extends Validater {
    private XMLNode serviceDefineNode = null;

    public void validateRootNode() throws ValidateError {
        XMLNode settingsNode = this.loadXMLContent(this.file);
        ValidateError error = new ValidateError();
        XMLNode rootNode = settingsNode.findChild("root");
        XMLNode datasNode = rootNode.findChild("datas");
        this.checkoutDataInDict(datasNode, error);
        XMLNode serviceNode = rootNode.findChild("refServices");
        this.checkoutServiceDefine(serviceNode, error);
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }

    public void validateChannelSettingsNode() throws ValidateError {
        XMLNode settingsNode = this.loadXMLContent(this.file);
        ValidateError error = new ValidateError();
        XMLNode channelNode = settingsNode.findChild("channelSettings");
        List channelNodes = this.findRequiredNodes(channelNode, "channel");
        int i = 0;
        while (i < channelNodes.size()) {
            XMLNode datasNode = channelNode.findChild("sessionDatas");
            this.checkoutDataInDict(datasNode, error);
            XMLNode serviceNode = channelNode.findChild("refServices");
            this.checkoutServiceDefine(serviceNode, error);
            ++i;
        }
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }

    public void validateCommonDataNode() throws ValidateError {
        XMLNode settingsNode = this.loadXMLContent(this.file);
        ValidateError error = new ValidateError();
        XMLNode commonDataNode = settingsNode.findChild("CommonData");
        this.checkoutDataInDict(commonDataNode, error);
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }

    private void checkoutServiceDefine(XMLNode serviceNode, ValidateError error) throws ValidateError {
        if (this.serviceDefineNode == null) {
            String svcFilePath = this.file.getLocation().toOSString();
            svcFilePath = String.valueOf(svcFilePath.substring(0, svcFilePath.indexOf(this.file.getName()))) + ValidateTask.services;
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            try {
                this.serviceDefineNode = (XMLNode)xmlLoader.loadXMLFile(svcFilePath);
            }
            catch (Exception e) {
                error.addValidateMsg("Exception in Validater:" + e);
                return;
            }
        }
        int i = 0;
        while (i < serviceNode.getChilds().size()) {
            String refId;
            XMLNode service;
            XMLNode refServiceNode = (XMLNode)serviceNode.getChilds().elementAt(i);
            if ("refService".equals(refServiceNode.getNodeName()) && (service = this.serviceDefineNode.findChildNode(refId = refServiceNode.getAttrValue("id"))) == null) {
                error.addValidateMsg("Service[" + refId + "] is not defined in " + ValidateTask.services + "!");
            }
            ++i;
        }
    }

    public void validateServerFlow() throws ValidateError {
        String path = this.file.getParent().getProjectRelativePath().toOSString();
        IFile serverFlowFile = this.project.getFile(String.valueOf(path) + "\\" + ValidateTask.serverFlow);
        XMLNode flowDefsNode = this.loadOtherXMLContent(serverFlowFile);
        ValidateError error = new ValidateError();
        int i = 0;
        while (i < flowDefsNode.getChilds().size()) {
            XMLNode flowNode = (XMLNode)flowDefsNode.getChilds().elementAt(i);
            if ("flow".equals(flowNode.getNodeName())) {
                this.checkoutActionInProfile(flowNode, error);
            }
            ++i;
        }
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }

    public void validateServicesNode() throws ValidateError {
        String path = this.file.getParent().getProjectRelativePath().toOSString();
        IFile servicesFile = this.project.getFile(String.valueOf(path) + "\\" + ValidateTask.services);
        XMLNode servicesNode = this.loadOtherXMLContent(servicesFile);
        ValidateError error = new ValidateError();
        this.checkoutServiceInProfile(servicesNode, error);
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }

    public void validateFormatsNode() throws ValidateError {
        String path = this.file.getParent().getProjectRelativePath().toOSString();
        IFile formatsFile = this.project.getFile(String.valueOf(path) + "\\" + ValidateTask.formats);
        XMLNode formatsNode = this.loadOtherXMLContent(formatsFile);
        ValidateError error = new ValidateError();
        int i = 0;
        while (i < formatsNode.getChilds().size()) {
            XMLNode fmtNode = (XMLNode)formatsNode.getChilds().elementAt(i);
            if ("format".equals(fmtNode.getNodeName())) {
                this.checkoutFormatInProfile(fmtNode, error);
            }
            ++i;
        }
        if (!error.getValidateMsgList().isEmpty()) {
            throw error;
        }
    }

    private XMLNode loadOtherXMLContent(IFile file) {
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        try {
            XMLNode xmlNode = (XMLNode)xmlLoader.loadXMLContent(file.getContents());
            return xmlNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

