/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.validater;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.validater.ValidateError;
import com.ecc.ide.validater.Validater;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;

public class RunValidate {
    private static String prefix = "validate";

    public static void main(String[] args) {
        try {
            RunValidate.validateFile(null, null, Class.forName("com.ecc.ide.validater.TestValidater"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean validateFile(IFile file, IProject project, Class validateClass) {
        return RunValidate.validateFile(file, project, validateClass, false);
    }

    public static boolean validateFile(IFile file, IProject project, Class validateClass, boolean holdMark) {
        Object obj;
        block11: {
            if (validateClass == null) {
                return false;
            }
            obj = validateClass.newInstance();
            if (obj instanceof Validater) break block11;
            return false;
        }
        try {
            Validater validater = (Validater)obj;
            validater.setIFile(file);
            validater.setIProject(project);
            IFile targetFile = null;
            if (targetFile == null) {
                targetFile = file;
            }
            if (!holdMark) {
                targetFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
            boolean validateSucceed = true;
            Method[] methods = validateClass.getMethods();
            int i = 0;
            while (i < methods.length) {
                block12: {
                    Method method = methods[i];
                    String methodName = method.getName();
                    if (methodName.startsWith(prefix)) {
                        try {
                            method.invoke((Object)validater, new Object[0]);
                        }
                        catch (Exception e) {
                            Throwable te;
                            if (!(e instanceof InvocationTargetException) || !((te = ((InvocationTargetException)e).getTargetException()) instanceof ValidateError)) break block12;
                            String msg = ((ValidateError)te).getValidateMsg();
                            if (msg != null) {
                                ((ValidateError)te).addValidateMsg(msg);
                            }
                            List msgList = ((ValidateError)te).getValidateMsgList();
                            RunValidate.addMark(targetFile, msgList);
                            validateSucceed = false;
                        }
                    }
                }
                ++i;
            }
            return validateSucceed;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void addMark(IFile file, List msgList) {
        try {
            if (file == null) {
                return;
            }
            int i = 0;
            while (i < msgList.size()) {
                IMarker m = file.createMarker("org.eclipse.core.resources.problemmarker");
                m.setAttribute("lineNumber", 1);
                m.setAttribute("message", (Object)((String)msgList.get(i)));
                m.setAttribute("priority", 2);
                m.setAttribute("severity", 2);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String checkFileExist(Validater validater, String fileName) throws ValidateError {
        return "";
    }

    public static String checkDefined(Validater validater, XMLNode fileNode, String nodeName) throws ValidateError {
        return "";
    }

    public static String checkDataDict(Validater validater, String dataName) throws ValidateError {
        return "";
    }

    public static String checkDataAccess(Validater validater, String dataName) throws ValidateError {
        return "";
    }

    public static String checkProfile(Validater validater, XMLNode compNode, EditorProfile profile) throws ValidateError {
        return "";
    }
}

