/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.validater;

import com.ecc.ide.base.IDEContent;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.editorprofile.ElementAttribute;
import com.ecc.ide.editorprofile.ElementCatalog;
import com.ecc.ide.editorprofile.ElementChild;
import com.ecc.ide.module.ModuleUtility;
import com.ecc.ide.validater.ValidateError;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;

public class Validater {
    protected IProject project;
    protected IFile file;
    private XMLNode xmlNode;
    private XMLNode dataDictionary;
    private XMLNode pkgTypeNode;
    protected EditorProfile actionFlowProfile;
    protected EditorProfile serviceProfile;

    public void setIProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setIFile(IFile file) {
        this.file = file;
    }

    public IFile getFile() {
        return this.file;
    }

    protected XMLNode loadXMLContent(IFile file) {
        if (this.xmlNode != null) {
            return this.xmlNode;
        }
        XMLLoader xmlLoader = new XMLLoader();
        xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
        try {
            this.xmlNode = (XMLNode)xmlLoader.loadXMLContent(file.getContents());
            return this.xmlNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected List findRequiredNodes(XMLNode parentNode, String requiredNodeName) {
        ArrayList<XMLNode> requiredNodes = new ArrayList<XMLNode>();
        int i = 0;
        while (i < parentNode.getChilds().size()) {
            XMLNode node = (XMLNode)parentNode.getChilds().elementAt(i);
            if (requiredNodeName.equals(node.getNodeName())) {
                requiredNodes.add(node);
            }
            ++i;
        }
        return requiredNodes;
    }

    public boolean isDefinedInProfile(Element profileElement, String id) {
        int i = 0;
        while (i < profileElement.getChilds().size()) {
            ElementChild eChild = (ElementChild)profileElement.getChilds().elementAt(i);
            if (id.equals(eChild.getChildElementId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void checkoutDataInDict(XMLNode datasNode, ValidateError error) {
        try {
            if (this.dataDictionary == null) {
                this.dataDictionary = IDEContent.getSettingNode(this.project, 0);
            }
            int i = 0;
            while (i < datasNode.getChilds().size()) {
                XMLNode refDataNode = (XMLNode)datasNode.getChilds().elementAt(i);
                if ("dataGroup".equals(refDataNode.getNodeName())) {
                    this.checkoutDataInDict(refDataNode, error);
                }
                if ("refData".equals(refDataNode.getNodeName()) || "refColl".equals(refDataNode.getNodeName())) {
                    String refId = refDataNode.getAttrValue("refId");
                    XMLNode dataElement = this.dataDictionary.findChildNodeWithAttrValue("dataElement", "id", refId);
                    XMLNode dataCollection = this.dataDictionary.findChildNodeWithAttrValue("dataCollection", "id", refId);
                    if (dataElement == null && dataCollection == null) {
                        String errorMsg = "";
                        if ("input".equals(datasNode.getNodeName())) {
                            errorMsg = "\u4e1a\u52a1\u6784\u4ef6\u8bbf\u95ee\u63a5\u53e3(INPUT)\u4e2d\u7684";
                        }
                        if ("output".equals(datasNode.getNodeName())) {
                            errorMsg = "\u4e1a\u52a1\u6784\u4ef6\u8bbf\u95ee\u63a5\u53e3(INPUT)\u4e2d\u7684";
                        }
                        if ("datas".equals(datasNode.getNodeName())) {
                            errorMsg = "\u4e1a\u52a1\u6784\u4ef6\u7684\u4ea4\u6613";
                        }
                        error.addValidateMsg(String.valueOf(errorMsg) + "\u6570\u636e[" + refId + "] \u5728\u6570\u636e\u5b57\u5178\u4e2d\u6ca1\u6709\u5b9a\u4e49!");
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            error.addValidateMsg("Exception in Validater:" + e);
        }
    }

    protected void checkAttrs(XMLNode node, Element element, ValidateError error) {
        if (element == null) {
            return;
        }
        if (element.getAttributes() == null) {
            return;
        }
        int i = 0;
        while (i < element.getAttributes().size()) {
            String value;
            ElementAttribute attr = (ElementAttribute)element.getAttributes().get(i);
            if (attr.getMustSet() && ((value = node.getAttrValue(attr.getAttrID())) == null || value.length() == 0)) {
                try {
                    if ("flow".equals(node.getParent().getNodeName())) {
                        String name = node.getParent().getParent().getAttrValue("name");
                        error.addValidateMsg("\u4e1a\u52a1\u903b\u8f91[" + name + "]\u4e2d\u7684" + element.getLabel() + "[" + node.getAttrValue("name") + "]' attr[" + attr.getAttrName() + "] must set value!");
                    } else {
                        error.addValidateMsg(String.valueOf(node.getNodeName()) + "' attr[" + attr.getAttrName() + "] must set value!");
                    }
                }
                catch (Exception e) {
                    error.addValidateMsg(String.valueOf(node.getNodeName()) + "' attr[" + attr.getAttrName() + "] must set value!");
                }
            }
            ++i;
        }
    }

    protected void checkoutActionInProfile(XMLNode flowNode, ValidateError error) {
        try {
            if (this.actionFlowProfile == null) {
                this.actionFlowProfile = ModuleUtility.getActionFlowProfile(this.project);
            }
            ElementCatalog rootCatalog = this.actionFlowProfile.getElementCatalog("Flow");
            Element flowElement = rootCatalog.getElement("flow");
            int j = 0;
            while (j < flowNode.getChilds().size()) {
                XMLNode actionNode = (XMLNode)flowNode.getChilds().elementAt(j);
                String actionName = actionNode.getNodeName();
                if (!("#text".equals(actionNode.getNodeName()) || "document".equals(actionNode.getNodeName()) || "attributes".equals(actionNode.getNodeName()) || this.isDefinedInProfile(flowElement, actionName))) {
                    error.addValidateMsg("Action[" + actionName + "] is not defined in Profile!");
                }
                ++j;
            }
        }
        catch (Exception e) {
            error.addValidateMsg("Exception in Validater:" + e);
        }
    }

    protected void checkoutServiceInProfile(XMLNode servicesNode, ValidateError error) {
        try {
            if (this.serviceProfile == null) {
                this.serviceProfile = ModuleUtility.getServiceProfile(this.project);
            }
            Element serviceElement = this.serviceProfile.getElement("Services");
            int i = 0;
            while (i < servicesNode.getChilds().size()) {
                XMLNode svcNode = (XMLNode)servicesNode.getChilds().elementAt(i);
                String svcName = svcNode.getNodeName();
                if (!"#text".equals(svcNode.getNodeName()) && !this.isDefinedInProfile(serviceElement, svcName)) {
                    error.addValidateMsg("Service[" + svcName + "] is not defined in Profile!");
                }
                ++i;
            }
        }
        catch (Exception e) {
            error.addValidateMsg("Exception in Validater:" + e);
        }
    }

    protected void checkoutFormatInProfile(XMLNode formatNode, ValidateError error) {
        try {
            XMLNode fmtDataNode;
            String packageType;
            XMLNode pkgNode;
            if (this.pkgTypeNode == null) {
                this.pkgTypeNode = ModuleUtility.getPackageTypeNode(this.project);
            }
            if ((pkgNode = this.pkgTypeNode.findChildNodeWithAttrValue("package", "id", packageType = (fmtDataNode = formatNode.getChild("datas")).getAttrValue("packageType"))) == null) {
                error.addValidateMsg("FormatType[" + packageType + "] is not defined in Profile!");
            } else {
                this.checkoutDataInDict(fmtDataNode, error);
            }
        }
        catch (Exception e) {
            error.addValidateMsg("Exception in Validater:" + e);
        }
    }
}

