/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.visualeditor;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class TabItemWrapper
extends VisualElementWrapper {
    private int titleHeight = 25;
    private boolean isShowTab = true;

    public TabItemWrapper() {
    }

    public TabItemWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        Color bkColor = gc.getBackground();
        gc.setForeground(Display.getDefault().getSystemColor(16));
        gc.drawRectangle(x, y, this.width, this.height);
        if (this.getAttrValue("label") != null) {
            gc.setForeground(Display.getDefault().getSystemColor(2));
            gc.drawText(this.getAttrValue("label"), x + 3, y + 3);
        }
        if (this.isShowTab) {
            gc.setForeground(Display.getDefault().getSystemColor(1));
            gc.drawLine(x + 1, y + this.height, x + this.width - 1, y + this.height);
        }
        Point size = this.getParentWrapper().getSize();
        size.x -= 4;
        size.y = size.y - this.titleHeight - 4;
        gc.setClipping(parentClipRect);
        if (!this.isShowTab) {
            return;
        }
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            wrapper.setSize(size.x, size.y);
            wrapper.paintControl(gc, x, y);
            ++i;
        }
    }

    public void setIsShow(boolean value) {
        this.isShow = true;
    }

    public void setIsActivate(boolean value) {
        this.isShowTab = value;
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            wrapper.setIsShow(value);
            ++i;
        }
    }

    public void addChild(VisualElementWrapper child) {
        Rectangle rect0 = this.getRectangle();
        Rectangle rect = this.getParentWrapper().getRectangle();
        int xOff = rect.x + 2;
        int yOff = rect0.y + this.titleHeight + 2;
        child.setResizable(false);
        child.setMoveable(false);
        child.setIsShow(this.isShowTab);
        child.setBounds(xOff, yOff, rect.width - 2, rect.height - this.titleHeight - 2);
        this.childs.addElement(child);
    }
}

