/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.visualeditor;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.TabItemWrapper;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class TabPanelWrapper
extends VisualElementWrapper {
    private int titleHeight = 25;
    private VisualElementWrapper activateWrapper;

    public TabPanelWrapper() {
    }

    public TabPanelWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        this.layOut();
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        Color bkColor = gc.getBackground();
        gc.fillRectangle(x, y, this.width, this.height);
        gc.setForeground(Display.getDefault().getSystemColor(16));
        gc.drawRectangle(x, y + this.titleHeight, this.width, this.height - this.titleHeight);
        gc.setForeground(Display.getDefault().getSystemColor(1));
        gc.drawRectangle(x + 1, y + this.titleHeight + 1, this.width - 2, this.height - this.titleHeight - 2);
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.childs.elementAt(i);
            if (x + wrapper.x > x + this.width) {
                wrapper.setIsShow(false);
            } else {
                wrapper.setIsShow(true);
            }
            wrapper.paintControl(gc, x, y);
            ++i;
        }
        gc.setClipping(parentClipRect);
    }

    public void addChild(VisualElementWrapper child) {
        Rectangle rect = this.getRectangle();
        int xOff = rect.x;
        int yOff = rect.y;
        child.setResizable(false);
        child.setMoveable(false);
        ((TabItemWrapper)child).setIsActivate(false);
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper aChild = (VisualElementWrapper)this.childs.elementAt(i);
            xOff += aChild.width;
            ++i;
        }
        child.setBounds(xOff, yOff, 60, this.titleHeight);
        if (xOff > rect.x + this.width) {
            child.setIsShow(false);
        }
        this.childs.addElement(child);
    }

    private void layOut() {
        Rectangle rect = this.getRectangle();
        int xOff = rect.x;
        int yOff = rect.y;
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper aChild = (VisualElementWrapper)this.childs.elementAt(i);
            aChild.setBounds(xOff, yOff, 60, this.titleHeight);
            if (xOff > rect.x + this.width) {
                aChild.setIsShow(false);
            } else {
                aChild.setIsShow(true);
            }
            xOff += aChild.width;
            ++i;
        }
    }

    public void childActivated(VisualElementWrapper child, boolean value) {
        if (value) {
            if (this.activateWrapper != null && this.activateWrapper != child) {
                ((TabItemWrapper)this.activateWrapper).setIsActivate(false);
            }
            ((TabItemWrapper)child).setIsActivate(true);
            this.activateWrapper = child;
        }
    }

    public boolean getIsCanSetTabOrder() {
        return false;
    }
}

