/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.visualeditor;

import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class TableWrapper
extends VisualElementWrapper {
    private VisualElementWrapper activateColumn;

    public TableWrapper() {
    }

    public TableWrapper(VisualElementWrapper pWrapper, XMLNode node, EditorProfile profile) {
        super(pWrapper, node, profile);
    }

    public void paintControl(GC gc, int xOffset, int yOffset) {
        this.layOut();
        int x = this.x + xOffset;
        int y = this.y + yOffset;
        Rectangle parentClipRect = gc.getClipping();
        Rectangle clipRect = this.clipRect(this.getRectangle(), parentClipRect);
        gc.setClipping(clipRect);
        Color bkColor = gc.getBackground();
        this.draw3DRect(gc, x, y, this.width, this.height, 0, Display.getDefault().getSystemColor(1));
        gc.setBackground(Display.getDefault().getSystemColor(22));
        gc.fillRectangle(x + 3, y + 2, this.width - 5, 20);
        gc.setForeground(Display.getDefault().getSystemColor(15));
        int i = 40;
        while (i < this.height) {
            gc.drawLine(x + 2, y + i, x + this.width - 2, y + i);
            i += 20;
        }
        int xOff = x;
        int i2 = 0;
        while (i2 < this.childs.size()) {
            VisualElementWrapper aChild = (VisualElementWrapper)this.childs.elementAt(i2);
            aChild.paintControl(gc, x, y);
            if ("TableColumn".equals(aChild.node.getNodeName())) {
                gc.setForeground(Display.getDefault().getSystemColor(15));
                gc.drawLine(xOff += aChild.width, y + 23, xOff, y + this.height);
            }
            ++i2;
        }
        gc.setClipping(clipRect);
        if (this.isActivated) {
            this.paintActivateSymbol(gc, xOffset, yOffset);
        }
        if (this.isSelected) {
            this.paintSelectedSymbol(gc, xOffset, yOffset);
        }
        if (this.getParentWrapper() != null && this.getParentWrapper().getIsSetTabOrder()) {
            this.paintTabOrderSymbol(gc, xOffset, yOffset);
        }
        gc.setClipping(parentClipRect);
    }

    public void addChild(VisualElementWrapper child) {
        if ("TableColumn".equals(child.node.getNodeName())) {
            Rectangle rect = this.getRectangle();
            int xOff = rect.x;
            int yOff = rect.y + 2;
            child.setResizable(true);
            child.setResizeMode(1);
            child.setMoveable(false);
            Point size = child.getSize();
            if (size.x <= 0) {
                size.x = 60;
            }
            if (size.y <= 0) {
                size.y = 25;
            }
            int i = 0;
            while (i < this.childs.size()) {
                VisualElementWrapper aChild = (VisualElementWrapper)this.childs.elementAt(i);
                xOff += aChild.width;
                ++i;
            }
            child.setBounds(xOff, yOff, size.x, size.y);
            if (xOff > rect.x + this.width) {
                child.setIsShow(false);
            }
        }
        this.childs.addElement(child);
    }

    public void removeChild(VisualElementWrapper child) {
        this.childs.remove(child);
        this.node.remove(child.getXMLNode());
    }

    private void layOut() {
        Rectangle rect = this.getRectangle();
        int xOff = rect.x;
        int yOff = rect.y + 2;
        int i = 0;
        while (i < this.childs.size()) {
            VisualElementWrapper aChild = (VisualElementWrapper)this.childs.elementAt(i);
            if ("TableColumn".equals(aChild.node.getNodeName())) {
                aChild.setBounds(xOff, yOff, aChild.width, aChild.height);
                if ((xOff += aChild.width) > rect.x + this.width) {
                    aChild.setIsShow(false);
                } else {
                    aChild.setIsShow(true);
                }
            }
            ++i;
        }
    }

    public void childActivated(VisualElementWrapper child, boolean value) {
        this.activateColumn = value ? child : null;
    }

    public boolean getIsCanSetTabOrder() {
        return false;
    }
}

