/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.visualeditor;

import com.ecc.ide.editor.Wrapper;
import com.ecc.ide.editor.XMLElementObjectMaker;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.visualeditor.VisualEditorInterface;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class VisualContentToImage
implements VisualEditorInterface {
    private Vector visualElements = new Vector();
    protected EditorProfile flowProfile;
    protected XMLNode commonFlowNode;
    private VisualElementWrapper rootWrapper;
    private boolean imageOk = false;

    public void setFlowEditorProfile(EditorProfile profile) {
        this.flowProfile = profile;
    }

    public void setXMLContent(XMLNode node) throws Exception {
        try {
            VisualElementWrapper wrapper;
            Element element = this.flowProfile.getElement(node.getNodeName());
            XMLNode flowNode = this.mergeCommonFlow(node);
            if (element.getWrapperClassType() == null) {
                wrapper = new VisualElementWrapper(null, flowNode, this.flowProfile);
            } else {
                wrapper = (VisualElementWrapper)Class.forName(element.getWrapperClassType()).newInstance();
                wrapper.setElement(element);
                wrapper.setXMLNode(flowNode);
            }
            wrapper.editor = this;
            this.visualElements.addElement(wrapper);
            this.rootWrapper = wrapper;
            Rectangle rect = wrapper.getRectangle();
            this.addViewElementToContent(wrapper, flowNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private XMLNode mergeCommonFlow(XMLNode flowNode) {
        String refFlowId = flowNode.getParent().getAttrValue("refFlowId");
        if (refFlowId == null || refFlowId.trim().length() == 0) {
            return flowNode;
        }
        XMLNode refFlow = (XMLNode)this.commonFlowNode.findChildNode(refFlowId).clone();
        if (refFlow == null) {
            return flowNode;
        }
        int i = 0;
        while (i < refFlow.getChilds().size()) {
            XMLNode extendedAction = (XMLNode)refFlow.getChilds().elementAt(i);
            if ("ExtendedAction".equals(extendedAction.getNodeName())) {
                XMLNode eAction = flowNode.findChildNodeWithAttrValue("ExtendedAction", "extendId", extendedAction.getAttrValue("extendId"));
                if (eAction == null) {
                    flowNode.add(extendedAction);
                } else {
                    XMLNode node;
                    XMLNode parent = eAction.getParent();
                    int j = 0;
                    while (j < eAction.getChilds().size()) {
                        node = (XMLNode)eAction.getChilds().elementAt(j);
                        if ("transition".equals(node.getNodeName())) {
                            eAction.getChilds().remove(node);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < extendedAction.getChilds().size()) {
                        node = (XMLNode)extendedAction.getChilds().elementAt(j);
                        if ("transition".equals(node.getNodeName())) {
                            eAction.getChilds().addElement(node);
                        }
                        ++j;
                    }
                    refFlow.replaceNode(extendedAction, eAction);
                }
            }
            ++i;
        }
        return refFlow;
    }

    public void saveToImageFile(String fileName, int imageType) {
        final String fn = fileName;
        this.imageOk = false;
        VisualContentToImage synObj = this;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    Image image = new Image((Device)Display.getDefault(), ((VisualContentToImage)VisualContentToImage.this).rootWrapper.width, ((VisualContentToImage)VisualContentToImage.this).rootWrapper.height);
                    GC gc = new GC((Drawable)image);
                    gc.setBackground(Display.getDefault().getSystemColor(1));
                    Rectangle rect = VisualContentToImage.this.getRootElement().getRectangle();
                    VisualContentToImage.this.getRootElement().setBounds(0, 0, rect.width, rect.height);
                    gc.fillRectangle(0, 0, rect.width, rect.height);
                    gc.setForeground(Display.getDefault().getSystemColor(2));
                    gc.drawRectangle(0, 0, rect.width - 2, rect.height - 2);
                    gc.setClipping(1, 1, rect.width - 4, rect.height - 4);
                    VisualContentToImage.this.getRootElement().paintControl(gc, 0, 0);
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[1];
                    imageLoader.data[0] = image.getImageData();
                    imageLoader.save(fn, 0);
                    VisualContentToImage.this.getRootElement().setBounds(rect);
                    gc.dispose();
                    image.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                VisualContentToImage.this.imageOK();
            }
        });
    }

    public synchronized void imageOK() {
        this.imageOk = true;
        this.notifyAll();
    }

    public synchronized void isImageOK() {
        while (!this.imageOk) {
            try {
                this.wait(10000L);
            }
            catch (Exception exception) {
            }
        }
        return;
    }

    public void loadXMLContent(InputStream in) throws Exception {
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new XMLElementObjectMaker());
            XMLNode node = (XMLNode)xmlLoader.loadXMLContent(in);
            this.setXMLContent(node);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void loadXMLFile(String xmlFileName) {
        try {
            FileInputStream fi = new FileInputStream(xmlFileName);
            this.loadXMLContent(fi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addViewElementToContent(VisualElementWrapper wrapper, XMLNode node) {
        Vector childs = node.getChilds();
        int i = 0;
        while (i < childs.size()) {
            XMLNode aNode = (XMLNode)childs.elementAt(i);
            Element element = this.flowProfile.getElement(aNode.getNodeName());
            if (element != null) {
                VisualElementWrapper aWrapper = null;
                if (element.getWrapperClassType() == null) {
                    aWrapper = new VisualElementWrapper(wrapper, aNode, this.flowProfile);
                } else {
                    try {
                        aWrapper = (VisualElementWrapper)Class.forName(element.getWrapperClassType()).newInstance();
                        aWrapper.setElement(element);
                        aWrapper.setParent(wrapper);
                        aWrapper.setXMLNode(aNode);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                aWrapper.editor = this;
                this.visualElements.addElement(aWrapper);
                this.addViewElementToContent(aWrapper, aNode);
            }
            ++i;
        }
    }

    public VisualElementWrapper getActivateVisualElement() {
        return null;
    }

    public VisualElementWrapper getRootElement() {
        return this.rootWrapper;
    }

    public void showStateMessage(String msg) {
    }

    public void showPosition(Rectangle resizeRect) {
    }

    public VisualElementWrapper getVisualElement(int x, int y) {
        return null;
    }

    public VisualElementWrapper addNewElement(VisualElementWrapper wrapper, Element element, int x, int y) {
        return null;
    }

    public void doLink(VisualElementWrapper src, VisualElementWrapper dst) {
    }

    public void removeElement(VisualElementWrapper wrapper) {
    }

    public void adjustTabOrder(VisualElementWrapper wrapper, int order) {
    }

    public double getXResolution() {
        return 0.0;
    }

    public double getYResolution() {
        return 0.0;
    }

    public void updateContent() {
    }

    public boolean isValidName(String name) {
        return true;
    }

    public VisualElementWrapper getVisualElementNamed(String name) {
        int size = this.visualElements.size();
        if (size == 0) {
            return null;
        }
        int i = size - 1;
        while (i >= 0) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.visualElements.elementAt(i);
            if (name.equals(wrapper.getAttrValue("name"))) {
                return wrapper;
            }
            --i;
        }
        return null;
    }

    public EditorProfile getEditorProfile() {
        return this.flowProfile;
    }

    public void setActivateWrapper(Wrapper wrapper) {
    }

    public void deleteWrapper(Wrapper wrapper) {
    }

    public void doInsert(Element element) {
    }

    public void cancelCurrentAction() {
    }

    public void deleteActivateComponent() {
    }

    public String getRootPath() {
        return null;
    }

    public void setItemEnable(int item, boolean value) {
    }

    public String getStringContent() {
        return null;
    }

    public void setCommonFlowNode(XMLNode commonFlowNode) {
        this.commonFlowNode = commonFlowNode;
    }
}

