/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.visualeditor;

import com.ecc.ide.editorprofile.EditorProfile;
import com.ecc.ide.editorprofile.ProfileObjectMaker;
import com.ecc.ide.visualeditor.Messages;
import com.ecc.ide.visualeditor.VisualEditorFramePanel;
import com.ecc.util.xmlloader.ObjectMaker;
import com.ecc.util.xmlloader.XMLLoader;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class VisualEditor {
    String fileName = null;
    Shell shell;
    VisualEditorFramePanel editor = null;
    EditorProfile profile;
    String newFileSrc = "";

    public VisualEditor(String fileName, String profileName, boolean showRuller) {
        this.fileName = fileName;
        Display display = new Display();
        this.shell = new Shell(display);
        this.shell.setLayout((Layout)new FillLayout());
        Menu menubar = new Menu((Decorations)this.shell, 2);
        MenuItem menuItem = new MenuItem(menubar, 64);
        menuItem.setText(Messages.getString("VisualEditor.File_2"));
        Menu popupmenu = new Menu(menuItem);
        menuItem.setMenu(popupmenu);
        MenuItem menuItem_1 = new MenuItem(popupmenu, 0);
        menuItem_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditor.this.newFile();
            }
        });
        menuItem_1.setText(Messages.getString("VisualEditor.New_3"));
        new MenuItem(popupmenu, 2);
        MenuItem menuItem_2 = new MenuItem(popupmenu, 0);
        menuItem_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditor.this.openFile();
            }
        });
        menuItem_2.setText(Messages.getString("VisualEditor.Open_4"));
        MenuItem menuItem_3 = new MenuItem(popupmenu, 0);
        menuItem_3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditor.this.saveFile();
            }
        });
        menuItem_3.setText(Messages.getString("VisualEditor.Save_5"));
        MenuItem menuItem_4 = new MenuItem(popupmenu, 0);
        menuItem_4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditor.this.saveAs();
            }
        });
        menuItem_4.setText(Messages.getString("VisualEditor.Save_As_6"));
        new MenuItem(popupmenu, 2);
        MenuItem menuItem_9 = new MenuItem(popupmenu, 0);
        menuItem_9.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditor.this.saveAsImageFile();
            }
        });
        menuItem_9.setText(Messages.getString("VisualEditor.Save_As_ImageFile_7"));
        new MenuItem(popupmenu, 2);
        MenuItem menuItem_5 = new MenuItem(popupmenu, 0);
        menuItem_5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisualEditor.this.shell.dispose();
            }
        });
        menuItem_5.setText(Messages.getString("VisualEditor.Exit_8"));
        MenuItem menuItem_6 = new MenuItem(menubar, 64);
        menuItem_6.setText(Messages.getString("VisualEditor.Help_9"));
        Menu popupmenu_1 = new Menu(menuItem_6);
        menuItem_6.setMenu(popupmenu_1);
        MenuItem menuItem_7 = new MenuItem(popupmenu_1, 0);
        menuItem_7.setText(Messages.getString("VisualEditor.Content_10"));
        new MenuItem(popupmenu_1, 2);
        MenuItem menuItem_8 = new MenuItem(popupmenu_1, 0);
        menuItem_8.setText(Messages.getString("VisualEditor.About_11"));
        this.shell.setMenuBar(menubar);
        this.editor = new VisualEditorFramePanel((Composite)this.shell, 2048);
        this.editor.setShowRule(showRuller);
        try {
            XMLLoader xmlLoader = new XMLLoader();
            xmlLoader.addObjectMaker((ObjectMaker)new ProfileObjectMaker());
            this.profile = (EditorProfile)xmlLoader.loadXMLFile(profileName);
            if (this.profile != null) {
                this.editor.setEditorProfile(this.profile);
                if (fileName != null) {
                    this.editor.loadXMLFile(fileName);
                } else {
                    String rootElementName = this.profile.getRootElementName();
                    this.newFileSrc = "<?xml version = \"1.0\" encoding = \"UTF-8\" ?>\n\n<" + rootElementName + " height=\"300\" width=\"500\" x=\"32\" y=\"32\">\n</" + rootElementName + ">";
                    this.editor.loadXMLContent(new ByteArrayInputStream(this.newFileSrc.getBytes()));
                }
                if (this.profile.getTitle() != null) {
                    this.shell.setText(String.valueOf(this.profile.getTitle()) + " newFile.xml");
                } else {
                    this.shell.setText("newFile.xml");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static void main(String[] argv) {
        String profileName = null;
        String fileName = null;
        boolean showRuller = false;
        if (argv.length < 1) {
            System.out.println(Messages.getString("VisualEditor.Usage__n_java_com.ecc.ide.visualeditor.VisualEditor_prifleName_showRuller_fileName_n_showRuller_true/false_can_be_ignore_nfileName_can_be_ignore_17"));
            return;
        }
        if (argv.length == 1) {
            profileName = argv[0];
        } else if (argv.length == 2) {
            profileName = argv[0];
            showRuller = "true".equals(argv[1]);
        } else if (argv.length == 3) {
            profileName = argv[0];
            showRuller = "true".equals(argv[1]);
            fileName = argv[2];
        }
        VisualEditor editor = new VisualEditor(fileName, profileName, showRuller);
    }

    private void openFile() {
        try {
            FileDialog fileDlg = new FileDialog(this.shell);
            String afileName = fileDlg.open();
            if (afileName == null) {
                return;
            }
            this.fileName = afileName;
            this.shell.setText(this.fileName);
            if (this.profile.getTitle() != null) {
                this.shell.setText(String.valueOf(this.profile.getTitle()) + " " + this.fileName);
            } else {
                this.shell.setText(this.fileName);
            }
            this.editor.loadXMLFile(afileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveFile() {
        if (this.fileName != null) {
            try {
                FileWriter fw = new FileWriter(this.fileName);
                fw.write(this.editor.getXMLStringContent());
                fw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.saveAs();
        }
    }

    private void saveAs() {
        FileDialog fileDlg = new FileDialog(this.shell);
        String afileName = fileDlg.open();
        if (afileName == null) {
            return;
        }
        this.fileName = afileName;
        if (this.profile.getTitle() != null) {
            this.shell.setText(String.valueOf(this.profile.getTitle()) + " " + this.fileName);
        } else {
            this.shell.setText(this.fileName);
        }
        if (this.fileName != null) {
            this.saveFile();
        }
    }

    private void saveAsImageFile() {
        FileDialog fileDlg = new FileDialog(this.shell);
        String aFileName = fileDlg.open();
        if (aFileName == null) {
            return;
        }
        this.editor.saveToImageFile(aFileName, 0);
    }

    private void newFile() {
        this.fileName = null;
        if (this.profile.getTitle() != null) {
            this.shell.setText(String.valueOf(this.profile.getTitle()) + " newFile.xml");
        } else {
            this.shell.setText("newFile.xml");
        }
        try {
            this.editor.loadXMLContent(new ByteArrayInputStream(this.newFileSrc.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

