/*
 * Decompiled with CFR 0.152.
 */
package com.ecc.ide.visualeditor;

import com.ecc.ide.base.IDEConstance;
import com.ecc.ide.editor.XMLNode;
import com.ecc.ide.editor.objectEditor.ObjectEditor;
import com.ecc.ide.editorprofile.Element;
import com.ecc.ide.visualeditor.ActionClassSearch;
import com.ecc.ide.visualeditor.Messages;
import com.ecc.ide.visualeditor.VisualEditorFramePanel;
import com.ecc.ide.visualeditor.VisualEditorInterface;
import com.ecc.ide.visualeditor.VisualElementWrapper;
import java.io.ByteArrayInputStream;
import java.util.Vector;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class VisualEditorContentPanel
extends Composite
implements MouseListener,
ControlListener,
MouseMoveListener,
PaintListener,
KeyListener {
    private Point mouseDownPoint = new Point(0, 0);
    private Point curMousePoint = new Point(0, 0);
    int borderWidth = 5;
    private Vector visualElements = new Vector();
    public VisualEditorInterface editor;
    private boolean isMoveDrag;
    private boolean isResizeDrag;
    private boolean isSelectDrag = false;
    private boolean isSetTabOrder = false;
    private boolean isLinking = false;
    private VisualElementWrapper linkSrcWrapper;
    private VisualElementWrapper linkDstWrapper;
    private int curTabOrder = 0;
    private int tabElementSize = 0;
    private int resizeMode;
    private boolean isInsert = false;
    private Element insertElement;
    private Vector selectedWrapper = new Vector();
    Rectangle selectRect;
    Rectangle resizeRect = new Rectangle(0, 0, 10, 10);
    boolean drawedFlag = false;
    public static boolean isCtrlDown = false;
    boolean isShiftDown = false;
    private boolean isShowGrid = false;
    int gridSize = 8;
    private boolean isShowCMUnit = false;
    private String[] undoBuffer = new String[10];
    private int curUndoSize = 0;
    private int curUndo = 0;
    int actionSize = 0;
    int undoPoint = 0;

    public void setShowGrid(boolean value) {
        if (this.isShowGrid != value) {
            this.isShowGrid = value;
            this.redraw();
        }
    }

    public VisualEditorContentPanel(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x200000);
        this.addMouseListener(this);
        this.addPaintListener(this);
        this.addMouseMoveListener(this);
        this.addKeyListener(this);
        parent.addControlListener((ControlListener)this);
    }

    public void controlResized(ControlEvent ce) {
        Point size = this.getParent().getSize();
        Point sz = this.getSize();
        if (sz.x < size.x) {
            sz.x = size.x;
        }
        if (sz.y < size.y) {
            sz.y = size.y;
        }
        this.setSize(sz);
    }

    public void controlMoved(ControlEvent ce) {
    }

    public void paintControl(PaintEvent event) {
        int i;
        Point size = this.getSize();
        if (this.editor.getRootElement() == null) {
            event.gc.setBackground(this.getDisplay().getSystemColor(16));
            event.gc.fillRectangle(0, 0, size.x, size.y);
            return;
        }
        Image image = new Image((Device)Display.getDefault(), size.x, size.y);
        GC gc = new GC((Drawable)image);
        Color bkColor = event.gc.getBackground();
        gc.setBackground(bkColor);
        gc.setBackground(this.getDisplay().getSystemColor(16));
        gc.fillRectangle(0, 0, size.x + 30, size.y);
        gc.setBackground(bkColor);
        Rectangle rect = this.editor.getRootElement().getRectangle();
        gc.fillRectangle(rect.x, rect.y, rect.width, rect.height);
        if (this.isShowGrid) {
            gc.setForeground(this.getDisplay().getSystemColor(10));
            i = rect.y;
            while (i < rect.y + rect.height) {
                int j = rect.x;
                while (j < rect.x + rect.width) {
                    gc.drawLine(j, i, j, i);
                    j += this.gridSize;
                }
                i += this.gridSize;
            }
        }
        i = 0;
        while (i < this.visualElements.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.visualElements.elementAt(i);
            wrapper.paintControl(gc, 0, 0);
            ++i;
        }
        VisualElementWrapper aWrapper = this.editor.getActivateVisualElement();
        if (aWrapper != null && aWrapper != this.editor.getRootElement()) {
            Rectangle rect1 = aWrapper.getRectangle();
            aWrapper.paintControl(gc, rect1.x - aWrapper.x, rect1.y - aWrapper.y);
        }
        if (this.isLinking && this.linkSrcWrapper != null) {
            Rectangle linkRect = this.linkSrcWrapper.getRectangle();
            gc.setForeground(this.getDisplay().getSystemColor(9));
            gc.setLineStyle(3);
            gc.drawLine(linkRect.x + linkRect.width / 2, linkRect.y + linkRect.height / 2, this.curMousePoint.x, this.curMousePoint.y);
            gc.setLineStyle(1);
        }
        if (this.isResizeDrag) {
            gc.setForeground(this.getDisplay().getSystemColor(9));
            gc.setLineStyle(3);
            gc.drawRectangle(this.resizeRect);
            this.editor.showPosition(this.resizeRect);
            gc.setLineStyle(1);
        }
        if (this.isMoveDrag) {
            int xOff = this.curMousePoint.x - this.mouseDownPoint.x;
            int yOff = this.curMousePoint.y - this.mouseDownPoint.y;
            Rectangle rec = this.editor.getActivateVisualElement().getRectangle();
            rec.x += xOff;
            rec.y += yOff;
            gc.setForeground(this.getDisplay().getSystemColor(9));
            gc.setLineStyle(3);
            gc.drawRectangle(rec);
            this.editor.showPosition(rec);
            int i2 = 0;
            while (i2 < this.selectedWrapper.size()) {
                VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i2);
                rec = wrapper.getRectangle();
                rec.x += xOff;
                rec.y += yOff;
                gc.drawRectangle(rec);
                ++i2;
            }
            gc.setLineStyle(1);
        }
        if (this.isSelectDrag) {
            Point top = new Point(0, 0);
            Point button = new Point(0, 0);
            if (this.mouseDownPoint.x > this.curMousePoint.x) {
                top.x = this.curMousePoint.x;
                button.x = this.mouseDownPoint.x;
            } else {
                top.x = this.mouseDownPoint.x;
                button.x = this.curMousePoint.x;
            }
            if (this.mouseDownPoint.y > this.curMousePoint.y) {
                top.y = this.curMousePoint.y;
                button.y = this.mouseDownPoint.y;
            } else {
                top.y = this.mouseDownPoint.y;
                button.y = this.curMousePoint.y;
            }
            gc.setForeground(this.getDisplay().getSystemColor(9));
            gc.setLineStyle(3);
            gc.drawRectangle(top.x, top.y, button.x - top.x, button.y - top.y);
            gc.setLineStyle(1);
        }
        if (this.isShowCMUnit) {
            this.paintRule(gc);
        }
        event.gc.drawImage(image, 0, 0);
        image.dispose();
        gc.dispose();
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.isMoveDrag = false;
        this.isSelectDrag = false;
        this.editCurrentComponent();
    }

    public void mouseDown(MouseEvent e) {
        this.mouseDownPoint.x = e.x;
        this.mouseDownPoint.y = e.y;
        if (this.isLinking) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            if (wrapper == null) {
                return;
            }
            if (this.linkSrcWrapper == null) {
                if (wrapper.isCanLinkOut()) {
                    this.linkSrcWrapper = wrapper;
                }
            } else if (wrapper.isCanLinkIn(this.linkSrcWrapper)) {
                this.linkDstWrapper = wrapper;
                this.doLink();
            }
            return;
        }
        if (this.isInsert) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            if (wrapper == null) {
                return;
            }
            if (wrapper.isAcceptable(this.insertElement)) {
                this.doInsert(wrapper, e.x, e.y);
            }
            return;
        }
        if (this.isSetTabOrder) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            if (wrapper == null) {
                return;
            }
            if (wrapper.getParentWrapper() != this.editor.getActivateVisualElement()) {
                this.endSetTabOrder();
                return;
            }
            this.setElementTabOrder(wrapper);
            return;
        }
        if (isCtrlDown) {
            this.selectElement();
            return;
        }
        if (this.isShiftDown) {
            this.selectElement();
            return;
        }
        boolean isResizePosition = this.getResizeMode(e.x, e.y);
        if (isResizePosition) {
            this.isResizeDrag = true;
            this.unselectElement();
            return;
        }
        VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
        try {
            if (!IDEConstance.isFoldVisible(wrapper.node)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (wrapper != null && wrapper != this.editor.getActivateVisualElement()) {
            this.unselectElement();
            this.editor.setActivateWrapper(wrapper);
            if (wrapper.getMoveable()) {
                this.isMoveDrag = true;
            }
            this.editor.showPosition(wrapper.getRectangle());
            this.selectedWrapper.clear();
            return;
        }
        boolean isMovePosition = this.getMovePosition(e.x, e.y);
        if (isMovePosition && wrapper.getMoveable()) {
            this.isMoveDrag = true;
            return;
        }
        this.unselectElement();
        this.selectedWrapper.clear();
        wrapper = this.editor.getVisualElement(e.x, e.y);
        if (wrapper != null) {
            this.editor.setActivateWrapper(wrapper);
            this.editor.showPosition(wrapper.getRectangle());
            if (wrapper.getMoveable()) {
                this.isMoveDrag = true;
                return;
            }
        }
        this.isSelectDrag = true;
    }

    public void mouseMove(MouseEvent e) {
        this.curMousePoint.x = e.x;
        this.curMousePoint.y = e.y;
        if (this.isLinking) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            if (wrapper == null) {
                return;
            }
            if (this.linkSrcWrapper == null) {
                if (wrapper.isCanLinkOut()) {
                    this.setCursor(IDEConstance.getCursor(2));
                } else {
                    this.setCursor(IDEConstance.getCursor(20));
                }
            } else {
                if (wrapper.isCanLinkIn(this.linkSrcWrapper)) {
                    this.setCursor(IDEConstance.getCursor(2));
                } else {
                    this.setCursor(IDEConstance.getCursor(20));
                }
                this.redraw();
            }
            return;
        }
        if (this.isSetTabOrder) {
            return;
        }
        if (isCtrlDown) {
            return;
        }
        if (this.isShiftDown) {
            return;
        }
        if (this.isMoveDrag) {
            this.drawTheMovingRectangle();
            return;
        }
        if (this.isResizeDrag) {
            this.drawTheResizeRectangle();
            return;
        }
        if (this.isInsert) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            if (wrapper == null) {
                return;
            }
            if (wrapper.isAcceptable(this.insertElement)) {
                this.setCursor(IDEConstance.getCursor(2));
            } else {
                this.setCursor(IDEConstance.getCursor(20));
            }
            return;
        }
        if (this.isSelectDrag) {
            this.selectTheElements();
        }
        if (this.getResizeMode(e.x, e.y)) {
            if (this.resizeMode == 0) {
                this.setCursor(IDEConstance.getCursor(17));
            } else if (this.resizeMode == 1) {
                this.setCursor(IDEConstance.getCursor(10));
            } else if (this.resizeMode == 2) {
                this.setCursor(IDEConstance.getCursor(14));
            } else if (this.resizeMode == 3) {
                this.setCursor(IDEConstance.getCursor(16));
            } else if (this.resizeMode == 4) {
                this.setCursor(IDEConstance.getCursor(11));
            } else if (this.resizeMode == 5) {
                this.setCursor(IDEConstance.getCursor(15));
            } else if (this.resizeMode == 6) {
                this.setCursor(IDEConstance.getCursor(13));
            } else if (this.resizeMode == 7) {
                this.setCursor(IDEConstance.getCursor(12));
            }
        } else if (this.getMovePosition(e.x, e.y)) {
            VisualElementWrapper wrapper = this.editor.getVisualElement(e.x, e.y);
            VisualElementWrapper actWrapper = this.editor.getActivateVisualElement();
            if (wrapper == null || wrapper == actWrapper) {
                this.setCursor(IDEConstance.getCursor(5));
            } else {
                this.setCursor(IDEConstance.getCursor(0));
            }
        } else {
            this.setCursor(IDEConstance.getCursor(0));
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.isMoveDrag) {
            VisualElementWrapper targetWrapper = this.editor.getVisualElement(e.x, e.y);
            int xOff = e.x - this.mouseDownPoint.x;
            int yOff = e.y - this.mouseDownPoint.y;
            this.moveSelectedComponent(xOff, yOff);
            this.isMoveDrag = false;
        } else if (this.isResizeDrag) {
            this.isResizeDrag = false;
            if (!this.drawedFlag) {
                return;
            }
            this.drawedFlag = false;
            this.editor.getActivateVisualElement().setBounds(this.resizeRect.x, this.resizeRect.y, this.resizeRect.width, this.resizeRect.height);
            int width = this.getSize().x;
            int height = this.getSize().y;
            if (this.resizeRect.x + this.resizeRect.width > width) {
                width = this.resizeRect.x + this.resizeRect.width + 20;
            }
            if (this.resizeRect.y + this.resizeRect.height > height) {
                height = this.resizeRect.y + this.resizeRect.height + 20;
            }
            Point size = new Point(width, height);
            if (width != this.getSize().x || height != this.getSize().y) {
                this.alignToGrid(size);
                this.setSize(size.x, size.y);
            }
            this.saveCurrentAction();
            this.redraw();
        }
        if (this.isSelectDrag) {
            this.isSelectDrag = false;
            this.redraw();
        }
        this.setCursor(IDEConstance.getCursor(0));
    }

    private void moveSelectedComponent(int xOff, int yOff) {
        if (xOff != 0 || yOff != 0) {
            Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
            rect.x += xOff;
            rect.y += yOff;
            this.alignToGrid(rect);
            this.editor.getActivateVisualElement().setBounds(rect);
            int i = 0;
            while (i < this.selectedWrapper.size()) {
                VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
                rect = wrapper.getRectangle();
                rect.x += xOff;
                rect.y += yOff;
                this.alignToGrid(rect);
                wrapper.setBounds(rect);
                ++i;
            }
            this.redraw();
            this.saveCurrentAction();
        }
    }

    public void keyPressed(KeyEvent event) {
        if (this.isMoveDrag || this.isResizeDrag) {
            return;
        }
        int xOff = 0;
        int yOff = 0;
        int scale = 5;
        if (isCtrlDown) {
            scale = 1;
        }
        if (event.keyCode == 0x1000001) {
            yOff = -scale;
        } else if (event.keyCode == 0x1000002) {
            yOff = scale;
        } else if (event.keyCode == 0x1000003) {
            xOff = -scale;
        } else if (event.keyCode == 0x1000004) {
            xOff = scale;
        }
        if (xOff != 0 || yOff != 0) {
            this.moveSelectedComponent(xOff, yOff);
            return;
        }
        if (isCtrlDown && event.keyCode == 97) {
            this.selectAllElement();
        }
        if (event.keyCode == 131072) {
            this.isShiftDown = true;
        } else if (event.keyCode == 262144) {
            isCtrlDown = true;
        } else if (event.keyCode == 127) {
            this.deleteSelectedElement();
        } else if (event.keyCode == 27) {
            this.editor.cancelCurrentAction();
        } else if (isCtrlDown && event.keyCode == 122) {
            this.undo();
        } else if (event.keyCode == 0x100000A && this.editor instanceof VisualEditorFramePanel) {
            ((VisualEditorFramePanel)this.editor).beanTreePanel.beginInsert(this.editor.getActivateVisualElement().getElement());
        }
    }

    public void keyReleased(KeyEvent event) {
        if (event.keyCode == 262144) {
            isCtrlDown = false;
        }
        if (event.keyCode == 131072) {
            this.isShiftDown = false;
        }
    }

    public void foldSelectNode() {
        try {
            VisualElementWrapper wrapper = this.editor.getActivateVisualElement();
            XMLNode node = wrapper.node;
            if (IDEConstance.isFold(node)) {
                IDEConstance.expandNode(node);
            } else {
                IDEConstance.foldNode(node);
            }
            this.redraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean getResizeMode(int mx, int my) {
        if (this.editor.getActivateVisualElement() == null || !this.editor.getActivateVisualElement().getResizeable()) {
            return false;
        }
        int wrapperResizeMode = this.editor.getActivateVisualElement().getResizeMode();
        Rectangle selectRect = this.editor.getActivateVisualElement().getRectangle();
        int x = selectRect.x;
        int y = selectRect.y;
        int width = selectRect.width;
        int height = selectRect.height;
        if (my >= y - this.borderWidth && my <= y) {
            if (mx >= x - this.borderWidth && mx <= x && wrapperResizeMode == 0) {
                this.resizeMode = 0;
                return true;
            }
            if (mx >= x + (width - this.borderWidth) / 2 && mx <= x + (width - this.borderWidth) / 2 + this.borderWidth && (wrapperResizeMode == 0 || wrapperResizeMode == 2 || wrapperResizeMode == 3)) {
                this.resizeMode = 1;
                return true;
            }
            if (mx >= x + width && mx <= x + width + this.borderWidth && wrapperResizeMode == 0) {
                this.resizeMode = 2;
                return true;
            }
        }
        if (my >= y + height && my <= y + height + this.borderWidth) {
            if (mx >= x - this.borderWidth && mx <= x && wrapperResizeMode == 0) {
                this.resizeMode = 3;
                return true;
            }
            if (mx >= x + (width - this.borderWidth) / 2 && mx <= x + (width - this.borderWidth) / 2 + this.borderWidth && (wrapperResizeMode == 0 || wrapperResizeMode == 2 || wrapperResizeMode == 3)) {
                this.resizeMode = 4;
                return true;
            }
            if (mx >= x + width && mx <= x + width + this.borderWidth && wrapperResizeMode == 0) {
                this.resizeMode = 5;
                return true;
            }
        }
        if (my >= y + (height - this.borderWidth) / 2 && my <= y + (height - this.borderWidth) / 2 + this.borderWidth) {
            if (mx >= x - this.borderWidth && mx <= x && (wrapperResizeMode == 0 || wrapperResizeMode == 1 || wrapperResizeMode == 3)) {
                this.resizeMode = 6;
                return true;
            }
            if (mx >= x + width && mx <= x + width + this.borderWidth && (wrapperResizeMode == 0 || wrapperResizeMode == 1 || wrapperResizeMode == 3)) {
                this.resizeMode = 7;
                return true;
            }
        }
        return false;
    }

    private boolean getMovePosition(int mx, int my) {
        if (this.editor.getActivateVisualElement() == this.editor.getRootElement()) {
            return false;
        }
        if (this.selectRect != null) {
            return mx >= this.selectRect.x && mx <= this.selectRect.x + this.selectRect.width && my >= this.selectRect.y && my <= this.selectRect.y + this.selectRect.height;
        }
        if (this.editor.getActivateVisualElement() == null) {
            return false;
        }
        if (!this.editor.getActivateVisualElement().getMoveable()) {
            return false;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        return mx >= rect.x && mx <= rect.x + rect.width && my >= rect.y && my <= rect.y + rect.height;
    }

    public void addVisualElement(VisualElementWrapper wrapper) {
        this.visualElements.addElement(wrapper);
        int width = wrapper.x + wrapper.width;
        int height = wrapper.y + wrapper.height;
        Point size = this.getSize();
        if (size.x < width) {
            size.x = width + 20;
        }
        if (size.y < height) {
            size.y = height + 20;
        }
        this.setSize(size);
    }

    private synchronized void drawTheResizeRectangle() {
        if (!this.drawedFlag) {
            this.drawedFlag = true;
        }
        Rectangle rec = this.editor.getActivateVisualElement().getRectangle();
        int xOff = this.curMousePoint.x - this.mouseDownPoint.x;
        int yOff = this.curMousePoint.y - this.mouseDownPoint.y;
        this.resizeRect.x = rec.x;
        this.resizeRect.y = rec.y;
        switch (this.resizeMode) {
            case 0: {
                this.resizeRect.x = rec.x + xOff;
                this.resizeRect.y = rec.y + yOff;
                this.resizeRect.width = rec.width - xOff;
                this.resizeRect.height = rec.height - yOff;
                break;
            }
            case 1: {
                this.resizeRect.y = rec.y + yOff;
                this.resizeRect.width = rec.width;
                this.resizeRect.height = rec.height - yOff;
                break;
            }
            case 2: {
                this.resizeRect.y = rec.y + yOff;
                this.resizeRect.width = rec.width + xOff;
                this.resizeRect.height = rec.height - yOff;
                break;
            }
            case 3: {
                this.resizeRect.x = rec.x + xOff;
                this.resizeRect.width = rec.width - xOff;
                this.resizeRect.height = rec.height + yOff;
                break;
            }
            case 4: {
                this.resizeRect.width = rec.width;
                this.resizeRect.height = rec.height + yOff;
                break;
            }
            case 5: {
                this.resizeRect.width = rec.width + xOff;
                this.resizeRect.height = rec.height + yOff;
                break;
            }
            case 6: {
                this.resizeRect.x = rec.x + xOff;
                this.resizeRect.width = rec.width - xOff;
                this.resizeRect.height = rec.height;
                break;
            }
            case 7: {
                this.resizeRect.width = rec.width + xOff;
                this.resizeRect.height = rec.height;
            }
        }
        if (this.resizeRect.width < 10) {
            this.resizeRect.width = 10;
        }
        if (this.resizeRect.height < 10) {
            this.resizeRect.height = 10;
        }
        this.redraw();
    }

    private synchronized void drawTheMovingRectangle() {
        this.redraw();
    }

    private void selectElement() {
        VisualElementWrapper actWrapper = this.editor.getActivateVisualElement();
        if (actWrapper == null) {
            return;
        }
        VisualElementWrapper wrapper = this.editor.getVisualElement(this.mouseDownPoint.x, this.mouseDownPoint.y);
        if (wrapper == null) {
            return;
        }
        if (wrapper.getParentWrapper() != actWrapper.getParentWrapper()) {
            if (isCtrlDown) {
                isCtrlDown = false;
                this.unselectElement();
                return;
            }
            return;
        }
        if (wrapper == actWrapper) {
            return;
        }
        if (wrapper.isSelected) {
            wrapper.setIsSelected(false);
            this.selectedWrapper.removeElement(wrapper);
        } else {
            wrapper.setIsSelected(true);
            this.selectedWrapper.addElement(wrapper);
        }
        this.redraw();
    }

    private void selectTheElements() {
        VisualElementWrapper rootWrapper = this.editor.getRootElement();
        if (rootWrapper.childs.size() == 0) {
            return;
        }
        this.unselectElement();
        Point top = new Point(0, 0);
        Point button = new Point(0, 0);
        if (this.mouseDownPoint.x > this.curMousePoint.x) {
            top.x = this.curMousePoint.x;
            button.x = this.mouseDownPoint.x;
        } else {
            top.x = this.mouseDownPoint.x;
            button.x = this.curMousePoint.x;
        }
        if (this.mouseDownPoint.y > this.curMousePoint.y) {
            top.y = this.curMousePoint.y;
            button.y = this.mouseDownPoint.y;
        } else {
            top.y = this.mouseDownPoint.y;
            button.y = this.curMousePoint.y;
        }
        int i = 0;
        while (i < rootWrapper.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)rootWrapper.childs.elementAt(i);
            Rectangle rec = wrapper.getRectangle();
            if (rec.x >= top.x && rec.y >= top.y && rec.x + rec.width <= button.x && rec.y + rec.height <= button.y) {
                wrapper.setIsSelected(true);
                this.selectedWrapper.addElement(wrapper);
            }
            ++i;
        }
        if (this.selectedWrapper.size() > 0) {
            VisualElementWrapper wrapper0 = (VisualElementWrapper)this.selectedWrapper.elementAt(0);
            wrapper0.setIsSelected(false);
            this.editor.setActivateWrapper(wrapper0);
            this.selectedWrapper.removeElementAt(0);
        }
        this.redraw();
    }

    private void selectAllElement() {
        VisualElementWrapper rootWrapper = this.editor.getRootElement();
        if (rootWrapper.childs.size() == 0) {
            return;
        }
        this.unselectElement();
        this.editor.setActivateWrapper((VisualElementWrapper)rootWrapper.childs.elementAt(0));
        int i = 1;
        while (i < rootWrapper.childs.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)rootWrapper.childs.elementAt(i);
            wrapper.setIsSelected(true);
            this.selectedWrapper.addElement(wrapper);
            ++i;
        }
        this.redraw();
    }

    private void unselectElement() {
        if (this.selectedWrapper.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            wrapper.setIsSelected(false);
            ++i;
        }
        this.selectedWrapper.clear();
        this.redraw();
    }

    public void beginInsert(Element element) {
        if (element != null) {
            this.isInsert = true;
            String desc = element.getDocument();
            this.editor.showStateMessage(desc);
        } else {
            this.isInsert = false;
            this.editor.showStateMessage("ready");
        }
        this.insertElement = element;
    }

    private void doInsert(VisualElementWrapper parent, int x, int y) {
        this.editor.addNewElement(parent, this.insertElement, x, y);
        this.unselectElement();
        this.isInsert = false;
        this.redraw();
        this.saveCurrentAction();
        this.editor.showStateMessage("ready");
    }

    public void beginLink() {
        this.isLinking = !this.isLinking;
        this.linkSrcWrapper = null;
        this.linkDstWrapper = null;
        this.endSetTabOrder();
        if (this.isLinking) {
            this.editor.showStateMessage(Messages.getString("VisualEditorContentPanel.Please_click_on_the_component_to_set_as_link_source,_or_recClick_at_tool_Item_to_cancel_link._4"));
        } else {
            this.editor.showStateMessage("ready");
        }
    }

    public void doLink() {
        this.isLinking = false;
        this.editor.doLink(this.linkSrcWrapper, this.linkDstWrapper);
        this.linkSrcWrapper = null;
        this.linkDstWrapper = null;
        this.saveCurrentAction();
        this.editor.showStateMessage("ready.");
    }

    public void cancelLink() {
        this.isLinking = false;
        this.linkSrcWrapper = null;
        this.linkDstWrapper = null;
        this.editor.showStateMessage("ready.");
        this.redraw();
    }

    public void deleteSelectedElement() {
        VisualElementWrapper wrapper = this.editor.getActivateVisualElement();
        if (wrapper.canBeDelete()) {
            this.editor.removeElement(wrapper);
        }
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            if (wrapper.canBeDelete()) {
                this.editor.removeElement(wrapper);
            }
            ++i;
        }
        this.selectedWrapper.clear();
        this.redraw();
        this.saveCurrentAction();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void saveCurrentAction() {
        try {
            String contentStr = this.editor.getStringContent();
            if (this.undoPoint < 10) {
                this.undoBuffer[this.undoPoint++] = contentStr;
                this.actionSize = this.undoPoint;
            } else {
                int i = 1;
                while (i < 9) {
                    this.undoBuffer[i - 1] = this.undoBuffer[i];
                    ++i;
                }
                this.undoBuffer[9] = contentStr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.enableUnDoAndRedo();
    }

    public void resetCurrentAction() {
        try {
            StringBuffer strBuf = new StringBuffer();
            this.undoPoint = 0;
            this.editor.getRootElement().getXMLNode().toXMLContent(0, strBuf);
            if (this.undoPoint < 10) {
                this.undoBuffer[this.undoPoint++] = strBuf.toString();
                this.actionSize = this.undoPoint;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.enableUnDoAndRedo();
    }

    public void undo() {
        if (this.undoPoint < 2) {
            return;
        }
        this.visualElements.clear();
        String content = this.undoBuffer[this.undoPoint - 2];
        --this.undoPoint;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
            this.editor.loadXMLContent(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editor.setActivateWrapper(this.editor.getRootElement());
        this.redraw();
        this.enableUnDoAndRedo();
    }

    public void redo() {
        if (this.undoPoint < this.actionSize) {
            String content = this.undoBuffer[this.undoPoint];
            if (content == null) {
                return;
            }
            this.visualElements.clear();
            ++this.undoPoint;
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes());
                this.editor.loadXMLContent(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.editor.setActivateWrapper(this.editor.getRootElement());
            this.redraw();
        }
        this.enableUnDoAndRedo();
    }

    private void enableUnDoAndRedo() {
        try {
            if (this.undoPoint > 1) {
                this.editor.setItemEnable(0, true);
            } else {
                this.editor.setItemEnable(0, false);
            }
            if (this.undoPoint < this.actionSize) {
                this.editor.setItemEnable(1, true);
            } else {
                this.editor.setItemEnable(1, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void alignLeft() {
        if (this.selectedWrapper.size() < 1) {
            return;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            Rectangle rect1 = wrapper.getRectangle();
            rect1.x = rect.x;
            wrapper.setBounds(rect1);
            ++i;
        }
        this.redraw();
        this.saveCurrentAction();
    }

    public void alignRight() {
        if (this.selectedWrapper.size() < 1) {
            return;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        int targetX = rect.x + rect.width;
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            Rectangle rect1 = wrapper.getRectangle();
            rect1.x = targetX - rect1.width;
            wrapper.setBounds(rect1);
            ++i;
        }
        this.redraw();
        this.saveCurrentAction();
    }

    public void alignTop() {
        if (this.selectedWrapper.size() < 1) {
            return;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            Rectangle rect1 = wrapper.getRectangle();
            rect1.y = rect.y;
            wrapper.setBounds(rect1);
            ++i;
        }
        this.redraw();
        this.saveCurrentAction();
    }

    public void alignBotton() {
        if (this.selectedWrapper.size() < 1) {
            return;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        int targetY = rect.y + rect.height;
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            Rectangle rect1 = wrapper.getRectangle();
            rect1.y = targetY - rect1.height;
            wrapper.setBounds(rect1);
            ++i;
        }
        this.redraw();
        this.saveCurrentAction();
    }

    public void makeSameSizeH() {
        if (this.selectedWrapper.size() < 1) {
            return;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            Rectangle rect1 = wrapper.getRectangle();
            rect1.width = rect.width;
            wrapper.setBounds(rect1);
            ++i;
        }
        this.redraw();
        this.saveCurrentAction();
    }

    public void makeSameSizeV() {
        if (this.selectedWrapper.size() < 1) {
            return;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            Rectangle rect1 = wrapper.getRectangle();
            rect1.height = rect.height;
            wrapper.setBounds(rect1);
            ++i;
        }
        this.redraw();
        this.saveCurrentAction();
    }

    public void makeSameSizeHV() {
        if (this.selectedWrapper.size() < 1) {
            return;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            Rectangle rect1 = wrapper.getRectangle();
            rect1.width = rect.width;
            rect1.height = rect.height;
            wrapper.setBounds(rect1);
            ++i;
        }
        this.redraw();
        this.saveCurrentAction();
    }

    public void makeSameSpaceH() {
        if (this.selectedWrapper.size() < 1) {
            return;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        int x0 = rect.x;
        int xe = rect.x + rect.width;
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            Rectangle rect1 = wrapper.getRectangle();
            if (x0 > rect1.x) {
                x0 = rect1.x;
            }
            if (xe < rect1.x + rect1.width) {
                xe = rect1.x + rect1.width;
            }
            ++i;
        }
        int deltX = (xe - x0) / (this.selectedWrapper.size() + 1);
        if (deltX == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i2);
            Rectangle rect1 = wrapper.getRectangle();
            rect1.x = x0 + (rect1.x - x0 + rect1.width / 2) / deltX * deltX;
            wrapper.setBounds(rect1);
            ++i2;
        }
        rect.x = x0 + (rect.x - x0 + rect.width / 2) / deltX * deltX;
        this.editor.getActivateVisualElement().setBounds(rect);
        this.redraw();
        this.saveCurrentAction();
    }

    public void makeSameSpaceV() {
        if (this.selectedWrapper.size() < 1) {
            return;
        }
        Rectangle rect = this.editor.getActivateVisualElement().getRectangle();
        int y0 = rect.y;
        int ye = rect.y + rect.height;
        int i = 0;
        while (i < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i);
            Rectangle rect1 = wrapper.getRectangle();
            if (y0 > rect1.y) {
                y0 = rect1.y;
            }
            if (ye < rect1.y + rect1.height) {
                ye = rect1.y + rect1.height;
            }
            ++i;
        }
        int deltY = (ye - y0) / (this.selectedWrapper.size() + 1);
        if (deltY == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < this.selectedWrapper.size()) {
            VisualElementWrapper wrapper = (VisualElementWrapper)this.selectedWrapper.elementAt(i2);
            Rectangle rect1 = wrapper.getRectangle();
            rect1.y = y0 + (rect1.y - y0 + rect1.height / 2) / deltY * deltY;
            wrapper.setBounds(rect1);
            ++i2;
        }
        rect.y = y0 + (rect.y - y0 + rect.height / 2) / deltY * deltY;
        this.editor.getActivateVisualElement().setBounds(rect);
        this.redraw();
        this.saveCurrentAction();
    }

    private void alignToGrid(Rectangle rect) {
        if (!this.isShowGrid) {
            return;
        }
        rect.x = rect.x / this.gridSize * this.gridSize;
        rect.y = rect.y / this.gridSize * this.gridSize;
        rect.width = rect.width / this.gridSize * this.gridSize;
        rect.height = rect.height / this.gridSize * this.gridSize;
    }

    private void alignToGrid(Point size) {
        if (!this.isShowGrid) {
            return;
        }
        size.x = size.x / this.gridSize * this.gridSize;
        size.y = size.y / this.gridSize * this.gridSize;
    }

    public void beginSetTabOrder() {
        VisualElementWrapper wrapper = this.editor.getActivateVisualElement();
        if (wrapper == null || !wrapper.getIsCanSetTabOrder()) {
            return;
        }
        if (this.isSetTabOrder) {
            this.endSetTabOrder();
        } else {
            this.cancelLink();
            this.isSetTabOrder = true;
            wrapper.setIsSetTabOrder(true);
            this.curTabOrder = 0;
            this.tabElementSize = wrapper.childs.size();
            this.redraw();
            this.editor.showStateMessage(Messages.getString("VisualEditorContentPanel.Set_component__s_tab_order,_Please_click_at_components_as_you_wanted_sequence._8"));
        }
    }

    public void setElementTabOrder(VisualElementWrapper wrapper) {
        this.editor.getActivateVisualElement().adjustTabOrder(wrapper, this.curTabOrder);
        this.editor.adjustTabOrder(wrapper, this.curTabOrder);
        ++this.curTabOrder;
        if (this.curTabOrder == this.tabElementSize) {
            this.curTabOrder = 0;
        }
        this.redraw();
    }

    public void endSetTabOrder() {
        if (!this.isSetTabOrder) {
            return;
        }
        this.editor.showStateMessage("ready.");
        this.isSetTabOrder = false;
        VisualElementWrapper wrapper = this.editor.getActivateVisualElement();
        wrapper.setIsSetTabOrder(false);
        this.redraw();
        this.saveCurrentAction();
    }

    private void paintRule(GC gc) {
        int ys;
        int xs;
        Point size = this.getSize();
        gc.fillRectangle(0, 0, size.x, 30);
        gc.fillRectangle(0, 0, 30, size.y);
        if (this.editor.getRootElement() == null) {
            return;
        }
        Color bkColor = gc.getBackground();
        gc.setBackground(this.getDisplay().getSystemColor(1));
        Rectangle rect = this.editor.getRootElement().getRectangle();
        gc.fillRectangle(rect.x - 2, 5, rect.width + 5, 21);
        gc.fillRectangle(5, rect.y - 2, 21, rect.height + 5);
        gc.setForeground(this.getDisplay().getSystemColor(16));
        gc.drawLine(rect.x - 2, 5, rect.x - 2 + rect.width + 4, 5);
        gc.drawLine(rect.x - 2, 5, rect.x - 2, 25);
        gc.drawLine(5, rect.y - 2, 5, rect.y - 2 + rect.height + 4);
        gc.drawLine(5, rect.y - 2, 25, rect.y - 2);
        gc.setForeground(this.getDisplay().getSystemColor(15));
        gc.drawLine(rect.x - 1, 24, rect.x - 2 + rect.width + 3, 24);
        gc.drawLine(rect.x + rect.width + 1, 6, rect.x + rect.width + 1, 24);
        gc.drawLine(24, rect.y - 1, 24, rect.y - 2 + rect.height + 3);
        gc.drawLine(6, rect.y + rect.height + 1, 23, rect.y + rect.height + 1);
        gc.setForeground(this.getDisplay().getSystemColor(2));
        gc.drawLine(rect.x - 1, 6, rect.x - 1 + rect.width + 2, 6);
        gc.drawLine(rect.x - 1, 6, rect.x - 1, 23);
        gc.drawLine(6, rect.y - 1, 6, rect.y - 1 + rect.height + 2);
        gc.drawLine(6, rect.y - 1, 24, rect.y - 1);
        double xOff = rect.x;
        double mr = this.editor.getXResolution() / 5.0;
        int count = 0;
        while ((xs = (int)xOff) < rect.x + rect.width) {
            if (count % 5 == 0) {
                if (count != 0) {
                    gc.drawText(String.valueOf(count / 5), xs, 7);
                }
                gc.drawLine(xs, 17, xs, 23);
            } else {
                gc.drawLine(xs, 21, xs, 23);
            }
            xOff += mr;
            ++count;
        }
        double yOff = rect.y;
        mr = this.editor.getYResolution() / 5.0;
        count = 0;
        while ((ys = (int)yOff) < rect.y + rect.height) {
            if (count % 5 == 0) {
                if (count != 0) {
                    gc.drawText(String.valueOf(count / 5), 8, ys);
                }
                gc.drawLine(17, ys, 23, ys);
            } else {
                gc.drawLine(21, ys, 23, ys);
            }
            yOff += mr;
            ++count;
        }
    }

    private void editCurrentComponent() {
        VisualElementWrapper wrapper = this.editor.getActivateVisualElement();
        if (wrapper == null) {
            return;
        }
        if (wrapper == this.editor.getRootElement()) {
            return;
        }
        Element element = wrapper.getElement();
        if (element.getEditClass() == null || element.getEditClass().length() == 0) {
            try {
                String implClass = element.getImplClass();
                ActionClassSearch test = new ActionClassSearch();
                test.selectClasses(implClass);
            }
            catch (Exception implClass) {
                // empty catch block
            }
            return;
        }
        try {
            ObjectEditor objEditor = (ObjectEditor)Class.forName(element.getEditClass()).newInstance();
            XMLNode aNode = (XMLNode)wrapper.node.clone();
            VisualElementWrapper aWrapper = new VisualElementWrapper(null, aNode, this.editor.getEditorProfile());
            aWrapper.setWrapperOwner(wrapper.getWrapperOwner());
            aWrapper.editor = wrapper.editor;
            Object result = objEditor.editObject(aWrapper, this.getShell(), Messages.getString("VisualEditorContentPanel.Edit_the_element_1"));
            if (result != null && objEditor.isChanged()) {
                XMLNode pNode = wrapper.node.getParent();
                pNode.replaceNode(wrapper.node, aNode);
                wrapper.node = aNode;
                this.editor.setActivateWrapper(this.editor.getRootElement());
                this.editor.setActivateWrapper(wrapper);
                this.redraw();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIsShowCMUnit(boolean value) {
        this.isShowCMUnit = value;
        this.redraw();
    }

    public void reset() {
        this.visualElements.clear();
        this.curUndo = 0;
        this.curUndoSize = 0;
    }
}

